/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.view;

import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import com.nvidia.cuda.ide.debug.view.OpenNewCudaInformationAction;
import com.nvidia.cuda.ide.debug.view.PresentationBooleanPropertyAction;
import com.nvidia.cuda.ide.debug.view.PresentationPropertyAction;
import com.nvidia.cuda.ide.debug.view.ToggleLinkSelectionAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPage;

public final class CudaDebugActionFactory {
    public static final String TOGGLE_LOGICAL_VIEW_ID = "actions.toggle.logical.view";
    public static final String TOGGLE_HARDWARE_VIEW_ID = "actions.toggle.hardware.view";
    public static final String TOGGLE_COALESCING = "actions.toggle.coalescing";
    public static final String TOGGLE_LINK_SELECTION = "actions.toggle.link.selection";
    public static final String OPEN_NEW_INFORMATION_VIEW = "actions.open.view";

    public static IAction createToggleCoalescingAction(IPresentationContext context) {
        return new PresentationBooleanPropertyAction(context, "coalescing.action", TOGGLE_COALESCING, "Coalesce inactive elements", null);
    }

    public static IAction createToggleLogicalViewAction(TreeModelViewer viewer) {
        return new PresentationPropertyAction(viewer, "view.mode", "logical.view.mode", true, TOGGLE_LOGICAL_VIEW_ID, "Kernels View", "Show kernels", CudaDebugImages.KERNEL.getDescriptor());
    }

    public static IAction createToggleHarwareViewAction(TreeModelViewer viewer) {
        return new PresentationPropertyAction(viewer, "view.mode", "hardware.view.mode", false, TOGGLE_HARDWARE_VIEW_ID, "GPUs View", "Show GPUs", CudaDebugImages.DEVICE.getDescriptor());
    }

    public static IAction createToggleLinkSelection(IPresentationContext context) {
        return new ToggleLinkSelectionAction(context);
    }

    public static IAction createOpenNewView(IWorkbenchPage page) {
        return new OpenNewCudaInformationAction(page);
    }
}

