/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.ui;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.ui.FindKernelsVisitor;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class CudaCFileSelectionDialog
extends FilteredResourcesSelectionDialog {
    private Label cudaKernels;

    public CudaCFileSelectionDialog(Shell shell, boolean multi, IContainer container, int typesMask) {
        super(shell, multi, container, typesMask);
    }

    protected Control createExtendedContentArea(Composite parent) {
        this.cudaKernels = new Label(parent, 0);
        return this.cudaKernels;
    }

    protected void handleSelected(StructuredSelection selection) {
        ICElement celement;
        Object element;
        super.handleSelected(selection);
        String label = "";
        if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof IFile && (celement = CoreModel.getDefault().create((IFile)element)) != null) {
            try {
                FindKernelsVisitor visitor = new FindKernelsVisitor();
                celement.accept((ICElementVisitor)visitor);
                Collection<IFunctionDeclaration> kernels = visitor.getKernels();
                if (kernels.isEmpty()) {
                    label = "No CUDA kernels";
                } else {
                    StringBuffer buffer = new StringBuffer("CUDA kernels in the selected file: ");
                    boolean prependComma = false;
                    for (IFunctionDeclaration string : kernels) {
                        if (prependComma) {
                            buffer.append(", ");
                        }
                        buffer.append(string.getElementName());
                        prependComma = true;
                    }
                    label = buffer.toString();
                }
            }
            catch (CoreException coreException) {
                Activator.getDefault();
            }
        }
        this.cudaKernels.setText(label);
        this.cudaKernels.getParent().layout(true);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new CudaCOnlyResourceFilter();
    }

    public class CudaCOnlyResourceFilter
    extends FilteredResourcesSelectionDialog.ResourceFilter {
        public CudaCOnlyResourceFilter() {
            super((FilteredResourcesSelectionDialog)CudaCFileSelectionDialog.this);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean matchItem(Object item) {
            if (super.matchItem(item)) {
                return this.isCudaCFile(item);
            }
            if (!this.isCudaCFile(item)) return false;
            ICElement element = CoreModel.getDefault().create((IFile)item);
            try {
                IFunctionDeclaration kernel;
                if (element == null) return false;
                FindKernelsVisitor visitor = new FindKernelsVisitor();
                element.accept((ICElementVisitor)visitor);
                Iterator<IFunctionDeclaration> iterator = visitor.getKernels().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return false;
                } while (!this.matches((kernel = iterator.next()).getElementName()));
                return true;
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
            return false;
        }

        private boolean isCudaCFile(Object item) {
            try {
                if (item instanceof IFile && ((IFile)item).isAccessible()) {
                    ILanguage language = LanguageManager.getInstance().getLanguageForFile((IFile)item, null);
                    return language != null && "com.nvidia.cuda.ide.editor.cudac".equals(language.getId());
                }
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
            return false;
        }
    }
}

