// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepBuilderAPI_GTransform_HeaderFile
#define _BRepBuilderAPI_GTransform_HeaderFile

#ifndef _gp_GTrsf_HeaderFile
#include <gp_GTrsf.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _BRepBuilderAPI_Collect_HeaderFile
#include <BRepBuilderAPI_Collect.hxx>
#endif
#ifndef _BRepBuilderAPI_ModifyShape_HeaderFile
#include <BRepBuilderAPI_ModifyShape.hxx>
#endif
class Standard_NoSuchObject;
class gp_GTrsf;
class TopoDS_Shape;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Geometric transformation on a shape. <br>
//! The transformation to be applied is defined as a gp_GTrsf <br>
//! transformation. It may be: <br>
//! -      a transformation equivalent to a gp_Trsf transformation, the <br>
//!    most common case: you should , however, use a BRepAPI_Transform <br>
//!    object to perform this kind of transformation; or <br>
//! -      an affinity, or <br>
//! -      more generally, any type of point transformation which may <br>
//!  be defined by a three row, four column matrix of transformation. <br>
//! In the last two cases, the underlying geometry of the <br>
//! following shapes may change: <br>
//! -      a curve which supports an edge of the shape, or <br>
//! -      a surface which supports a face of the shape; <br>
//! For example, a circle may be transformed into an ellipse when <br>
//! applying an affinity transformation. <br>
//! The transformation is applied to: <br>
//! -      all the curves which support edges of the shape, and <br>
//! -      all the surfaces which support faces of the shape. <br>
//! A GTransform object provides a framework for: <br>
//! -      defining the geometric transformation to be applied, <br>
//! -      implementing the transformation algorithm, and <br>
//! -      consulting the result. <br>
class BRepBuilderAPI_GTransform  : public BRepBuilderAPI_ModifyShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs a framework for applying the geometric <br>
//! transformation T to a shape. Use the function <br>
//! Perform to define the shape to transform. <br>
Standard_EXPORT BRepBuilderAPI_GTransform(const gp_GTrsf& T);

//! Constructs a framework for applying the geometric <br>
//! transformation T to a shape, and applies it to the shape S. <br>
//! -   If the transformation T is direct and isometric (i.e. if <br>
//!   the determinant of the vectorial part of T is equal to <br>
//!   1.), and if Copy equals false (default value), the <br>
//!   resulting shape is the same as the original but with <br>
//!   a new location assigned to it. <br>
//! -   In all other cases, the transformation is applied to <br>
//!   a duplicate of S. <br>
//! Use the function Shape to access the result. <br>
//! Note: the constructed framework can be reused to <br>
//! apply the same geometric transformation to other <br>
//! shapes: just specify them with the function Perform. <br>
Standard_EXPORT BRepBuilderAPI_GTransform(const TopoDS_Shape& S,const gp_GTrsf& T,const Standard_Boolean Copy = Standard_False);

//! Applies the geometric transformation defined at the <br>
//! time of construction of this framework to the shape S. <br>
//! -   If the transformation T is direct and isometric (i.e. if <br>
//!   the determinant of the vectorial part of T is equal to <br>
//!   1.), and if Copy equals false (default value), the <br>
//!   resulting shape is the same as the original but with <br>
//!   a new location assigned to it. <br>
//! -   In all other cases, the transformation is applied to a duplicate of S. <br>
//!   Use the function Shape to access the result. <br>
//! Note: this framework can be reused to apply the same <br>
//! geometric transformation to other shapes: just specify <br>
//! them by calling the function Perform again. <br>
Standard_EXPORT   void Perform(const TopoDS_Shape& S,const Standard_Boolean Copy = Standard_False) ;

//! Returns the list  of shapes modified from the shape <br>
//!          <S>. <br>
Standard_EXPORT virtual const TopTools_ListOfShape& Modified(const TopoDS_Shape& S) ;

//! Returns the modified shape corresponding to <S>. <br>
Standard_EXPORT virtual const TopoDS_Shape& ModifiedShape(const TopoDS_Shape& S) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_GTrsf myGTrsf;
Standard_Boolean myUseModif;
BRepBuilderAPI_Collect myHist;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
