// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepSweep_Builder_HeaderFile
#define _BRepSweep_Builder_HeaderFile

#ifndef _BRep_Builder_HeaderFile
#include <BRep_Builder.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
class BRep_Builder;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! implements the abstract Builder with the BRep Builder <br>
class BRepSweep_Builder  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a Builder. <br>
Standard_EXPORT BRepSweep_Builder(const BRep_Builder& aBuilder);

 const BRep_Builder& Builder() const;

//! Returns an empty Compound. <br>
Standard_EXPORT   void MakeCompound(TopoDS_Shape& aCompound) const;

//! Returns an empty CompSolid. <br>
Standard_EXPORT   void MakeCompSolid(TopoDS_Shape& aCompSolid) const;

//! Returns an empty Solid. <br>
Standard_EXPORT   void MakeSolid(TopoDS_Shape& aSolid) const;

//! Returns an empty Shell. <br>
Standard_EXPORT   void MakeShell(TopoDS_Shape& aShell) const;

//! Returns an empty Wire. <br>
Standard_EXPORT   void MakeWire(TopoDS_Shape& aWire) const;

//! Adds the Shape 1 in the Shape 2, set to <br>
//!          <Orient> orientation. <br>
Standard_EXPORT   void Add(TopoDS_Shape& aShape1,const TopoDS_Shape& aShape2,const TopAbs_Orientation Orient) const;

//! Adds the Shape 1 in the Shape 2. <br>
Standard_EXPORT   void Add(TopoDS_Shape& aShape1,const TopoDS_Shape& aShape2) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRep_Builder myBuilder;


};


#include <BRepSweep_Builder.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
