// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GProp_HeaderFile
#define _GProp_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class gp_Pnt;
class gp_Mat;
class GProp_GProps;
class GProp_PGProps;
class GProp_CGProps;
class GProp_CelGProps;
class GProp_SGProps;
class GProp_SelGProps;
class GProp_VGProps;
class GProp_VelGProps;
class GProp_PrincipalProps;
class GProp_CurveTool;
class GProp_FaceTool;
class GProp_DomainTool;
class GProp_PEquation;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  This package defines algorithmes to compute the global properties <br>
//!  of a set of points, a curve, a surface, a solid (non infinite <br>
//!  region of space delimited with geometric entities), a compound <br>
//!  geometric system (heterogeneous composition of the previous <br>
//!  entities). <br>
//! <br>
//!  Global properties are : <br>
//!  . length, area, volume, <br>
//!  . centre of mass, <br>
//!  . axis of inertia, <br>
//!  . moments of inertia, <br>
//!  . radius of gyration. <br>
//! <br>
//!  It provides  also a class to  compile the average point or <br>
//!  line of a set of points. <br>
class GProp  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Computes the matrix Operator, referred to as the <br>
//! "Huyghens Operator" of a geometric system at the <br>
//! point Q of the space, using the following data : <br>
//! - Mass, i.e. the mass of the system, <br>
//! - G, the center of mass of the system. <br>
//!   The "Huyghens Operator" is used to compute <br>
//! Inertia/Q, the matrix of inertia of the system at <br>
//! the point Q using Huyghens' theorem : <br>
//!    Inertia/Q = Inertia/G + HOperator (Q, G, Mass) <br>
//! where Inertia/G is the matrix of inertia of the <br>
//! system relative to its center of mass as returned by <br>
//! the function MatrixOfInertia on any GProp_GProps object. <br>
Standard_EXPORT static  void HOperator(const gp_Pnt& G,const gp_Pnt& Q,const Standard_Real Mass,gp_Mat& Operator) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class GProp_GProps;
friend class GProp_PGProps;
friend class GProp_CGProps;
friend class GProp_CelGProps;
friend class GProp_SGProps;
friend class GProp_SelGProps;
friend class GProp_VGProps;
friend class GProp_VelGProps;
friend class GProp_PrincipalProps;
friend class GProp_CurveTool;
friend class GProp_FaceTool;
friend class GProp_DomainTool;
friend class GProp_PEquation;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
