// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom2d_Vector_HeaderFile
#define _Geom2d_Vector_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom2d_Vector_HeaderFile
#include <Handle_Geom2d_Vector.hxx>
#endif

#ifndef _gp_Vec2d_HeaderFile
#include <gp_Vec2d.hxx>
#endif
#ifndef _Geom2d_Geometry_HeaderFile
#include <Geom2d_Geometry.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_DomainError;
class gp_VectorWithNullMagnitude;
class gp_Vec2d;


//!  The abstract class Vector describes the common <br>
//! behavior of vectors in 2D space. <br>
//! The Geom2d package provides two concrete <br>
//! classes of vectors: Geom2d_Direction (unit vector) <br>
//! and Geom2d_VectorWithMagnitude. <br>
class Geom2d_Vector : public Geom2d_Geometry {

public:
 // Methods PUBLIC
 // 

//! Reverses the vector <me>. <br>
Standard_EXPORT   void Reverse() ;

//! Returns a copy of <me> reversed. <br>
Standard_EXPORT   Handle_Geom2d_Vector Reversed() const;

//! Computes the angular value, in radians, between this <br>
//! vector and vector Other. The result is a value <br>
//! between -Pi and Pi. The orientation is from this <br>
//! vector to vector Other. <br>
//!    Raises VectorWithNullMagnitude if one of the two vectors is a vector with <br>
//!  null magnitude because the angular value is indefinite. <br>
Standard_EXPORT   Standard_Real Angle(const Handle(Geom2d_Vector)& Other) const;

//! Returns the coordinates of <me>. <br>
Standard_EXPORT   void Coord(Standard_Real& X,Standard_Real& Y) const;

//! Returns the  Magnitude of <me>. <br>
Standard_EXPORT virtual  Standard_Real Magnitude() const = 0;

//! Returns the square magnitude of <me>. <br>
Standard_EXPORT virtual  Standard_Real SquareMagnitude() const = 0;

//! Returns the X coordinate of <me>. <br>
Standard_EXPORT   Standard_Real X() const;

//! Returns the Y coordinate of <me>. <br>
Standard_EXPORT   Standard_Real Y() const;

//! Cross product of <me> with the vector <Other>. <br>
Standard_EXPORT virtual  Standard_Real Crossed(const Handle(Geom2d_Vector)& Other) const = 0;

//! Returns the scalar product of 2 Vectors. <br>
Standard_EXPORT   Standard_Real Dot(const Handle(Geom2d_Vector)& Other) const;

//! Returns a non persistent copy of <me>. <br>
Standard_EXPORT   gp_Vec2d Vec2d() const;
//Standard_EXPORT ~Geom2d_Vector();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
gp_Vec2d gpVec2d;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
