// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSelect_AddFileComment_HeaderFile
#define _IGESSelect_AddFileComment_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSelect_AddFileComment_HeaderFile
#include <Handle_IGESSelect_AddFileComment.hxx>
#endif

#ifndef _Handle_TColStd_HSequenceOfHAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#endif
#ifndef _IGESSelect_FileModifier_HeaderFile
#include <IGESSelect_FileModifier.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TColStd_HSequenceOfHAsciiString;
class IFSelect_ContextWrite;
class IGESData_IGESWriter;
class TCollection_AsciiString;


//! This class allows to add comment lines on writing an IGES File <br>
//!           These lines are added to Start Section, instead of the only <br>
//!           one blank line written by default. <br>
class IGESSelect_AddFileComment : public IGESSelect_FileModifier {

public:
 // Methods PUBLIC
 // 

//! Creates a new emoty AddFileComment. Use AddLine to complete it <br>
Standard_EXPORT IGESSelect_AddFileComment();

//! Clears the list of file comment lines already stored <br>
Standard_EXPORT   void Clear() ;

//! Adds a line for file comment <br>
//!  Remark : Lines are limited to 72 useful char.s . A line of more than <br>
//!           72 char.s will be splited into several ones of 72 max each. <br>
Standard_EXPORT   void AddLine(const Standard_CString line) ;

//! Adds a list of lines for file comment <br>
//!           Each of them must comply with demand of AddLine <br>
Standard_EXPORT   void AddLines(const Handle(TColStd_HSequenceOfHAsciiString)& lines) ;

//! Returns the count of stored lines <br>
Standard_EXPORT   Standard_Integer NbLines() const;

//! Returns a stored line given its rank <br>
Standard_EXPORT   Standard_CString Line(const Standard_Integer num) const;

//! Returns the complete list of lines in once <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfHAsciiString Lines() const;

//! Sends the comment lines to the file (Start Section) <br>
Standard_EXPORT   void Perform(IFSelect_ContextWrite& ctx,IGESData_IGESWriter& writer) const;

//! Returns specific Label, which is <br>
//!           "Add <nn> Comment Lines (Start Section)" <br>
Standard_EXPORT   TCollection_AsciiString Label() const;
//Standard_EXPORT ~IGESSelect_AddFileComment();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TColStd_HSequenceOfHAsciiString thelist;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
