// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Law_BSplineKnotSplitting_HeaderFile
#define _Law_BSplineKnotSplitting_HeaderFile

#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_Law_BSpline_HeaderFile
#include <Handle_Law_BSpline.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TColStd_HArray1OfInteger;
class Standard_DimensionError;
class Standard_RangeError;
class Law_BSpline;
class TColStd_Array1OfInteger;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  For a B-spline curve the discontinuities are localised at the <br>
//!  knot values and between two knots values the B-spline is <br>
//!  infinitely continuously differentiable. <br>
//!  At a knot of range index the continuity is equal to : <br>
//!  Degree - Mult (Index)   where  Degree is the degree of the <br>
//!  basis B-spline functions and Mult the multiplicity of the knot <br>
//!  of range Index. <br>
//!  If for your computation you need to have B-spline curves with a <br>
//!  minima of continuity it can be interesting to know between which <br>
//!  knot values, a B-spline curve arc, has a continuity of given order. <br>
//!  This algorithm computes the indexes of the knots where you should <br>
//!  split the curve, to obtain arcs with a constant continuity given <br>
//!  at the construction time. The splitting values are in the range <br>
//!  [FirstUKnotValue, LastUKnotValue] (See class B-spline curve from <br>
//!  package Geom). <br>
//!  If you just want to compute the local derivatives on the curve you <br>
//!  don't need to create the B-spline curve arcs, you can use the <br>
//!  functions LocalD1, LocalD2, LocalD3, LocalDN of the class <br>
//!  BSplineCurve. <br>
class Law_BSplineKnotSplitting  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//!  Locates the knot values which correspond to the segmentation of <br>
//!  the curve into arcs with a continuity equal to ContinuityRange. <br>
//!  Raised if ContinuityRange is not greater or equal zero. <br>
Standard_EXPORT Law_BSplineKnotSplitting(const Handle(Law_BSpline)& BasisLaw,const Standard_Integer ContinuityRange);


//!  Returns the number of knots corresponding to the splitting. <br>
Standard_EXPORT   Standard_Integer NbSplits() const;


//!  Returns the indexes of the BSpline curve knots corresponding to <br>
//!  the splitting. <br>
//!  Raised if the length of SplitValues is not equal to NbSPlit. <br>
Standard_EXPORT   void Splitting(TColStd_Array1OfInteger& SplitValues) const;


//!  Returns the index of the knot corresponding to the splitting <br>
//!  of range Index. <br>
//!  Raised if Index < 1 or Index > NbSplits <br>
Standard_EXPORT   Standard_Integer SplitValue(const Standard_Integer Index) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TColStd_HArray1OfInteger splitIndexes;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
