// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _OSD_DirectoryIterator_HeaderFile
#define _OSD_DirectoryIterator_HeaderFile

#ifndef _OSD_Directory_HeaderFile
#include <OSD_Directory.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _OSD_Error_HeaderFile
#include <OSD_Error.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class OSD_OSDError;
class OSD_Path;
class TCollection_AsciiString;
class OSD_Directory;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Manages a breadth-only search for sub-directories in the specified <br>
//!          Path. <br>
//!          There is no specific order of results. <br>
class OSD_DirectoryIterator  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Instantiates Object as empty Iterator; <br>
Standard_EXPORT OSD_DirectoryIterator();

//! Instantiates Object as Iterator. <br>
//!          Wild-card "*" can be used in Mask the same way it <br>
//!          is used by unix shell for file names <br>
Standard_EXPORT OSD_DirectoryIterator(const OSD_Path& where,const TCollection_AsciiString& Mask);


Standard_EXPORT   void Destroy() ;
~OSD_DirectoryIterator()
{
  Destroy();
}


//! Initializes the current File Directory <br>
Standard_EXPORT   void Initialize(const OSD_Path& where,const TCollection_AsciiString& Mask) ;

//! Returns TRUE if other items are found while <br>
//!          using the 'Tree' method. <br>
Standard_EXPORT   Standard_Boolean More() ;

//! Sets the iterator to the next item. <br>
//!          Returns the item value corresponding to the current <br>
//!          position of the iterator. <br>
Standard_EXPORT   void Next() ;

//! Returns the next item found . <br>
Standard_EXPORT   OSD_Directory Values() ;

//! Returns TRUE if an error occurs <br>
Standard_EXPORT   Standard_Boolean Failed() const;

//! Resets error counter to zero <br>
Standard_EXPORT   void Reset() ;

//! Raises OSD_Error <br>
Standard_EXPORT   void Perror() ;

//! Returns error number if 'Failed' is TRUE. <br>
Standard_EXPORT   Standard_Integer Error() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
OSD_Directory TheIterator;
Standard_Integer myFlag;
TCollection_AsciiString myMask;
TCollection_AsciiString myPlace;
Standard_Address myDescr;
Standard_Address myEntry;
Standard_Integer myInit;
OSD_Error myError;
Standard_Integer myHandle;
Standard_Address myData;
Standard_Boolean myFirstCall;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
