// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeCustom_Surface_HeaderFile
#define _ShapeCustom_Surface_HeaderFile

#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Geom_Surface;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Converts a surface to the analitical form with given <br>
//!          precision. Conversion is done only the surface is bspline <br>
//!          of bezier and this can be approximed by some analytical <br>
//!          surface with that precision. <br>
class ShapeCustom_Surface  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT ShapeCustom_Surface();


Standard_EXPORT ShapeCustom_Surface(const Handle(Geom_Surface)& S);


Standard_EXPORT   void Init(const Handle(Geom_Surface)& S) ;
//! Returns maximal deviation of converted surface from the original <br>
//!          one computed by last call to ConvertToAnalytical <br>
  Standard_Real Gap() const;

//! Tries to convert the Surface to an Analytic form <br>
//!          Returns the result <br>
//!          Works only if the Surface is BSpline or Bezier. <br>
//!          Else, or in case of failure, returns a Null Handle <br>
Standard_EXPORT   Handle_Geom_Surface ConvertToAnalytical(const Standard_Real tol,const Standard_Boolean substitute) ;

//! Tries to convert the Surface to the Periodic form <br>
//!          Returns the resulting surface <br>
//!          Works only if the Surface is BSpline and is closed with <br>
//!          Precision::Confusion() <br>
//!          Else, or in case of failure, returns a Null Handle <br>
Standard_EXPORT   Handle_Geom_Surface ConvertToPeriodic(const Standard_Boolean substitute,const Standard_Real preci = -1) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom_Surface mySurf;
Standard_Real myGap;


};


#include <ShapeCustom_Surface.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
