// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeProcess_Context_HeaderFile
#define _ShapeProcess_Context_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeProcess_Context_HeaderFile
#include <Handle_ShapeProcess_Context.hxx>
#endif

#ifndef _Handle_Resource_Manager_HeaderFile
#include <Handle_Resource_Manager.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfHAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#endif
#ifndef _Handle_Message_Printer_HeaderFile
#include <Handle_Message_Printer.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Resource_Manager;
class TColStd_HSequenceOfHAsciiString;
class Message_Printer;
class TCollection_AsciiString;


//! Provides convenient interface to resource file <br>
//!          Allows to load resource file and get values of <br>
//!          attributes starting from some scope, for example <br>
//!          if scope is defined as "ToV4" and requested parameter <br>
//!          is "exec.op", value of "ToV4.exec.op" parameter from <br>
//!          the resource file will be returned <br>
class ShapeProcess_Context : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates an empty tool <br>
Standard_EXPORT ShapeProcess_Context();

//! Creates a new tool and initialises by name of <br>
//!          resource file and (if specified) starting scope <br>
//!          Calls method Init() <br>
Standard_EXPORT ShapeProcess_Context(const Standard_CString file,const Standard_CString scope = "");

//! Initialises a tool by loading resource file and <br>
//!          (if specified) sets starting scope <br>
//!          Returns False if resource file not found <br>
Standard_EXPORT   Standard_Boolean Init(const Standard_CString file,const Standard_CString scope = "") ;

//! Loading Resource_Manager object if this object not <br>
//!          equal internal static Resource_Manager object or <br>
//!          internal static Resource_Manager object is null <br>
Standard_EXPORT   Handle_Resource_Manager LoadResourceManager(const Standard_CString file) ;

//! Returns internal Resource_Manager object <br>
Standard_EXPORT  const Handle_Resource_Manager& ResourceManager() const;

//! Set a new (sub)scope <br>
Standard_EXPORT   void SetScope(const Standard_CString scope) ;

//! Go out of current scope <br>
Standard_EXPORT   void UnSetScope() ;

//! Returns True if parameter is defined in the resource file <br>
Standard_EXPORT   Standard_Boolean IsParamSet(const Standard_CString param) const;


Standard_EXPORT   Standard_Boolean GetReal(const Standard_CString param,Standard_Real& val) const;


Standard_EXPORT   Standard_Boolean GetInteger(const Standard_CString param,Standard_Integer& val) const;


Standard_EXPORT   Standard_Boolean GetBoolean(const Standard_CString param,Standard_Boolean& val) const;

//! Get value of parameter as being of specific type <br>
//!          Returns False if parameter is not defined or has a wrong type <br>
Standard_EXPORT   Standard_Boolean GetString(const Standard_CString param,TCollection_AsciiString& val) const;


Standard_EXPORT   Standard_Real RealVal(const Standard_CString param,const Standard_Real def) const;


Standard_EXPORT   Standard_Integer IntegerVal(const Standard_CString param,const Standard_Integer def) const;


Standard_EXPORT   Standard_Boolean BooleanVal(const Standard_CString param,const Standard_Boolean def) const;

//! Get value of parameter as being of specific type <br>
//!          If parameter is not defined or does not have expected <br>
//!          type, returns default value as specified <br>
Standard_EXPORT   Standard_CString StringVal(const Standard_CString param,const Standard_CString def) const;

//! Sets Printer used for outputting messages. <br>
Standard_EXPORT   void SetPrinter(const Handle(Message_Printer)& printer) ;

//! Returns Printer used for outputting messages. <br>
Standard_EXPORT   Handle_Message_Printer Printer() const;


Standard_EXPORT   void SetTraceLevel(const Standard_Integer level) ;


Standard_EXPORT   Standard_Integer TraceLevel() const;
//Standard_EXPORT ~ShapeProcess_Context();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Resource_Manager myRC;
Handle_TColStd_HSequenceOfHAsciiString myScope;
Handle_Message_Printer myPrinter;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
