// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Transfer_FinderProcess_HeaderFile
#define _Transfer_FinderProcess_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Transfer_FinderProcess_HeaderFile
#include <Handle_Transfer_FinderProcess.hxx>
#endif

#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Transfer_ProcessForFinder_HeaderFile
#include <Transfer_ProcessForFinder.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_Transfer_TransientMapper_HeaderFile
#include <Handle_Transfer_TransientMapper.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Transfer_Finder_HeaderFile
#include <Handle_Transfer_Finder.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Interface_InterfaceModel;
class Transfer_TransientMapper;
class Standard_Transient;
class Transfer_Finder;


//! Adds specific features to the generic definition : <br>
//!           PrintTrace is adapted <br>
class Transfer_FinderProcess : public Transfer_ProcessForFinder {

public:
 // Methods PUBLIC
 // 

//! Sets FinderProcess at initial state, with an initial size <br>
Standard_EXPORT Transfer_FinderProcess(const Standard_Integer nb = 10000);

//! Sets an InterfaceModel, which can be used during transfer <br>
//!           for instance if a context must be managed, it is in the Model <br>
Standard_EXPORT   void SetModel(const Handle(Interface_InterfaceModel)& model) ;

//! Returns the Model which can be used for context <br>
Standard_EXPORT   Handle_Interface_InterfaceModel Model() const;

//! In the list of mapped items (between 1 and NbMapped), <br>
//!           searches for the first mapped item which follows <num0> <br>
//!           (not included) and which has an attribute named <name> <br>
//!           The considered Attributes are those brought by Finders,i.e. <br>
//!           by Input data. <br>
//!           While NextItemWithAttribute works on Result data (Binders) <br>
//! <br>
//!           Hence, allows such an iteration <br>
//! <br>
//!           for (num = FP->NextMappedWithAttribute(name,0); <br>
//!                num > 0; <br>
//!                num = FP->NextMappedWithAttribute(name,num) { <br>
//!                .. process mapped item <num> <br>
//!           } <br>
Standard_EXPORT   Standard_Integer NextMappedWithAttribute(const Standard_CString name,const Standard_Integer num0) const;

//! Returns a TransientMapper for a given Transient Object <br>
//!           Either <obj> is already mapped, then its Mapper is returned <br>
//!           Or it is not, then a new one is created then returned, BUT <br>
//!             it is not mapped here (use Bind or FindElseBind to do this) <br>
Standard_EXPORT   Handle_Transfer_TransientMapper TransientMapper(const Handle(Standard_Transient)& obj) const;

//! Specific printing to trace a Finder (by its method ValueType) <br>
Standard_EXPORT virtual  void PrintTrace(const Handle(Transfer_Finder)& start,Standard_OStream& S) const;

//! Prints statistics on a given output, according mode <br>
Standard_EXPORT   void PrintStats(const Standard_Integer mode,Standard_OStream& S) const;
//Standard_EXPORT ~Transfer_FinderProcess();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Interface_InterfaceModel themodel;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
