// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Visual3d_PickPath_HeaderFile
#define _Visual3d_PickPath_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Graphic3d_Structure_HeaderFile
#include <Handle_Graphic3d_Structure.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Graphic3d_Structure;
class Visual3d_PickError;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! PickPath is a vector ( pick_id, struct_id, elem_num ). <br>
//!	    It's one of the constituents of a PickDescriptor. <br>
//!	    There are many PickPaths in a PickDescriptor. <br>
//!	    Each PickPath describes a structure or a sub-structure. <br>
//!	    The pick_id is set by SetPickId method from Group. <br>
class Visual3d_PickPath  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an undefined PickPath. <br>
Standard_EXPORT Visual3d_PickPath();

//! Creates a PickPath : <br>
//!	    <AElemNumber> : Element number of the structure picked. <br>
//!	    <APickId>	  : Pick identifier of the structure picked. <br>
//!	    <AStructure>  : The picked structure. <br>
Standard_EXPORT Visual3d_PickPath(const Standard_Integer AElemNumber,const Standard_Integer APickId,const Handle(Graphic3d_Structure)& AStructure);

//! Modifies the PickPath <me>. <br>
//!	    <AElemNumber> : Element number of the structure picked. <br>
Standard_EXPORT   void SetElementNumber(const Standard_Integer AElemNumber) ;

//! Modifies the PickPath <me>. <br>
//!	    <APickId>	  : Pick identifier of the structure picked. <br>
Standard_EXPORT   void SetPickIdentifier(const Standard_Integer APickId) ;

//! Modifies the PickPath <me>. <br>
//!	    <AStructure>	: Identifier of the structure picked. <br>
Standard_EXPORT   void SetStructIdentifier(const Handle(Graphic3d_Structure)& AStructure) ;

//! Returns the element number stocked in the PickPath <me>. <br>
//!  Category: Inquire methods <br>
//!  Warning: Raises PickError if PickPath is empty (no picked structure). <br>
Standard_EXPORT   Standard_Integer ElementNumber() const;

//! Returns the pick identifier stocked in the PickPath <me>. <br>
//!  Category: Inquire methods <br>
//!  Warning: Raises PickError if PickPath is empty (no picked structure). <br>
Standard_EXPORT   Standard_Integer PickIdentifier() const;

//! Returns the structure stocked in the PickPath <me>. <br>
//!  Category: Inquire methods <br>
//!  Warning: Raises PickError if PickPath is empty (no picked structure). <br>
Standard_EXPORT   Handle_Graphic3d_Structure StructIdentifier() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer MyElementNumber;
Standard_Integer MyPickId;
Handle_Graphic3d_Structure MyStructure;
Standard_Boolean MyElementNumberIsDef;
Standard_Boolean MyPickIdIsDef;
Standard_Boolean MyStructureIsDef;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
