// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_GaussSetIntegration_HeaderFile
#define _math_GaussSetIntegration_HeaderFile

#ifndef _math_Vector_HeaderFile
#include <math_Vector.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class Standard_NotImplemented;
class math_FunctionSet;
class math_Vector;
class math_IntegerVector;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! -- This class implements the integration of a set of N <br>
//!              functions of M  variables variables between the <br>
//!              parameter bounds Lower[a..b] and Upper[a..b]. <br>
//!  Warning: - The case M>1 is not implemented. <br>
class math_GaussSetIntegration  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! The Gauss-Legendre integration with Order = points of <br>
//! integration for each unknow, is done on the function F <br>
//! between the bounds Lower and Upper. <br>
Standard_EXPORT math_GaussSetIntegration(math_FunctionSet& F,const math_Vector& Lower,const math_Vector& Upper,const math_IntegerVector& Order);
//! returns True if all has been correctly done. <br>
  Standard_Boolean IsDone() const;
//! returns the value of the integral. <br>
 const math_Vector& Value() const;

//! Prints information on the current state of the object. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
math_Vector Val;
Standard_Boolean Done;


};


#include <math_GaussSetIntegration.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
