// File:	TopoDS_Builder3D.cxx
// Created:	Thu Apr 11 16:57:00 1991
// Author:	Remi LEQUETTE
//		<rle@phobox>


#include <TopoDS_Builder3D.ixx>
#include <TopoDS_TShell.hxx>
#include <TopoDS_TSolid.hxx>
#include <TopoDS_TCompSolid.hxx>


//=======================================================================
//function : TopoDS_Builder3D
//purpose  : constructor
//=======================================================================

TopoDS_Builder3D::TopoDS_Builder3D () 
{
}


//=======================================================================
//function : MakeShell
//purpose  : Make an empty Shell
//=======================================================================

void TopoDS_Builder3D::MakeShell (TopoDS_Shell& S) const
{
  Handle(TopoDS_TShell) TS = new TopoDS_TShell();
  MakeShape(S,TS);
}

//=======================================================================
//function : MakeSolid
//purpose  : Make an empty Solid
//=======================================================================

void TopoDS_Builder3D::MakeSolid (TopoDS_Solid& S) const
{
  Handle(TopoDS_TSolid) TS = new TopoDS_TSolid();
  MakeShape(S,TS);
}

//=======================================================================
//function : MakeCompSolid
//purpose  : Make an empty CompSolid
//=======================================================================

void TopoDS_Builder3D::MakeCompSolid (TopoDS_CompSolid& C) const
{
  Handle(TopoDS_TCompSolid) TC = new TopoDS_TCompSolid();
  MakeShape(C,TC);
}

