// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AIS_LocalContext_HeaderFile
#define _AIS_LocalContext_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_AIS_LocalContext_HeaderFile
#include <Handle_AIS_LocalContext.hxx>
#endif

#ifndef _Handle_AIS_InteractiveContext_HeaderFile
#include <Handle_AIS_InteractiveContext.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_SelectMgr_SelectionManager_HeaderFile
#include <Handle_SelectMgr_SelectionManager.hxx>
#endif
#ifndef _Handle_StdSelect_ViewerSelector3d_HeaderFile
#include <Handle_StdSelect_ViewerSelector3d.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentationManager3d_HeaderFile
#include <Handle_PrsMgr_PresentationManager3d.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _AIS_DataMapOfSelStat_HeaderFile
#include <AIS_DataMapOfSelStat.hxx>
#endif
#ifndef _Handle_SelectMgr_OrFilter_HeaderFile
#include <Handle_SelectMgr_OrFilter.hxx>
#endif
#ifndef _TColStd_ListOfInteger_HeaderFile
#include <TColStd_ListOfInteger.hxx>
#endif
#ifndef _Handle_SelectMgr_Filter_HeaderFile
#include <Handle_SelectMgr_Filter.hxx>
#endif
#ifndef _SelectMgr_IndexedMapOfOwner_HeaderFile
#include <SelectMgr_IndexedMapOfOwner.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TColStd_SequenceOfInteger_HeaderFile
#include <TColStd_SequenceOfInteger.hxx>
#endif
#ifndef _AIS_SequenceOfInteractive_HeaderFile
#include <AIS_SequenceOfInteractive.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_AIS_InteractiveObject_HeaderFile
#include <Handle_AIS_InteractiveObject.hxx>
#endif
#ifndef _AIS_InteractiveContext_HeaderFile
#include <AIS_InteractiveContext.hxx>
#endif
#ifndef _AIS_ClearMode_HeaderFile
#include <AIS_ClearMode.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _AIS_StatusOfDetection_HeaderFile
#include <AIS_StatusOfDetection.hxx>
#endif
#ifndef _Handle_V3d_View_HeaderFile
#include <Handle_V3d_View.hxx>
#endif
#ifndef _AIS_StatusOfPick_HeaderFile
#include <AIS_StatusOfPick.hxx>
#endif
#ifndef _Handle_SelectMgr_EntityOwner_HeaderFile
#include <Handle_SelectMgr_EntityOwner.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Quantity_NameOfColor_HeaderFile
#include <Quantity_NameOfColor.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_AIS_LocalStatus_HeaderFile
#include <Handle_AIS_LocalStatus.hxx>
#endif
#ifndef _Handle_SelectMgr_SelectableObject_HeaderFile
#include <Handle_SelectMgr_SelectableObject.hxx>
#endif
class AIS_InteractiveContext;
class SelectMgr_SelectionManager;
class StdSelect_ViewerSelector3d;
class PrsMgr_PresentationManager3d;
class SelectMgr_OrFilter;
class SelectMgr_Filter;
class AIS_InteractiveObject;
class TCollection_AsciiString;
class Select3D_Projector;
class TColStd_ListOfInteger;
class SelectMgr_ListOfFilter;
class V3d_View;
class TColgp_Array1OfPnt2d;
class TopoDS_Shape;
class SelectMgr_EntityOwner;
class Standard_Transient;
class TColStd_MapOfTransient;
class AIS_LocalStatus;
class SelectMgr_SelectableObject;


//! Defines a specific context  for selection. <br>
//!          It becomes possible to: <br>
//!          +  Load  InteractiveObjects  with   a mode   to be <br>
//!          activated +  associate InteractiveObjects   with a <br>
//!          set of  temporary   selectable Objects....   +   + <br>
//!          activate StandardMode  of selection  for  Entities <br>
//!          inheriting  BasicShape  from  AIS (Selection    Of <br>
//!          vertices, edges,   wires,faces...  + Add   Filters <br>
//!          acting on detected owners of sensitive primitives <br>
//! <br>
//! <br>
//!          -     automatically    highlight   shapes   and <br>
//!          InteractiveObjects  (highlight of  detected shape + <br>
//!          highlight of detected selectable... <br>
//! <br>
class AIS_LocalContext : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT AIS_LocalContext();

//! Constructor By Default, the  displayed objects are <br>
//!          automatically loaded. <br>
Standard_EXPORT AIS_LocalContext(const Handle(AIS_InteractiveContext)& aCtx,const Standard_Integer anIndex,const Standard_Boolean LoadDisplayed = Standard_True,const Standard_Boolean AcceptStandardModes = Standard_True,const Standard_Boolean AcceptErase = Standard_False,const Standard_Boolean UseBothViewers = Standard_False);
//! authorize or not others contexts to erase <br>
//!          temporary displayed objects here; <br>
  void AcceptErase(const Standard_Boolean aStatus) ;

  Standard_Boolean AcceptErase() const;


Standard_EXPORT   void SetContext(const Handle(AIS_InteractiveContext)& aCtx) ;

 const TCollection_AsciiString& SelectionName() const;


Standard_EXPORT   void Terminate(const Standard_Boolean updateviewer = Standard_True) ;

//! compares the current projector of the localContext <br>
//!          with <aPrj> <br>
//!          returns True if the projectors are identical. <br>
//!          (no need to update projection of selection primitives <br>
//!          when closing the local context).... <br>
Standard_EXPORT   Standard_Boolean HasSameProjector(const Select3D_Projector& aPrj) const;

//! to be called when a upper local context was closed... <br>
//!          useful to put pack the right projector... <br>
Standard_EXPORT   void Reactivate() ;

//! returns true if done... <br>
Standard_EXPORT   Standard_Boolean Display(const Handle(AIS_InteractiveObject)& anInteractive,const Standard_Integer DisplayMode = 0,const Standard_Boolean AllowShapeDecomposition = Standard_True,const Standard_Integer ActivationMode = 0) ;

//! loads <anInteractive> with nodisplay... <br>
//!          returns true if done <br>
Standard_EXPORT   Standard_Boolean Load(const Handle(AIS_InteractiveObject)& anInteractive,const Standard_Boolean AllowShapeDecomposition = Standard_True,const Standard_Integer ActivationMode = 0) ;

//! returns true if done... <br>
Standard_EXPORT   Standard_Boolean Erase(const Handle(AIS_InteractiveObject)& anInteractive) ;


Standard_EXPORT   Standard_Boolean Remove(const Handle(AIS_InteractiveObject)& aSelectable) ;


Standard_EXPORT   Standard_Boolean ClearPrs(const Handle(AIS_InteractiveObject)& anInteractive,const Standard_Integer aMode) ;

//! allows  or  forbids   the   shape  decomposition  into <br>
//!          Activated Standard   Mode  for   <aStoredObject> <br>
//!          does nothing if the object doesn't inherits <br>
//!          BasicShape from AIS <br>
Standard_EXPORT   void SetShapeDecomposition(const Handle(AIS_InteractiveObject)& aStoredObject,const Standard_Boolean aStatus) ;

//! according to <atype>  , clears the  different parts of <br>
//!          the selector (filters, modeof activation, objects...) <br>
Standard_EXPORT   void Clear(const AIS_ClearMode atype = AIS_CM_All) ;

//! optional : activation of a mode which is not 0 for a selectable... <br>
Standard_EXPORT   void ActivateMode(const Handle(AIS_InteractiveObject)& aSelectable,const Standard_Integer aMode) ;


Standard_EXPORT   void DeactivateMode(const Handle(AIS_InteractiveObject)& aSelectable,const Standard_Integer aMode) ;


Standard_EXPORT   void Deactivate(const Handle(AIS_InteractiveObject)& aSelectable) ;

//! decomposition of shapes into <aType> <br>
Standard_EXPORT   void ActivateStandardMode(const TopAbs_ShapeEnum aType) ;


Standard_EXPORT   void DeactivateStandardMode(const TopAbs_ShapeEnum aType) ;

 const TColStd_ListOfInteger& StandardModes() const;


Standard_EXPORT   void AddFilter(const Handle(SelectMgr_Filter)& aFilter) ;


Standard_EXPORT   void RemoveFilter(const Handle(SelectMgr_Filter)& aFilter) ;

 const SelectMgr_ListOfFilter& ListOfFilter() const;

 const Handle_SelectMgr_OrFilter& Filter() const;
//! if <aStatus> = True , the shapes or subshapes detected <br>
//!          by the selector will be automatically hilighted in the <br>
//!          main viewer. <br>
//!          Else the user has to manage the detected shape outside the <br>
//!          Shape Selector.... <br>
  void SetAutomaticHilight(const Standard_Boolean aStatus) ;

  Standard_Boolean AutomaticHilight() const;


Standard_EXPORT   AIS_StatusOfDetection MoveTo(const Standard_Integer Xpix,const Standard_Integer Ypix,const Handle(V3d_View)& aview) ;
//! returns True if more than one entity <br>
//!          was detected at the last Mouse position. <br>
  Standard_Boolean HasNextDetected() const;

//! returns True if  last detected. the next detected will <br>
//!          be first one (endless loop) <br>
Standard_EXPORT   Standard_Integer HilightNextDetected(const Handle(V3d_View)& aView) ;


Standard_EXPORT   Standard_Integer HilightPreviousDetected(const Handle(V3d_View)& aView) ;

//! returns True if something was done... <br>
Standard_EXPORT   Standard_Boolean UnhilightLastDetected(const Handle(V3d_View)& aView) ;

//! returns the number of selected <br>
Standard_EXPORT   AIS_StatusOfPick Select(const Standard_Boolean updateviewer = Standard_True) ;


Standard_EXPORT   AIS_StatusOfPick ShiftSelect(const Standard_Boolean updateviewer = Standard_True) ;


Standard_EXPORT   AIS_StatusOfPick Select(const Standard_Integer XPMin,const Standard_Integer YPMin,const Standard_Integer XPMax,const Standard_Integer YPMax,const Handle(V3d_View)& aView,const Standard_Boolean updateviewer = Standard_True) ;


Standard_EXPORT   AIS_StatusOfPick ShiftSelect(const Standard_Integer XPMin,const Standard_Integer YPMin,const Standard_Integer XPMax,const Standard_Integer YPMax,const Handle(V3d_View)& aView,const Standard_Boolean updateviewer = Standard_True) ;


Standard_EXPORT   AIS_StatusOfPick Select(const TColgp_Array1OfPnt2d& Polyline,const Handle(V3d_View)& aView,const Standard_Boolean updateviewer = Standard_True) ;


Standard_EXPORT   AIS_StatusOfPick ShiftSelect(const TColgp_Array1OfPnt2d& Polyline,const Handle(V3d_View)& aView,const Standard_Boolean updateviewer = Standard_True) ;


Standard_EXPORT   void HilightPicked(const Standard_Boolean updateviewer = Standard_True) ;


Standard_EXPORT   void UnhilightPicked(const Standard_Boolean updateviewer = Standard_True) ;


Standard_EXPORT   void UpdateSelected(const Standard_Boolean updateviewer = Standard_True) ;

//! Part of advanced selection highlighting mechanism. <br>
//!          If no owners belonging to anobj are selected, calls anobj->ClearSelected(), <br>
//!          otherwise calls anobj->HilightSelected(). This method can be used to avoid <br>
//!          redrawing the whole selection belonging to several Selectable Objects. <br>
Standard_EXPORT   void UpdateSelected(const Handle(AIS_InteractiveObject)& anobj,const Standard_Boolean updateviewer = Standard_True) ;

//! useful  to  update selection with objects  coming from <br>
//!          Collector or stack <br>
Standard_EXPORT   void SetSelected(const Handle(AIS_InteractiveObject)& anobj,const Standard_Boolean updateviewer = Standard_True) ;

//! useful  to  update selection with objects  coming from <br>
//!          Collector or stack <br>
Standard_EXPORT   void AddOrRemoveSelected(const Handle(AIS_InteractiveObject)& anobj,const Standard_Boolean updateviewer = Standard_True) ;


Standard_EXPORT   void AddOrRemoveSelected(const TopoDS_Shape& aShape,const Standard_Boolean updateviewer = Standard_True) ;


Standard_EXPORT   void AddOrRemoveSelected(const Handle(SelectMgr_EntityOwner)& Ownr,const Standard_Boolean updateviewer = Standard_True) ;


Standard_EXPORT   void ClearSelected(const Standard_Boolean updateviewer = Standard_True) ;

  Standard_Boolean HasDetected() const;


Standard_EXPORT   void InitDetected() ;


Standard_EXPORT   Standard_Boolean MoreDetected() const;


Standard_EXPORT   void NextDetected() ;


Standard_EXPORT  const TopoDS_Shape& DetectedCurrentShape() const;


Standard_EXPORT   Handle_AIS_InteractiveObject DetectedCurrentObject() const;


Standard_EXPORT   Standard_Boolean HasDetectedShape() const;


Standard_EXPORT  const TopoDS_Shape& DetectedShape() const;


Standard_EXPORT   Handle_AIS_InteractiveObject DetectedInteractive() const;


Standard_EXPORT   Handle_SelectMgr_EntityOwner DetectedOwner() const;


Standard_EXPORT   void InitSelected() ;


Standard_EXPORT   Standard_Boolean MoreSelected() const;


Standard_EXPORT   void NextSelected() ;

//! returns TRUE if the detected entity is a shape <br>
//!          coming from a Decomposition of an element. <br>
Standard_EXPORT   Standard_Boolean HasShape() const;


Standard_EXPORT  const TopoDS_Shape& SelectedShape() const;


Standard_EXPORT   Handle_SelectMgr_EntityOwner SelectedOwner() const;


Standard_EXPORT   Standard_Boolean IsSelected(const Handle(AIS_InteractiveObject)& aniobj) const;


Standard_EXPORT   Standard_Boolean IsSelected(const Handle(SelectMgr_EntityOwner)& anOwner) const;


Standard_EXPORT   Handle_AIS_InteractiveObject SelectedInteractive() const;

//! returns TRUE if an interactive element <br>
//!          was associated with the current picked entity. <br>
Standard_EXPORT   Standard_Boolean HasApplicative() const;


Standard_EXPORT  const Handle_Standard_Transient& SelectedApplicative() const;


Standard_EXPORT   void SetDisplayPriority(const Handle(AIS_InteractiveObject)& anObject,const Standard_Integer Prior) ;


Standard_EXPORT   Standard_Integer DisplayedObjects(TColStd_MapOfTransient& theMapToFill) const;


Standard_EXPORT   Standard_Boolean IsIn(const Handle(AIS_InteractiveObject)& anObject) const;


Standard_EXPORT   Standard_Boolean IsDisplayed(const Handle(AIS_InteractiveObject)& anObject) const;


Standard_EXPORT   Standard_Boolean IsDisplayed(const Handle(AIS_InteractiveObject)& anObject,const Standard_Integer aMode) const;


Standard_EXPORT  const TColStd_ListOfInteger& SelectionModes(const Handle(AIS_InteractiveObject)& anObject) const;


Standard_EXPORT   void SubIntensityOn(const Handle(AIS_InteractiveObject)& anObject) ;


Standard_EXPORT   void SubIntensityOff(const Handle(AIS_InteractiveObject)& anObject) ;


Standard_EXPORT   void Hilight(const Handle(AIS_InteractiveObject)& anObject) ;


Standard_EXPORT   void Hilight(const Handle(AIS_InteractiveObject)& anObject,const Quantity_NameOfColor aCol) ;


Standard_EXPORT   void Unhilight(const Handle(AIS_InteractiveObject)& anObject) ;


Standard_EXPORT   Standard_Boolean IsHilighted(const Handle(AIS_InteractiveObject)& anObject) const;


Standard_EXPORT   Standard_Boolean IsHilighted(const Handle(AIS_InteractiveObject)& anObject,Standard_Boolean& WithColor,Quantity_NameOfColor& HiCol) const;

//! Define the current selection sensitivity for <br>
//!          this local context according to the view size. <br>
Standard_EXPORT   void SetSensitivity(const Standard_Real aPrecision) ;

//! Define the current selection sensitivity for <br>
//!          this local context according to the view size. <br>
Standard_EXPORT   void SetSensitivity(const Standard_Integer aPrecision = 2) ;

//! initializes the list of presentations to be displayed <br>
//!          returns False if No Local COnte <br>
Standard_EXPORT   Standard_Boolean BeginImmediateDraw() ;

//! returns True if <anIObj> has been stored in the list. <br>
Standard_EXPORT   Standard_Boolean ImmediateAdd(const Handle(AIS_InteractiveObject)& anIObj,const Standard_Integer aMode = 0) ;

//! returns True if <anIObj> has been removed from the list. <br>
Standard_EXPORT   Standard_Boolean ImmediateRemove(const Handle(AIS_InteractiveObject)& anIObj,const Standard_Integer aMode = 0) ;

//! returns True if the immediate display has been done. <br>
Standard_EXPORT   Standard_Boolean EndImmediateDraw(const Handle(V3d_View)& aView,const Standard_Boolean DoubleBuf = Standard_False) ;


Standard_EXPORT   Standard_Boolean IsImmediateModeOn() const;


Standard_EXPORT   void UpdateConversion() ;


Standard_EXPORT   void UpdateSort() ;


Standard_EXPORT   void LoadContextObjects() ;


Standard_EXPORT   void UnloadContextObjects() ;


Standard_EXPORT   void DisplayAreas(const Handle(V3d_View)& aviou) ;


Standard_EXPORT   void ClearAreas(const Handle(V3d_View)& aView) ;


Standard_EXPORT   void DisplaySensitive(const Handle(V3d_View)& aView) ;


Standard_EXPORT   void ClearSensitive(const Handle(V3d_View)& aView) ;

 const Handle_StdSelect_ViewerSelector3d& MainSelector() const;
//Standard_EXPORT ~AIS_LocalContext();


friend 
//! Changes the status of a temporary object. It will be <br>
//! kept at the neutral point, i.e. put in the list of <br>
//! displayed   objects along withwith   its temporary <br>
//! attributes. These include display mode and <br>
//! selection   mode, for example. <br>
//! Returns true if done. <br>
//! inWhichLocal gives the local context in which anIObj <br>
//! is displayed. By default, the index -1 refers to the last <br>
//! Local Context opened. <br>
Standard_EXPORT   Standard_Boolean AIS_InteractiveContext::KeepTemporary(const Handle(AIS_InteractiveObject)& anIObj,const Standard_Integer InWhichLocal) ;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   TCollection_AsciiString Status() const;


Standard_EXPORT  const Handle_AIS_LocalStatus& Status(const Handle(AIS_InteractiveObject)& anObject) const;


Standard_EXPORT   void Process(const Handle(SelectMgr_SelectableObject)& anObject,const Standard_Boolean WithProj = Standard_True) ;


Standard_EXPORT   void Process(const Standard_Boolean WithProj = Standard_True) ;


Standard_EXPORT   void ActivateStandardModes(const Handle(SelectMgr_SelectableObject)& anObject,const Standard_Boolean WithProj = Standard_True) ;


Standard_EXPORT   void ManageDetected(const Handle(SelectMgr_EntityOwner)& aPickOwner,const Handle(V3d_View)& aview) ;
//! returns 0  if the detected entity was Not FilterOK... <br>
  Standard_Integer DetectedIndex() ;


Standard_EXPORT   void Hilight(const Handle(SelectMgr_EntityOwner)& Own,const Handle(V3d_View)& aview) ;


Standard_EXPORT   void Unhilight(const Handle(SelectMgr_EntityOwner)& Ownr,const Handle(V3d_View)& aview) ;


Standard_EXPORT   void ClearObjects() ;


Standard_EXPORT   void ClearDetected() ;


Standard_EXPORT   Standard_Boolean IsDecompositionOn() const;


Standard_EXPORT   Standard_Boolean IsShape(const Standard_Integer anIndex) const;


Standard_EXPORT   Standard_Boolean IsValidForSelection(const Handle(AIS_InteractiveObject)& anIObj) const;

  Standard_Boolean IsValidIndex(const Standard_Integer anIndex) const;


Standard_EXPORT   Standard_Boolean ComesFromDecomposition(const Standard_Integer aPickedIndex) const;


Standard_EXPORT   Standard_Boolean HasFilters(const TopAbs_ShapeEnum aType) const;


Standard_EXPORT   void HilightTriangle(const Standard_Integer Rank,const Handle(V3d_View)& aViou) ;


Standard_EXPORT   Handle_SelectMgr_EntityOwner FindSelectedOwnerFromIO(const Handle(AIS_InteractiveObject)& anIObj) const;


Standard_EXPORT   Handle_SelectMgr_EntityOwner FindSelectedOwnerFromShape(const TopoDS_Shape& aShape) const;


 // Fields PRIVATE
 //
Handle_AIS_InteractiveContext myCTX;
Standard_Boolean myLoadDisplayed;
Standard_Boolean myAcceptStdMode;
Standard_Boolean myAcceptErase;
Handle_SelectMgr_SelectionManager mySM;
Handle_StdSelect_ViewerSelector3d myMainVS;
Handle_PrsMgr_PresentationManager3d myMainPM;
TCollection_AsciiString mySelName;
Handle_StdSelect_ViewerSelector3d myCollVS;
AIS_DataMapOfSelStat myActiveObjects;
Handle_SelectMgr_OrFilter myFilters;
TColStd_ListOfInteger myListOfStandardMode;
Handle_SelectMgr_Filter myStdFilters[9];
Standard_Boolean myAutoHilight;
SelectMgr_IndexedMapOfOwner myMapOfOwner;
Standard_Integer mylastindex;
Standard_Integer mylastgood;
Standard_Integer myCurrentOwner;
TColStd_SequenceOfInteger myDetectedSeq;
Standard_Integer myCurDetected;
AIS_SequenceOfInteractive myAISDetectedSeq;
Standard_Integer myAISCurDetected;


};


#include <AIS_LocalContext.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
