// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepFeat_Builder_HeaderFile
#define _BRepFeat_Builder_HeaderFile

#ifndef _LocOpe_Builder_HeaderFile
#include <LocOpe_Builder.hxx>
#endif
#ifndef _TopTools_MapOfShape_HeaderFile
#include <TopTools_MapOfShape.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
#ifndef _BRepBuilderAPI_MakeShape_HeaderFile
#include <BRepBuilderAPI_MakeShape.hxx>
#endif
class StdFail_NotDone;
class Standard_ConstructionError;
class TopoDS_Shape;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides  the   implementation  of  all    methods <br>
//!          required by BRepCtx for class using a Builder from <br>
//!          LocOpe.  All  features have  to inherit  from this <br>
//!          class. <br>
class BRepFeat_Builder  : public BRepBuilderAPI_MakeShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! Initializes a local operation on <S>. <br>
  void Init(const TopoDS_Shape& S) ;
//! Initializes a local operation between <S> and <T>. <br>
//! Raises ConstructionError if <S> is a null shape. <br>
  void Init(const TopoDS_Shape& S,const TopoDS_Shape& T) ;

//! Returns the list of generated Faces. <br>
Standard_EXPORT  const TopTools_ListOfShape& Modified(const TopoDS_Shape& F) ;





protected:

 // Methods PROTECTED
 // 
//! Empty constructor. <br>
BRepFeat_Builder();
//! Creates a local operation on <S>. <br>
BRepFeat_Builder(const TopoDS_Shape& S);
//! Creates a local operation between <S> and <T>. <br>
BRepFeat_Builder(const TopoDS_Shape& S,const TopoDS_Shape& T);


 // Fields PROTECTED
 //
LocOpe_Builder myBuilder;
TopTools_MapOfShape myMap;
TopTools_ListOfShape myGenFaces;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <BRepFeat_Builder.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
