// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESData_IGESDumper_HeaderFile
#define _IGESData_IGESDumper_HeaderFile

#ifndef _Handle_IGESData_IGESModel_HeaderFile
#include <Handle_IGESData_IGESModel.hxx>
#endif
#ifndef _IGESData_SpecificLib_HeaderFile
#include <IGESData_SpecificLib.hxx>
#endif
#ifndef _Handle_IGESData_Protocol_HeaderFile
#include <Handle_IGESData_Protocol.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
#ifndef _Handle_Message_Messenger_HeaderFile
#include <Handle_Message_Messenger.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class IGESData_IGESModel;
class Interface_InterfaceError;
class IGESData_Protocol;
class IGESData_IGESEntity;
class Message_Messenger;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides a way to obtain a clear Dump of an IGESEntity <br>
//!           (distinct from normalized output). It works with tools <br>
//!           attached to Entities, as for normalized Reade and Write <br>
//! <br>
//!           For each Entity, displaying data is splitted in own data <br>
//!           (specific to each type) and other attached data, which are <br>
//!           defined for all IGES Types (either from "Directory Entry" or <br>
//!           from Lists of Associativities and Properties) <br>
class IGESData_IGESDumper  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Returns an IGESDumper ready to work. The IGESModel provides <br>
//!           the numbering of Entities : as for any InterfaceModel, it <br>
//!           gives each Entity a number; but for IGESEntities, the "Number <br>
//!           of Directory Entry" according to the definition of IGES Files, <br>
//!           is also usefull <br>
Standard_EXPORT IGESData_IGESDumper(const Handle(IGESData_IGESModel)& model,const Handle(IGESData_Protocol)& protocol);

//! Prints onto an output, the "Number of Directory Entry" which <br>
//!           corresponds to an IGESEntity in the IGESModel, under the form <br>
//!           "D#nnn" (a Null Handle gives D#0) <br>
Standard_EXPORT   void PrintDNum(const Handle(IGESData_IGESEntity)& ent,const Handle(Message_Messenger)& S) const;

//! Prints onto an output, the "Number of Directory Entry" (see <br>
//!           PrintDNum) plus IGES Type and Form Numbers, which gives <br>
//!           "D#nnn  Type nnn  Form nnn" <br>
Standard_EXPORT   void PrintShort(const Handle(IGESData_IGESEntity)& ent,const Handle(Message_Messenger)& S) const;


Standard_EXPORT   void Dump(const Handle(IGESData_IGESEntity)& ent,const Handle(Message_Messenger)& S,const Standard_Integer own,const Standard_Integer attached = -1) const;

//! Specific Dump for each IGES Entity, call by Dump (just above) <br>
//!           <own> is the parameter <own> from Dump <br>
Standard_EXPORT   void OwnDump(const Handle(IGESData_IGESEntity)& ent,const Handle(Message_Messenger)& S,const Standard_Integer own) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_IGESData_IGESModel themodel;
IGESData_SpecificLib thelib;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
