// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Select3D_SensitivePoint_HeaderFile
#define _Select3D_SensitivePoint_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Select3D_SensitivePoint_HeaderFile
#include <Handle_Select3D_SensitivePoint.hxx>
#endif

#ifndef _Select3D_Pnt_HeaderFile
#include <Select3D_Pnt.hxx>
#endif
#ifndef _Select3D_Pnt2d_HeaderFile
#include <Select3D_Pnt2d.hxx>
#endif
#ifndef _Select3D_SensitiveEntity_HeaderFile
#include <Select3D_SensitiveEntity.hxx>
#endif
#ifndef _Handle_SelectBasics_EntityOwner_HeaderFile
#include <Handle_SelectBasics_EntityOwner.hxx>
#endif
#ifndef _Handle_Select3D_SensitiveEntity_HeaderFile
#include <Handle_Select3D_SensitiveEntity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class SelectBasics_EntityOwner;
class gp_Pnt;
class Select3D_Projector;
class SelectBasics_ListOfBox2d;
class Select3D_SensitiveEntity;
class TopLoc_Location;
class TColgp_Array1OfPnt2d;
class Bnd_Box2d;
class gp_Lin;


//! A framework to define sensitive 3D points. <br>
class Select3D_SensitivePoint : public Select3D_SensitiveEntity {

public:
 // Methods PUBLIC
 // 

//! Constructs a sensitive point object defined by the <br>
//! owner OwnerId and the point Point. <br>
Standard_EXPORT Select3D_SensitivePoint(const Handle(SelectBasics_EntityOwner)& OwnerId,const gp_Pnt& Point);

//!Converts the stored 3D point into a 2D point according <br>
//!         to <aProjector> ; this method is called by the selection Manager. <br>
Standard_EXPORT   void Project(const Select3D_Projector& aProjector) ;

//! stores in <aresult> the 2D sensitive box which represents <br>
//!          the point area in the selection process. <br>
Standard_EXPORT   void Areas(SelectBasics_ListOfBox2d& aresult) ;


Standard_EXPORT   Handle_Select3D_SensitiveEntity GetConnected(const TopLoc_Location& aLocation) ;

//! returns true if the X,Y position matches the point <br>
//!          else gives the distance between them. <br>
Standard_EXPORT   Standard_Boolean Matches(const Standard_Real X,const Standard_Real Y,const Standard_Real aTol,Standard_Real& DMin) ;


Standard_EXPORT   Standard_Boolean Matches(const Standard_Real XMin,const Standard_Real YMin,const Standard_Real XMax,const Standard_Real YMax,const Standard_Real aTol) ;


Standard_EXPORT virtual  Standard_Boolean Matches(const TColgp_Array1OfPnt2d& Polyline,const Bnd_Box2d& aBox,const Standard_Real aTol) ;


Standard_EXPORT   Standard_Real ComputeDepth(const gp_Lin& EyeLine) const;

//! Returns the point used at the time of construction. <br>
Standard_EXPORT   gp_Pnt Point() const;


Standard_EXPORT virtual  void Dump(Standard_OStream& S,const Standard_Boolean FullDump = Standard_True) const;
//Standard_EXPORT ~Select3D_SensitivePoint();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Select3D_Pnt mypoint;
Select3D_Pnt2d myprojpt;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
