// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TNaming_Scope_HeaderFile
#define _TNaming_Scope_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TDF_LabelMap_HeaderFile
#include <TDF_LabelMap.hxx>
#endif
#ifndef _Handle_TNaming_NamedShape_HeaderFile
#include <Handle_TNaming_NamedShape.hxx>
#endif
class TDF_LabelMap;
class TDF_Label;
class TopoDS_Shape;
class TNaming_NamedShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! this class manage a scope of labels <br>
//!          =================================== <br>
class TNaming_Scope  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! WithValid = FALSE <br>
Standard_EXPORT TNaming_Scope();

//! if <WithValid> the scope is defined by the map. If not <br>
//!          on the whole framework. <br>
Standard_EXPORT TNaming_Scope(const Standard_Boolean WithValid);

//! create a scope with a map. WithValid = TRUE. <br>
Standard_EXPORT TNaming_Scope(TDF_LabelMap& valid);


Standard_EXPORT   Standard_Boolean WithValid() const;


Standard_EXPORT   void WithValid(const Standard_Boolean mode) ;


Standard_EXPORT   void ClearValid() ;


Standard_EXPORT   void Valid(const TDF_Label& L) ;


Standard_EXPORT   void ValidChildren(const TDF_Label& L,const Standard_Boolean withroot = Standard_True) ;


Standard_EXPORT   void Unvalid(const TDF_Label& L) ;


Standard_EXPORT   void UnvalidChildren(const TDF_Label& L,const Standard_Boolean withroot = Standard_True) ;


Standard_EXPORT   Standard_Boolean IsValid(const TDF_Label& L) const;


Standard_EXPORT  const TDF_LabelMap& GetValid() const;


Standard_EXPORT   TDF_LabelMap& ChangeValid() ;

//!  Returns  the current  value of  <NS> according to the <br>
//!          Valid Scope. <br>
Standard_EXPORT   TopoDS_Shape CurrentShape(const Handle(TNaming_NamedShape)& NS) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myWithValid;
TDF_LabelMap myValid;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
