
#include <Xw_Extension.h>

	/* ifdef then trace on */
#ifdef TRACE
#define TRACE_OPEN_WINDOW
#define TRACE_OPEN_DISPLAY
#endif

/*
   Aspect_Handle Xw_open_window (adisplay,class,parent,sxc,syc,
				swidth,sheight,title,istransparent):
   XW_EXT_DISPLAY *adisplay Extended Display structure
   Xw_TypeOfVisual class ;	must be one of : 
			Xw_TOV_STATICGRAY,
			Xw_TOV_GRAYSCALE,
			Xw_TOV_STATICCOLOR,
			Xw_TOV_PSEUDOCOLOR,
			Xw_TOV_TRUECOLOR,
			Xw_TOV_DIRECTCOLOR,
			Xw_TOV_DEFAULT
			Xw_TOV_PREFERRED_PSEUDOCOLOR,
			Xw_TOV_PREFERRED_TRUECOLOR
   Aspect_Handle	parent ; Parent Window (ROOT if 0)

   float sxc,syc ;  	Window center position in [0,1] space
   float swidth,sheight   Window size in [0,1] space
   char *title ;	Banner Title NULL if default.
   int istransparent	TRUE for transparent window

	Create the window depending of the requested visual class
	on the specified display name

	returns XW_ERROR if Display string or Visual class is wrong
        returns his ID if successful .

*/

#define BORDER 0

#ifdef XW_PROTOTYPE
Aspect_Handle Xw_open_window (
                void* 		adisplay,
		Xw_TypeOfVisual aclass	,
		Aspect_Handle		parent  ,
		float 		sxc	,
		float 		syc	,
		float 		swidth	,
		float 		sheight	,
		char*		title	,
		int		istransparent)
#else
Aspect_Handle Xw_open_window (adisplay,aclass,parent,sxc,syc,swidth,sheight,title,istransparent)
void *adisplay ;
Xw_TypeOfVisual aclass ;
Aspect_Handle parent ;
float sxc,syc,swidth,sheight ;   
char *title ;
int istransparent ;
#endif /*XW_PROTOTYPE*/
{
XW_EXT_DISPLAY *pdisplay = (XW_EXT_DISPLAY*)adisplay ;
Window window ;
XSetWindowAttributes wattr ;
XVisualInfo *ginfo ;
//char *name ;
//int i,px,py,pxc,pyc,pwidth,pheight;
int px,py,pxc,pyc,pwidth,pheight;
unsigned long mask = 0 ;

        if( !Xw_isdefine_display(pdisplay) ) {
            /*ERROR*Bad EXT_DISPLAY Address*/
            Xw_set_error(96,"Xw_open_window",pdisplay) ;
//            return (NULL) ;
            return (0) ;
        }

	if( swidth <= 0. || sheight <= 0. ) {
	    /*ERROR*Coordinate must be in [0,1] space*/
	    Xw_set_error(91,"Xw_open_window",0) ;
	    return (0) ;
	}

	ginfo = Xw_get_visual_info(pdisplay,aclass) ;
	if( !ginfo ) return (0) ;

	if( parent ) {
	    XWindowAttributes attributes ;

            if( !XGetWindowAttributes(_DDISPLAY,parent,&attributes) ) {
                /*ERROR*Bad Window Attributes*/
                Xw_set_error(54,"Xw_open_window",&parent) ;
                return (0) ;
            }
	    pwidth = (int)(swidth*min(attributes.width,attributes.height)) ;
	    pheight = (int)(sheight*min(attributes.width,attributes.height)) ;
	    pxc = (int)(sxc*(float)attributes.width) ;
	    pyc = (int)((1.-syc)*(float)attributes.height) ;
	    if( (pxc - pwidth/2) < 0 )  pxc = pwidth/2;
	    if( (pxc + pwidth/2) > attributes.width ) 
					pxc = attributes.width - pwidth/2;
	    if( (pyc - pheight/2) < 0 ) pyc = pheight/2 ;
	    if( (pyc + pheight/2) > attributes.height ) 
					pyc = attributes.height - pheight/2;
	    wattr.override_redirect = True ; mask |= CWOverrideRedirect ;
	} else {
	    parent = _DROOT ;
	    pwidth = (int)(swidth*min(_DWIDTH,_DHEIGHT)) ;
	    pheight = (int)(sheight*min(_DWIDTH,_DHEIGHT)) ;
	    pxc = (int)(sxc*(float)_DWIDTH) ;
	    pyc = (int)((1.-syc)*(float)_DHEIGHT) ;
	    if( (pxc - pwidth/2) < 0 )  pxc = pwidth/2 ;
	    if( (pxc + pwidth/2) > _DWIDTH ) pxc = _DWIDTH - pwidth/2;
	    if( (pyc - pheight/2) < 0 ) pyc = pheight/2 ;
	    if( (pyc + pheight/2) > _DHEIGHT ) pyc = _DHEIGHT - pheight/2;
	}
        px = pxc - pwidth/2 ;
        py = pyc - pheight/2 ;

	wattr.event_mask 	= ExposureMask | StructureNotifyMask ;
						mask |= CWEventMask ;
	wattr.backing_store 	= NotUseful ; 
						mask |= CWBackingStore ;
 	wattr.border_pixel 	= 
				WhitePixel(_DDISPLAY,DefaultScreen(_DDISPLAY));
						mask |= CWBorderPixel ;
	if( !istransparent ) {
	  wattr.background_pixel 	= 
				BlackPixel(_DDISPLAY,DefaultScreen(_DDISPLAY));
						mask |= CWBackPixel ;
	}
	wattr.colormap = XCreateColormap(_DDISPLAY,parent,
						ginfo->visual,AllocNone) ;
						mask |= CWColormap ;

        window = XCreateWindow (_DDISPLAY, parent,
                                px, py, pwidth, pheight, BORDER,
                                ginfo->depth, InputOutput, ginfo->visual,
                                mask, &wattr);

	if( window && (parent == _DROOT) ) {
	  XSizeHints hints ;
	  hints.x = px; hints.y = py ; hints.flags = PPosition ;
	  hints.width = pwidth ; hints.height = pheight ; hints.flags |= PSize;
	  XSetStandardProperties (_DDISPLAY, window, title, title, None,
						NULL, 0, &hints) ;
	}

	XFree((char*)ginfo) ;

	XFlush(_DDISPLAY) ;

#ifdef  TRACE_OPEN_WINDOW
	if( Xw_get_trace() ) {
	    printf (" %lx = Xw_open_window(%lx,%d,%f,%f,%f,%f,'%s')\n",
			(long ) window,(long ) adisplay,aclass,sxc,syc,swidth,sheight,title);
	}
#endif

	return (window);
}
