TEMPLATE = app
CONFIG += debug_and_release qt 

TARGET = Tutorial
CONFIG(debug, debug|release) {
    DESTDIR = ./Linux/bind
    OBJECTS_DIR = ./Linux/objd
    MOC_DIR = ./Linux/srcd
} else {
    DESTDIR = ./Linux/bin
    OBJECTS_DIR = ./Linux/obj
    MOC_DIR = ./Linux/src
}

HEADERS = src/*.h
SOURCES = src/*.cxx

TRANSLATIONS += ./src/Common-icon.ts \
                ./src/Common-string.ts \
                ./src/Tutorial-icon.ts \
                ./src/Tutorial-string.ts

INCLUDEPATH = $(CASROOT) $(CASROOT)/inc $(CASROOT)/src/WOKTclLib $(QTDIR)/include/QtCore \
              $(QTDIR)/include/QtGui $(QTDIR)/include \
              /usr/X11R6/include

LIBS = -L$(QTDIR)/lib -lQtCore -lQtGui -lpthread \ 
       -L$(CASROOT)/Linux/lib -lTKernel -lPTKernel -lTKMath -lTKService -lTKV3d -lTKV2d \
       -lTKBRep -lTKIGES -lTKSTL -lTKVRML -lTKSTEP -lTKSTEPAttr -lTKSTEP209 \
       -lTKSTEPBase -lTKShapeSchema -lTKGeomBase -lTKGeomAlgo -lTKG3d -lTKG2d \
       -lTKXSBase -lTKPShape -lTKShHealing -lTKHLR -lTKTopAlgo -lTKMesh -lTKPrim \
       -lTKCDF -lTKBool -lTKBO -lTKFillet -lTKOffset\ 
       -L/usr/X11R6/lib -lX11 -lGL

DEFINES = LIN LININTEL CSFDB OCC_CONVERT_SIGNALS HAVE_CONFIG_H HAVE_WOK_CONFIG_H

lrelease.name = LRELASE ${QMAKE_FILE_IN}
lrelease.commands = $(QTDIR)/bin/lrelease ${QMAKE_FILE_NAME} -qm ./res/${QMAKE_FILE_BASE}.qm
lrelease.output = ./res/${QMAKE_FILE_BASE}.qm
lrelease.input = TRANSLATIONS
lrelease.clean = ./res/${QMAKE_FILE_BASE}.qm
lrelease.CONFIG += no_link target_predeps
QMAKE_EXTRA_COMPILERS += lrelease
