////////////////////////////////////////////////////////////////////////////////
//
// Here we start the class DialogCreate.
// This class handles the generation, and display of the images.
//
////////////////////////////////////////////////////////////////////////////////
#include <stdlib.h>

#include <qtabwidget.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <qprocess.h>
#include <qprogressbar.h>
#include <qlabel.h>
#include <qdialog.h>
#include <qcombobox.h>

#include "dialogcreate.h"
#include "xml_slideshow.h"

DialogCreate::DialogCreate(QWidget * parent, const char * name, WFlags f)
	: uiDialogCreate (parent, name, f)
{
	m_iProgressCounter = 0;
	m_pProgress->setTotalSteps (100);
	m_pMainDialog = parent;
//	m_pTextOutput->setMaxLogLines (50);
	connect (m_pButtonGenerate, SIGNAL(clicked()), this, SLOT(slotGenerate()));
	findDVDSlideshow();
}

DialogCreate::~DialogCreate()
{

}

void DialogCreate::setXmlSlideshow (CXmlSlideshow *pSlideshow, QString qsTempPath)
{
	m_qsTempPath = qsTempPath;
	if (!qsTempPath.isEmpty())
		m_pEditTempDir->setText(qsTempPath);

	if (!pSlideshow)
		return;
	// copy the original CXmlSlideshow over. THis way we can
	// play around with the names etc.
	m_Slideshow = *pSlideshow;
}

QString & DialogCreate::getOutputFileName ()
{
	return m_qsOutputFileName;
}

void DialogCreate::setOutputFileName (QString &qsOutputFileName)
{
	m_qsOutputFileName = qsOutputFileName;
	m_pEditOutputFileName->setText(qsOutputFileName);
}

void DialogCreate::slotGenerate ()
{
	m_iProgressCounter = 0;
	QFileInfo fileInfo;
	m_pMainDialog->show();	// bug in Qt. When main dialog is hidden it will close the whole application when pressing OK of a QMessageBox.
	if (!sanityCheck())	{
		m_pMainDialog->hide();	// bug in Qt. When main dialog is hidden it will close the whole application when pressing OK of a QMessageBox.
		return;	// try again
	}
	m_pMainDialog->hide();	// bug in Qt. When main dialog is hidden it will close the whole application when pressing OK of a QMessageBox.
	m_Slideshow.slideshow_name = m_pEditSlideshowTitle->text();
	emit (signalSetSlideshowEntry(m_Slideshow.slideshow_name));
	preprocessSlideshow();
	createDVDSlideshowFile();
	m_pTabWidget->setCurrentPage (1);
	m_pEditTotalNumber->setText (QString("%1").arg(m_Slideshow.count()+2));
	m_pEditImageNumber->setText ("0");
	fileInfo.setFile(m_Slideshow.getImg(0)->src);
	m_pEditCurrentFileName->setText(fileInfo.fileName());
	m_pButtonGenerate->setEnabled(false);
	// and finally we execute dvd-slideshow.
	executeDVDSlideshow();
}

bool DialogCreate::sanityCheck()
{
	// first we check if we can write to the temp directory specified ...
	QString qsTestFile = m_pEditTempDir->text() + QString("/writeCheck.txt");
	QFile theFile(qsTestFile);
	theFile.open(IO_WriteOnly);
	QTextStream theStream( &theFile );
	theStream << "Test" << "\n";
	theFile.close ();

	QFileInfo fileInfo (qsTestFile);
	if (!fileInfo.exists())	{
		QMessageBox::about (NULL, tr ("Could not write"),
		tr ("Attention, I could not write to the temp directory.\n\n"
			"Please make sure the name is correct and you have read/write\n"
			"permission to this directory.\n"));
		m_pEditTempDir->setPaletteBackgroundColor (QColor(255,0,0));
			return false;
	}
	m_pEditTempDir->setPaletteBackgroundColor (QColor(255,255,255));
	// second check if the dvd-slideshow is on the noted place.
	// The standard libraries are not in the ld.so.conf file ?!?!!?
	QString qsDVDSlideshow = m_pEditExecutableDir->text();
	if (qsDVDSlideshow.find (QString ("dvd-slideshow"), 0, FALSE) == -1)
		qsDVDSlideshow += "/dvd-slideshow";
	fileInfo = QFileInfo (qsDVDSlideshow);
	if (!fileInfo.exists())	{
		QMessageBox::about (NULL, tr ("dvd-slideshow not found"),
		tr ("Attention, I could not find the dvd-slideshow bash script.\n\n"
			"Please make sure you gave the correct location.\n"));
		m_pEditExecutableDir->setPaletteBackgroundColor (QColor(255,0,0));
		return false;
	}
	if (!fileInfo.isExecutable())	{
		QMessageBox::about (NULL, tr ("Can not execute dvd-slideshow"),
		tr ("Attention, I found dvd-slideshow but it is not executable.\n\n"
			"Please change the file properties.\n"));
		m_pEditExecutableDir->setPaletteBackgroundColor (QColor(255,0,0));
		return false;
	}
	m_pEditExecutableDir->setPaletteBackgroundColor (QColor(255,255,255));
	if (m_pEditOutputFileName->text().isEmpty())	{
		QMessageBox::about (NULL, tr ("No output file name"),
		tr ("Attention, I could not find a output file name.\n\n"
			"Please specify a Output file.\n"));
		m_pEditOutputFileName->setPaletteBackgroundColor (QColor(255,0,0));
		return false;
	}
	fileInfo.setFile(m_pEditOutputFileName->text());
	if (fileInfo.exists())	{
		if (QMessageBox::information (NULL, tr ("Output file exists already"),
		tr ("Attention, I the specified Output file exists already.\n\n"
			"Are you sure you want to overwrite this file ?\n"),
			QMessageBox::Yes ,  QMessageBox::No) == QMessageBox::No)
		m_pEditOutputFileName->setPaletteBackgroundColor (QColor(255,0,0));
					return false;
	}
	m_pEditOutputFileName->setPaletteBackgroundColor (QColor(255,255,255));
	return true;
}

void DialogCreate::findDVDSlideshow()
{
	// this function tries to locate the dvd-slideshow bash script.
	QFileInfo fileInfo;
	// The standard libraries are not in the ld.so.conf file ?!?!!?
	fileInfo = QFileInfo (QDir::currentDirPath() + QString ("/dvd-slideshow"));
	if (fileInfo.exists())	{
		m_pEditExecutableDir->setText(QDir::currentDirPath());
		return;
	}
	fileInfo = QFileInfo (QString ("/bin/dvd-slideshow"));
	if (fileInfo.exists())	{
		m_pEditExecutableDir->setText("/bin");
		return;
	}
	fileInfo = QFileInfo (QString ("/usr/bin/dvd-slideshow"));
	if (fileInfo.exists())	{
		m_pEditExecutableDir->setText("/usr/bin");
		return;
	}
	fileInfo = QFileInfo (QString ("/usr/local/bin/dvd-slideshow"));
	if (fileInfo.exists())	{
		m_pEditExecutableDir->setText("/usr/local/bin");
		return;
	}
	fileInfo = QFileInfo (QDir::homeDirPath() + QString ("/bin/dvd-slideshow"));
	if (fileInfo.exists())	{
		m_pEditExecutableDir->setText(QDir::homeDirPath() + QString("/bin"));
		return;
	}
	// Here we go through all directories in the PATH variable.
	QString qsPath = QString(getenv("PATH"));
	QStringList list = QStringList::split( ":", qsPath );
	for (uint t=0; t<list.count();t++)	{
		fileInfo = QFileInfo (list[t] + QString ("/dvd-slideshow"));
		if (fileInfo.exists())	{
			m_pEditExecutableDir->setText(list[t]);
			return;
		}
	}
	m_pEditExecutableDir->setText(QString("not found"));
}

// How to get CXmlSlideshow - structure ...
void DialogCreate::preprocessSlideshow()
{
	// this function pre-processes the images.
	// The user might have chosen to rotate/shear/change color,
	// change brightness, add background etc.

	// m_Slideshow is the temp CXmlSlideshow struct,
	// to hold the names of the pre-processed images,
	// rather then the original file names.
	m_pTextStatus->setText (tr("Preprocessing images"));
	uint t, iImgCount;
	// This function creates the dvd-slideshow file and puts it into the temp directory.
	iImgCount = m_Slideshow.countImg(); 
	for (t=0;t<iImgCount;t++)	{

		m_pProgress->setProgress ((int)((float)t/iImgCount * 100.0));
	}
	m_pProgress->setProgress (0);
}

void DialogCreate::createDVDSlideshowFile()
{
	uint iTitleDelay = 10;
	uint t;
	int iTemp;

	CXmlSlideshow::time_object *pTimeObject;
	CXmlSlideshow::img_struct *pImg;
	CXmlSlideshow::filter_struct *pFilter;
//	QString qsSlideshowFile = m_pEditTempDir->text() + QString ("/slideshow.in");
	QString qsSlideshowFile = m_pEditTempDir->text() + QString ("/") + m_pEditSlideshowTitle->text() + QString (".in");
	QFile theFile (qsSlideshowFile);
	theFile.open (IO_WriteOnly);
	QTextStream theStream( &theFile );
	int iDelay = m_Slideshow.delay;
	int iFilterDelay = m_Slideshow.filter_delay;
	// Here we create the title ...
	theStream << "title:" << iTitleDelay << ":" << m_pEditSlideshowTitle->text() << "\n";
	for (t=0;t<m_Slideshow.count();t++)	{
		pTimeObject = m_Slideshow.getTimeObject(t);
		if (pTimeObject->node_name == "img")	{
			pImg = (CXmlSlideshow::img_struct *)pTimeObject;
			iTemp = (int)(pImg->fDuration+0.5);
			if (iTemp < 0.5)
				iTemp = iDelay;
			theStream << pImg->src << ":" << iTemp << ":" << pImg->text << "\n";
		}
		else	{
			pFilter = (CXmlSlideshow::filter_struct *)pTimeObject;
			iTemp = (pFilter->fDuration < 0.5) ? iFilterDelay : (int)(pFilter->fDuration+0.5);
			theStream << pFilter->name << ":" << iTemp << ":" << pFilter->subtitle << "\n";
		}
	}
	theFile.close ();
}
/* example file ...
title:10:Preparing for Our Journey
~scott/images/Picture_013.jpg:5:Me loading the car
fadeout:3
background:2:
fadein:2
~scott/images/Picture_069.jpg:3:Us getting ready
crossfade:1
~scott/images/Picture_073.jpg:5:John and friends
fadeout:3
*/
void DialogCreate::executeDVDSlideshow()
{
	m_pTextStatus->setText (tr("Processing images"));
	// Here we create a new thread to handle the generation in the background.
	// This Thread shoud be completely independand of the parent thread.
	QString qsDVDSlideshow = m_pEditExecutableDir->text();
	// add the name of the executable only if needed.
	if (qsDVDSlideshow.find ("dvd-slideshow", 0, FALSE) == -1)
		qsDVDSlideshow += QString ("/dvd-slideshow");
	QString qsCommand;

	QStringList listArgs;
	listArgs.append(qsDVDSlideshow);	// the executable itself

	if (m_pComboFormat->currentItem() == 0)// Generate PAL ???
		listArgs.append(QString ("-p"));
	listArgs.append(QString ("-o"));
	listArgs.append(m_pEditTempDir->text());	// the output dir name
	listArgs.append(QString ("-n"));
	listArgs.append(m_pEditOutputFileName->text());	// The output FileName
	listArgs.append(QString ("-f"));
	// the generated inputFileName
	listArgs.append(m_pEditTempDir->text() + QString ("/") + m_pEditSlideshowTitle->text() + QString (".in"));
	if (m_Slideshow.audio_list.count() > 0)	{
		for (uint t=0;t<m_Slideshow.audio_list.count();t++)	{
			listArgs.append(QString ("-a"));
			listArgs.append(m_Slideshow.audio_list[t]);
		}
	}
	if (!m_Slideshow.background .isNull())	{
		listArgs.append(QString ("-b"));
		listArgs.append(m_Slideshow.background);	// the background image (if any)
	}
	if (m_Slideshow.delay > 0)	{
		listArgs.append(QString ("-t"));
		listArgs.append(QString("%1").arg(m_Slideshow.delay));
	}

	m_pNewProcess  = new QProcess ( this );
	connect( m_pNewProcess, SIGNAL(readyReadStdout()), this, SLOT(slotReadFromStdout()) );
	connect( m_pNewProcess, SIGNAL(readyReadStderr()), this, SLOT(slotReadFromStderr()) );
	connect( m_pNewProcess, SIGNAL(processExited()), this, SLOT(slotProcessExited()) );

	m_pNewProcess->setArguments (listArgs);
	m_pNewProcess->start ();

//printf ("Command<%s>\n", (const char *)qsCommand);
}
/* dvd-slideshow - output
[dvd-slideshow]########################################
[dvd-slideshow] 0/8 title
[dvd-slideshow] Making title slide:
[dvd-slideshow]         Test Show
[dvd-slideshow]         My Slideshow
[dvd-slideshow]########################################
[dvd-slideshow] 1/8 fadein
[dvd-slideshow] frame=0071 94%
*/

void DialogCreate::slotReadFromStdout()
{
	static bool bFoundSeparator = false;
	QString qsText;
	QFileInfo fileInfo;
	QString stdOut = m_pNewProcess->readStdout();
	// First we should give some feedback to the user ...
	m_pTextOutput->append(stdOut);
	if (bFoundSeparator)	{
		// Here we search for the right information int the stdOut
		QStringList listLines = QStringList::split (QString ("\n"), stdOut);
		// Okay do the computing ...
		QStringList listParts = QStringList::split (QString (" "), listLines[0]);
		QStringList listNumbers = QStringList::split (QString ("/"), listParts[1]);
		if (listNumbers.count() == 1)	{	// this is at the end like "[dvd-slideshow] Joining each mpeg..."
			m_pEditCurrentFileName->setText(listLines[0].right (listLines[0].length() - 16));
		}
		else	{
			fileInfo.setFile (listParts[2]);
			m_pEditCurrentFileName->setText(fileInfo.fileName());
		}
		m_pProgress->setProgress ((int)((float)(m_iProgressCounter++ +1)/(m_Slideshow.count()+2) * 100.0));
		m_pEditImageNumber->setText(QString ("%1").arg(m_iProgressCounter));
		//m_pEditImageNumber->setText(QString ("%1").arg(listNumbers[0].toInt()+1));
		// finally we unmark the separator ...
		bFoundSeparator = false;
	}
	// Here we check if we found the separator ...
	if (((stdOut.find ("[dvd-slideshow]########################################")) != -1) && (m_iProgressCounter < m_Slideshow.count()+2) )
		bFoundSeparator = true;
}

void DialogCreate::slotReadFromStderr()
{
}

void DialogCreate::slotProcessExited()
{
	m_pButtonGenerate->setEnabled(true);
	QString stdErr = m_pNewProcess->readStderr();
	QString stdOut = m_pNewProcess->readStdout();
	if (!stdOut.isEmpty())
		printf ("Exit Out <%s>\n", (const char *)stdOut);
	if (!stdErr.isEmpty())
		printf ("Exit Err <%s>\n", (const char *)stdErr);
	m_iProgressCounter = 0;
	m_pProgress->setProgress (100);
	m_pTextStatus->setText ("Done.");
	m_pEditCurrentFileName->setText("Done.");
	
	// Here we check if the mpeg file has ben generated (see if file exists)
	QFileInfo fileInfo (m_qsTempPath + QString ("/") + m_Slideshow.slideshow_name + QString (".mpg"));
	if (fileInfo.exists())	{
		emit (signalSlideshowDone(m_Slideshow.slideshow_name));
	}
}

void DialogCreate::slotBack()
{
	m_pButtonGenerate->setEnabled(true);
	m_pMainDialog->show();
	reject ();	// This will only close this dialog and open the main dialog.
// 		// accept() would close the whole SlideshowDialog.
}






