/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>

#include <qmessagebox.h>
#include <qapplication.h>

// The number of ticks for the progress bar.
#ifndef TOTAL_PROGRESS
#define TOTAL_PROGRESS 100
#endif

void Configurator::initMe(QApplication *pApp)
{
	bool bState = false;
	m_pNewProcess = NULL;
	m_iCurrentStep = 0;
	m_iTotalSteps = getCompileSteps();
	progressBarCompile->setTotalSteps ( TOTAL_PROGRESS );

	// For now we only have included propper support for xine-lib
	QString qsLib("libxine.so");
	if (!checkLibraryExists (qsLib))
		radioVideoXine->setEnabled(false);
	qsLib = QString ("libdha.so");
	if (!checkLibraryExists (qsLib))
		radioVideoMPlayer->setEnabled(false);

	// Last we set the lineEdits to reflect the current environment variables.
	QString qsInstallDir (getenv("PREFIX"));
	if (!qsInstallDir.isEmpty())
		editInstallDir->setText(qsInstallDir);
	editQtDir->setText(QString ( getenv("QTDIR")));
	editLDLibraryPath->setText(QString ( getenv("LD_LIBRARY_PATH")));
	// Here we check if an executable exists already ...
	QFileInfo theFile ("../bin/qdvdauthor");
	if ( (theFile.exists()) && (theFile.size() > 1) ) 
		bState = true;
	buttonExecute->setEnabled( bState );
	if (bState)	{
		// the next check is to see if we can find kdesu
		if (findGuiSU().isEmpty())
			bState = false;
	}
	buttonInstall->setEnabled( bState );

	connect( pApp, SIGNAL( aboutToQuit() ), this, SLOT( slotAboutToQuit() ) );
}

QString Configurator::findGuiSU()
{
	uint t;
	QString qsReturn;
 	char *arraySUs[3] = {"kdesu", "xsu", "gnomesu"};
	QFileInfo fileInfo("/tmp/out.txt");
	for (t=0;t<3;t++)	{
		// the next check is to see if we can find kdesu
		system ((const char *)QString ("which %1 > /tmp/out.txt").arg(arraySUs[t]));
		fileInfo.setFile("/tmp/out.txt");
		// Okay we cna not find it, so we wont bother asking the user ...
		if (fileInfo.size() > 4)	{
			qsReturn = QString ("%1").arg(arraySUs[t]);
			return qsReturn;
		}
	}
	return qsReturn;
}

bool Configurator::checkLibraryExists(QString &libName)
{
	// in a shell script it would look like this :
	// cat /etc/ld.so.conf | while read lib_path
	// do
	//    if [ -e $lib_path/$lib_name ]
	//        found.
	//    fi;
	// done; 
	QFileInfo fileInfo;
	// The standard libraries are not in the ld.so.conf file ?!?!!?
	fileInfo = QFileInfo (QString ("/lib/") + libName);
	if (fileInfo.exists())
		return true;
	fileInfo = QFileInfo (editQtDir->text() + QString ("/lib/") + libName);
	if (fileInfo.exists())
		return true;
	fileInfo = QFileInfo (QString ("/usr/lib/") + libName);
	if (fileInfo.exists())
		return true;
	fileInfo  = QFileInfo ("/etc/ld.so.conf");
	if (fileInfo.exists ())	{
		QFile file( "/etc/ld.so.conf" );
		if ( file.open( IO_ReadOnly ) ) {
			QTextStream stream( &file );
			QString libPath;
			while ( !stream.atEnd() ) {
//printf ("Seraching for <%s> under <%s> total <%s>\n", (const char *)libName, (const char *)libPath, (const char *)QString (libPath + QString("/") + libName));
				libPath = stream.readLine();
				fileInfo = QFileInfo(libPath + QString("/") + libName);
				if (fileInfo.exists())	{
					file.close();
					return true;
				}
			}
		}
		file.close();
	}

	return false;
}

void Configurator::slotCompile()
{
	uint t;
	m_iTotalSteps = getCompileSteps();
	tabWidget2->setCurrentPage(2);
	progressBarCompile->setProgress (0);
	buttonExecute->setEnabled( false );
	if (m_pNewProcess)	{
		if (m_pNewProcess->isRunning())
			return;
		else
			delete m_pNewProcess;
	}

	m_pNewProcess  = new QProcess ( this );
	connect( m_pNewProcess, SIGNAL(readyReadStdout()), this, SLOT(slotReadFromStdout()) );
	connect( m_pNewProcess, SIGNAL(readyReadStderr()), this, SLOT(slotReadFromStderr()) );
	connect( m_pNewProcess, SIGNAL(processExited()), this, SLOT(slotProcessExited()) );
	QStringList listEnv;
	listEnv.append (QString("QTDIR=%1").arg(editQtDir->text()));
	if (editInstallDir->text().isEmpty())
		listEnv.append (QString("PREFIX=/usr"));
	else
		listEnv.append (QString("PREFIX=%1").arg(editInstallDir->text()));

	if (checkDebug->isOn())
		listEnv.append (QString("DEBUG_QDVDAUTHOR=debug"));

	if (!editLDLibraryPath->text().isEmpty())
		listEnv.append (QString("LD_LIBRARY_PATH=%1").arg(editLDLibraryPath->text()));
	if (radioVideoXine->isOn())
		 listEnv.append ("VIDEO_LIB=xine");
	else if (radioVideoMPlayer->isOn())
		 listEnv.append ("VIDEO_LIB=mplayer");

	QString qtLib1 ("libqt-mt.so");
	QString qtLib2 ("libqt.so");
	if (checkLibraryExists (qtLib1))
		listEnv.append ("QT_LIB=qt-mt");
	else if (checkLibraryExists (qtLib2))
		listEnv.append ("QT_LIB=qt");
	// This var will tell the qplayer.pro file to not to create qmake_image_collection ...
	listEnv.append ("QMAKE_IMAGES=yes");

	// Here we print the newly added environment variables.
	textOutput->clear();
	for ( QStringList::Iterator it = listEnv.begin(); it != listEnv.end(); ++it ) {
		textOutput->append(*it + QString ("\n"));
	}

	// let us set the env of the calling process rather then just
	// create our own environment with only the environment we set.
	for (uint t=0;t<listEnv.count();t++)
		putenv ((char *)((const char *)listEnv [t]));

	// qdvdauthor.pro needs those files to physically be there ... Go figure !
	system ("touch ../bin/qdvdauthor ../bin/qslideshow ../bin/qplayer");

	m_pNewProcess->setWorkingDirectory (QDir ("../"));
	// And here we generate the make file and compile the application.
	m_pNewProcess->addArgument ("qmake");
	m_pNewProcess->addArgument ("all.pro");
	m_pNewProcess->start ();
	// wait for a second until qmake is done ...
	while (m_pNewProcess->isRunning())
		sleep (1);
	m_pNewProcess->clearArguments();

	m_pNewProcess->addArgument (QString("make"));
	if (!editMakeOptions->text().isEmpty())	{
		// Here we need to split the line ...
		QStringList listArgs = QStringList::split(" ", editMakeOptions->text());
		for (t=0;t<listArgs.count();t++)
			m_pNewProcess->addArgument (listArgs[t]);
	}

	m_pNewProcess->start ();
}

void Configurator::slotReadFromStdout()
{
// Here for now manually but later automagically.
//static int iCounter =0;
//iCounter ++;
//printf ("<%d>\n", iCounter);
	QString stdOut = m_pNewProcess->readStdout();
	if (stdOut.length() < 2)
		return;
	textOutput->append (stdOut);
	// and here we take care of the progress bar.
	m_iCurrentStep ++;
	if (m_iCurrentStep > m_iTotalSteps)
		m_iCurrentStep = m_iTotalSteps;
	float fProgress = ((float)(m_iCurrentStep) / (float)(m_iTotalSteps) ) * TOTAL_PROGRESS;
	progressBarCompile->setProgress ( (int)fProgress );
}

void Configurator::slotReadFromStderr()
{
	static QColor errorColor = QColor (255, 0, 0);
	QString strError = m_pNewProcess->readStderr ();
	if (strError.length() < 2)
		return;
	// Okay, I don't know why I get all these QSettings errors. Must be in configurator ...
	if (strError.find ("QSettings:") > -1)
		return;

	QColor stdColor = textOutput->color();
	if (strError.lower().find ("error") > -1)
		errorColor = QColor(255, 0, 0);
	else 
		errorColor = QColor (220,220,0); 
	textOutput->setColor (errorColor);
	textOutput->append (strError);
	textOutput->setColor (stdColor);
}

void Configurator::slotProcessExited()
{
	bool bState = false;
	slotReadFromStdout ();
	slotReadFromStderr ();
	progressBarCompile->setProgress ( TOTAL_PROGRESS );
	m_iCurrentStep = 0;
	// And here we check if the executable exists ...
	QFileInfo theFile ("../bin/qdvdauthor");
	if ( (theFile.exists()) && (theFile.size() > 1) )
		bState = true;
		
	buttonExecute->setEnabled( bState );
	if (bState)	{
		// the next check is to see if we can find kdesu
		if (findGuiSU().isEmpty())
			bState = false;
	}
	buttonInstall->setEnabled( bState );
}

int Configurator::getCompileSteps ()
{
	int iStepCounter;
	// This function checks how many steps the compilation process approximately has.
	QDir theCompileDir ("../qdvdauthor");
// 	3 * *.ui + *.cpp * *.cpp + *.ui * 2*iamge + link - .obj/*
//	3*4 + 6 + 6 + 4 + 2 + 1 - 0 = 31;
	QDir theDir ("../qdvdauthor");
	QStringList fileList;
	theDir.setNameFilter("*.ui");
	fileList = theDir.entryList();
	iStepCounter = fileList.count() * 4;

	theDir.setNameFilter("*.cpp");
	fileList = theDir.entryList();
	iStepCounter += fileList.count() * 3;

	theDir.setPath ("../qdvdauthor/.obj");
	theDir.setNameFilter("*.o");
	fileList = theDir.entryList();
	iStepCounter -= fileList.count();
	iStepCounter += 3;

	// The slideshow sub-directory
	theDir.setPath ("../qslideshow");
	theDir.setNameFilter("*.ui");
	fileList = theDir.entryList();
	iStepCounter += fileList.count() * 4;

	theDir.setNameFilter("*.cpp");
	fileList = theDir.entryList();
	iStepCounter += fileList.count() * 5;

	// The QXine sub-directory
	theDir.setPath ("../qplayer");
	theDir.setNameFilter("*.ui");
	fileList = theDir.entryList();
	iStepCounter += fileList.count() * 4;

	theDir.setNameFilter("*.cpp");
	fileList = theDir.entryList();
	iStepCounter += fileList.count() * 5;

	theDir.setPath ("..");

	// Okay, for now manually until I found a good algol ...
	iStepCounter = 214;
	return iStepCounter;
}

void Configurator::slotMakeClean()
{
	tabWidget2->setCurrentPage(2);
	progressBarCompile->setProgress (0);
	buttonExecute->setEnabled( false );
	textOutput->clear();
	if (m_pNewProcess)
		delete m_pNewProcess;

	m_pNewProcess  = new QProcess ( this );
	connect( m_pNewProcess, SIGNAL(readyReadStdout()), this, SLOT(slotReadFromStdout()) );
	connect( m_pNewProcess, SIGNAL(processExited()), this, SLOT(slotProcessExited()) );

	m_pNewProcess->setWorkingDirectory (QDir (".."));
	// And here we generate the make file and compile the application.
	m_pNewProcess->addArgument (QString("make"));
	m_pNewProcess->addArgument (QString("clean"));
	m_pNewProcess->start ();
	system ("rm ../bin/*");
	buttonExecute->setEnabled( false );
	buttonInstall->setEnabled( false );
}

void Configurator::slotExecute()
{
	system ("../bin/qdvdauthor &");
}

void Configurator::slotInstall()
{
	// Due to security risks it is a major problem to generate a GUI to ask for the root password
	// and then execute something with root privileges.
	// 1) The standard command would look like 
	//    su - root -c /tmp/make_install.sh
	//    which does not work because su is asking for the password on the console (tty) rather 
	//    then through stdin.
	// 2) Another solution through the sticky bit I could not figure out unless we start configure 
	//    as root, which would defeat its purpose
	// 3) Tools like expectk etc need extra packages.
	// 4) Generating a new task with a virtual tty device would probably solve the issue, but this 
	//    would baloon this function quite a bit (I guess. Any takers here ?)
	//
	// 5) The way I decided to implement it is to use kdesu if present and otherwise disable the 
	//    install-button.
	//
	/////////////////////////////////////////////////////////////////////////////////////////////////
	uint t;
	bool bCanWriteToInstallDir;
	QString qsPassword;
	QString qsPath = editInstallDir->text();
	
	if (m_pNewProcess)	{
		if (m_pNewProcess->isRunning())
			return;
		else 
			delete m_pNewProcess;
	}
	bCanWriteToInstallDir = false;
	// First we check if we can write to the chosen directory ...
	QFile file( editInstallDir->text() + QString ("/bin/test_file") );
	if ( file.open( IO_WriteOnly ) )	{
		bCanWriteToInstallDir = true;
		file.close();
		file.remove();
	}
	// Here we give the user a hint ...
	QDir theDir (qsPath);
	
	for (t=0;t<2;t++)	{
		if (!theDir.exists())	{
			QMessageBox::warning ( this, "Directory missing.",
				QString("Could not find the directory \n%1\n"
					"Please make sure this directory exists first.").arg(qsPath), 
				QMessageBox::Ok, QMessageBox::NoButton);
			return;
		}
		qsPath = editInstallDir->text() + QString ("/bin");
		theDir.setPath(qsPath);
	}
	// the next check is to see if we can find kdesu
	QString qsGuiSU = findGuiSU();
	if (qsGuiSU.isEmpty())
		bCanWriteToInstallDir = true;

	m_iTotalSteps = 1;
	tabWidget2->setCurrentPage(2);
	progressBarCompile->setProgress (0);

	m_pNewProcess  = new QProcess ( this );
	connect( m_pNewProcess, SIGNAL(readyReadStdout()), this, SLOT(slotReadFromStdout()) );
	QStringList listEnv;

	// Here we print the newly added environment variables.
	// This does not work since we start out in /root after changing to become root to install
//	m_pNewProcess->setWorkingDirectory (QDir ("../qdvdauthor/"));
	// Did not know how to handle this in one line so I create another bash script ...
	theDir = QDir::current();
	theDir.cdUp();
	file.setName("/tmp/make_install.sh");
	if ( file.open( IO_WriteOnly ) ) {
		QTextStream stream( &file );
		stream << "#!/bin/sh\n\n" << QString ("make -C %1 install").arg(theDir.absPath());
		file.close();
	}
	chmod ("/tmp/make_install.sh", S_IEXEC | S_IRUSR | S_IWRITE);

	if (!bCanWriteToInstallDir)	{
		if (qsGuiSU == QString ("kdesu"))	{
			m_pNewProcess->addArgument ("kdesu");
			m_pNewProcess->addArgument ("-n");
			m_pNewProcess->addArgument ("-t");
			m_pNewProcess->addArgument ("-c");
		}
		else if (qsGuiSU == QString ("xsu"))	{
			m_pNewProcess->addArgument ("xsu");
			m_pNewProcess->addArgument ("--username");
			m_pNewProcess->addArgument ("root");
			m_pNewProcess->addArgument ("--message");
			m_pNewProcess->addArgument ("Please type in the root password");
			m_pNewProcess->addArgument ("--command");
		}
		else if (qsGuiSU == QString ("gnomesu"))	{
			m_pNewProcess->addArgument ("xsu");
			m_pNewProcess->addArgument ("--username");
			m_pNewProcess->addArgument ("root");
			m_pNewProcess->addArgument ("--message");
			m_pNewProcess->addArgument ("Please type in the root password");
			m_pNewProcess->addArgument ("--command");
		}
	}
	m_pNewProcess->addArgument ("/tmp/make_install.sh");

	m_pNewProcess->start ();
}

void Configurator::slotOkay()
{
/*	const char *pQtDir = editQtDir->text();
	setenv ("QTDIR", pQtDir, 1);
	if (radioVideoXine->isOn())
		setenv ("VIDEO_LIB", "xine", 1);
	else if (radioVideoMPlayer->isOn())
		setenv ("VIDEO_LIB", "mplayer", 1);
	// And here we generate the make file and compile the application.
	system ("cd ../qdvdauthor; qmake qdvdauthor.pro");
*/
	if (m_pNewProcess)
        	m_pNewProcess->tryTerminate();
	accept ();
}

void Configurator::slotAboutToQuit()
{
	if (m_pNewProcess)
        	m_pNewProcess->tryTerminate();
}

void Configurator::slotInfoXine()
{
	if (radioVideoXine->isEnabled ())
		QMessageBox::information (NULL, QString ("Xine Library"),
		QString ("This library is installed and should work for all purposes.\n"
			"You can also install and use the MPlayer libraries \n"
			"and use this library instead of xine to display the media streams.\n"),
			QMessageBox::Ok ,  QMessageBox::NoButton);
	else
		QMessageBox::warning (NULL, QString ("Xine not installed."),
		QString ("Attention, xine is not installed, thus you \n"
			"should choose MPlayer.\n\n"),
			QMessageBox::Ok ,  QMessageBox::NoButton);
}

void Configurator::slotInfoMPlayer()
{
	if (radioVideoMPlayer->isEnabled ())
		QMessageBox::information (NULL, QString ("MPLayer library"),
		QString ("This functionality is not yet incorporated.\n"
			"Any takers on this one ?\n\n"
			),
			QMessageBox::Ok ,  QMessageBox::NoButton);
/*		QMessageBox::information (NULL, QString ("MPLayer library"),
		QString ("This library is installed and should work for all purposes.\n"
			"You can also install xine-lib and compile 'Q' DVD-Author\n"
			"to use this library instead.\n\n"
			),
			QMessageBox::Ok ,  QMessageBox::NoButton);
*/	else
		QMessageBox::warning (NULL, QString ("MPlayer not installed."),
		QString ("Attention, MPlayer is not installed, thus you \n"
			"should choose xine instead.\n\n"),
			QMessageBox::Ok ,  QMessageBox::NoButton);
}




