/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <qpixmap.h>
//#include <qimage.h>
//#include <qmessagebox.h>

#include "global.h"
#include "qimagehelper.h"

void CResizeDialog::slotManualResize(const QString &)
{
}


void CResizeDialog::slotResize( int )
{
	int iWidth = 720;
	int iHeight = 480;
	int iFormat = FORMAT_NONE;
	// ButtonGroup : 
	if (m_pRadio1->isChecked())	{
		iWidth	= 720;
		iHeight	= 576;
		iFormat = FORMAT_PAL1;
	}
	else if (m_pRadio2->isChecked()){
		iWidth	= 704;
		iHeight	= 576;
		iFormat = FORMAT_PAL2;
	}
	else if (m_pRadio3->isChecked()){
		iWidth	= 352;
		iHeight	= 576;
		iFormat = FORMAT_PAL3;
	}
	else if (m_pRadio4->isChecked()){
		iWidth	= 352;
		iHeight	= 288;
		iFormat = FORMAT_PAL4;
	}
	else if (m_pRadio5->isChecked()){
		iWidth	= 720;
		iHeight	= 480;
		iFormat = FORMAT_NTSC1;
	}
	else if (m_pRadio6->isChecked()){
		iWidth	= 704;
		iHeight	= 480;
		iFormat = FORMAT_NTSC2;
	}
	else if (m_pRadio7->isChecked()){
		iWidth	= 352;
		iHeight	= 480;
		iFormat = FORMAT_NTSC3;
	}
	else if (m_pRadio8->isChecked()){
		iWidth	= 352;
		iHeight	= 240;
		iFormat = FORMAT_NTSC4;
	}
	m_pEditWidth->setText(QString("%1").arg(iWidth));
	m_pEditHeight->setText(QString("%1").arg(iHeight));
	m_iFormat = iFormat;
	slotPreview();
}


void CResizeDialog::slotResizeAlogrithm( int )
{

}


void CResizeDialog::slotStretchType( int )
{

}


void CResizeDialog::slotPreview()
{
	int iWidth, iHeight;
	bool  bOk = true;

	iWidth = m_pEditWidth->text().toInt(&bOk);
	if (!bOk)
		iWidth = 720;
	iHeight = m_pEditHeight->text().toInt(&bOk);
	if (!bOk)
		iHeight = 480;
		
	// And since we are using a preview, we can shrink it by factor 2.
	iWidth = (int) (iWidth / 2.0);
	iHeight = (int) (iHeight / 2.0);

	preview (iWidth, iHeight, getResizeAlgorithm());
}

int CResizeDialog::getResizeAlgorithm ()
{
	int iResizeAlgorithm = RESIZE_QT;
	// Here we see which algol the user wants to use ...
	comboResizeAlgorithm->currentItem();
	// Please note that the QImageHelper class can figure out the algol itself since
	// the QStringList has been delivered in a known order.
	return iResizeAlgorithm;
}

void CResizeDialog::preview (int iWidth, int iHeight, int iResizeAlgorithm)
{
	QImageHelper theFile (m_qsFileName, 0);
	QPixmap thePreview;
	theFile.resize (iWidth, iHeight, iResizeAlgorithm);
	thePreview = QPixmap (iWidth, iHeight);
	thePreview.convertFromImage (theFile);
	m_pPixmapPreview->setFixedSize(iWidth, iHeight);
	m_pPixmapPreview->setPixmap ( (const QPixmap &) thePreview);
}

void CResizeDialog::slotOk(void)
{
	int iWidth, iHeight;
	bool  bOk = true;

	iWidth = m_pEditWidth->text().toInt(&bOk);
	if (!bOk)
		iWidth = 720;
	iHeight = m_pEditHeight->text().toInt(&bOk);
	if (!bOk)
		iHeight = 480;
	preview(iWidth, iHeight, getResizeAlgorithm());
	accept();
}

void CResizeDialog::slotHelp()
{

}

void CResizeDialog::setFilename( QString &qsFileName )
{
	// first we set the avail resize algos ...
	QImageHelper temp;
	comboResizeAlgorithm->insertStringList (temp.getAvailableResizeAlgorithms());
	m_qsFileName = qsFileName;
	slotPreview();
}

void CResizeDialog::setResizeAlgo( QStringList &algoList )
{
	comboResizeAlgorithm->insertStringList (algoList);
}
