/****************************************************************************
** ImagePreview class
**
** Created: Tue Feb 02 22:06:51 2004
**      by: Varol Okan using Kate
**
** This class is the encapsulation of the ImagePreview from the FileSelection
** Dialog.
** It is also used in the ImageDialog.
**
****************************************************************************/
#include <qpainter.h>

#include "xml_dvd.h"
#include "menuobject.h"

MenuObject::MenuObject (QWidget *pParent)
	: QObject (pParent)
{
	m_qsObjectType = QString (MENU_OBJECT);
	m_pParent = pParent;
	m_bDrawRect = false;
}

MenuObject::~MenuObject ()
{

}

// Need to take m_rectPreview into accoutn ...
bool MenuObject::contains (QPoint &pos)
{
	if (!m_boundingRect.contains(pos))
		return false;
	return true;
}

bool MenuObject::readProjectFile  (QDomNode &theNode)
{
	// Here we read in the base class ...
	QDomNode xmlMenuObject = theNode.firstChild();

	while ( !xmlMenuObject.isNull () )	{
		// Okay, here we retain the stored data from the xml file.
		QDomAttr attribute;
		QDomElement theElement = xmlMenuObject.toElement();
		QString tagName = theElement.tagName();
		QString nodeText = theElement.text ();
		// Okay, this is ugly but after all it is the simplest of all xml file structure.
		// No need to get fancy ...
		if (tagName == MENU_OBJECT)	{
			m_qsName = nodeText;
			QRect theRect;
			int iX, iY, iWidth, iHeight;
			iX      = rect().x();
			iY      = rect().y();
			iWidth  = rect().width();
			iHeight = rect().height();
			attribute = theElement.attributeNode ( RECT_X );
			if (!attribute.isNull())
				iX = attribute.value().toInt();

			attribute = theElement.attributeNode ( RECT_Y );
			if (!attribute.isNull())
				iY = attribute.value().toInt();

			attribute = theElement.attributeNode ( RECT_WIDTH );
			if (!attribute.isNull())
				iWidth = attribute.value().toInt();

			attribute = theElement.attributeNode ( RECT_HEIGHT );
			if (!attribute.isNull())
				iHeight = attribute.value().toInt();

			theRect = QRect (iX, iY, iWidth, iHeight);
			setRect(theRect);

			xmlMenuObject = xmlMenuObject.firstChild ();
			theElement = xmlMenuObject.toElement();
			tagName = theElement.tagName();
			if (tagName == MODIFIERS)	{
				attribute = theElement.attributeNode ( MODIFIERS_ROTATE );
				if (!attribute.isNull())
					modifiers()->fRotate = attribute.value().toFloat();

				attribute = theElement.attributeNode ( MODIFIERS_TRANSPARENCY );
				if (!attribute.isNull())
					modifiers()->fTransparency = attribute.value().toFloat();

				attribute = theElement.attributeNode ( MODIFIERS_ZOOM );
				if (!attribute.isNull())
					modifiers()->fZoom = attribute.value().toFloat();

				attribute = theElement.attributeNode ( MODIFIERS_SCALEX);
				if (!attribute.isNull())
					modifiers()->fScaleX = attribute.value().toFloat();

				attribute = theElement.attributeNode ( MODIFIERS_SCALEY );
				if (!attribute.isNull())
					modifiers()->fScaleY = attribute.value().toFloat();

				attribute = theElement.attributeNode ( MODIFIERS_SHEARX );
				if (!attribute.isNull())
					modifiers()->fShearX = attribute.value().toFloat();

				attribute = theElement.attributeNode ( MODIFIERS_SHEARY );
				if (!attribute.isNull())
					modifiers()->fShearY = attribute.value().toFloat();
			}
		}
		// So lets get the next sibling ... until we hit hte end of DVDMenu ...
		xmlMenuObject = xmlMenuObject.nextSibling();
	}
	return true;
}

// <...>
// <MenuObject Name="the Name" X="" Y="" Width="" Height="">
//		<Modifiers Rotate="" Zoom="" ScaleX="" ScaleY="" ShearX="" ShearY=""></Modifiers>
// </MenuObject>
// </...>
bool MenuObject::writeProjectFile (QDomElement &theElement)
{
	// First check if this node holds any information at all ...
//printf ("MenuObject::writeProjectFile <%s><%s>\n",(const char *)theElement.tagName(), (const char *)name());
	QDomDocument xmlDoc = theElement.ownerDocument();
	QDomElement objectNode = xmlDoc.createElement( MENU_OBJECT );	// <MenuObject>
	// Here we set the attributes of the <dvdauthor> tag
	if (!name().isNull())
		objectNode.setAttribute( MENU_OBJECT_NAME, name() );
	objectNode.setAttribute( RECT_X, rect().x() );
	objectNode.setAttribute( RECT_Y, rect().y() );
	objectNode.setAttribute( RECT_WIDTH,  rect().width () );
	objectNode.setAttribute( RECT_HEIGHT, rect().height() );
	// And now proceed to writing the Modifiers ... If we need that is ...
	Modifiers initialValues;
	if (	(modifiers()->fRotate != initialValues.fRotate) || (modifiers()->fShearX != initialValues.fShearX)  || 
		(modifiers()->fShearY != initialValues.fShearX) || (modifiers()->fZoom != initialValues.fZoom)      || 
		(modifiers()->fScaleX != initialValues.fScaleX) || (modifiers()->fScaleY != initialValues.fScaleY)  ||
		(modifiers()->fTransparency != initialValues.fTransparency) )	{

		QDomElement modifiersNode = xmlDoc.createElement ( MODIFIERS );
		if (modifiers()->fRotate != initialValues.fRotate)
			modifiersNode.setAttribute( MODIFIERS_ROTATE, QString ("%1").arg(modifiers()->fRotate) );
		if (modifiers()->fShearX != initialValues.fShearX)
			modifiersNode.setAttribute( MODIFIERS_SHEARX, QString ("%1").arg(modifiers()->fShearX) );
		if (modifiers()->fShearY != initialValues.fShearY)
			modifiersNode.setAttribute( MODIFIERS_SHEARY, QString ("%1").arg(modifiers()->fShearY) );
		if (modifiers()->fZoom != initialValues.fZoom)
			modifiersNode.setAttribute( MODIFIERS_ZOOM  , QString ("%1").arg(modifiers()->fZoom) );
		if (modifiers()->fScaleX != initialValues.fScaleX)
			modifiersNode.setAttribute( MODIFIERS_SCALEX, QString ("%1").arg(modifiers()->fScaleX) );
		if (modifiers()->fScaleY != initialValues.fScaleY)
			modifiersNode.setAttribute( MODIFIERS_SCALEY, QString ("%1").arg(modifiers()->fScaleY) );
		if (modifiers()->fTransparency != initialValues.fTransparency)
			modifiersNode.setAttribute( MODIFIERS_TRANSPARENCY, QString ("%1").arg(modifiers()->fTransparency) );
		objectNode.appendChild( modifiersNode );
	}
	theElement.appendChild( objectNode );
	return true;
}

void MenuObject::update()
{
	QPainter thePainter(parent());
	QRect theRect = boundingRect();
	theRect.addCoords(-5, -5, 5, 5);
	parent()->repaint(theRect, FALSE);
	drawContents(&thePainter);

//	emit(signalUpdatePixmap());
}

QString &MenuObject::objectType()
{
	return m_qsObjectType;
}

QString &MenuObject::name()
{
	return m_qsName;
}

Modifiers *MenuObject::modifiers()
{
	return &m_modifiers;
}

void MenuObject::setModifiers(Modifiers &theModifiers)
{
	modifiers()->fRotate       = theModifiers.fRotate;
	modifiers()->fZoom         = theModifiers.fZoom;
	modifiers()->fTransparency = theModifiers.fTransparency;
	modifiers()->fScaleX       = theModifiers.fScaleX;
	modifiers()->fScaleY       = theModifiers.fScaleY;
	modifiers()->fShearX       = theModifiers.fShearX;
	modifiers()->fShearY       = theModifiers.fShearY;
}

QRect   &MenuObject::rect()
{
	return m_rect;
}

QRect   &MenuObject::boundingRect()
{
	return m_boundingRect;
}

void MenuObject::setRect(QRect &rect)
{
	m_rect = rect;
	// The bounding rect is set by drawContents.
	m_boundingRect = rect;
}

void MenuObject::setParent(QWidget *pParent)
{
	m_pParent = pParent;
}

QWidget *MenuObject::parent()
{
	return m_pParent;
}

bool    MenuObject::drawRect()
{
	return m_bDrawRect;
}

MenuObject *MenuObject::clone()
{
	return NULL;
}

void MenuObject::setName (QString &qsName)
{
	m_qsName = qsName;
}
