/****************************************************************************
** MenuObject
**
** Created: Sun Feb 23 21:45:00 2004
**      by: Varol Okan using kate editor
**
**  This is the base class for all that is to appear onto the MenuPreview.
** Exception are background image, and the button masks (if the user
** specifies them rather then create the button manually)
**
** The MenuPreview class is the QLabel derived class where all buttons, text
** etc is to be plaeced for a DVD-Menu.
**
** The MenuObject is the base class for TextObject, ImageObject, MovieObject,
** FrameObject, and ButtonObject.
**
** The ButtonObject in turn is a container class which can hold a
** *TextObject, ImageObject, MovieObject, AND a FrameObject.
** Please refer to the buttonobject.h - file for more detail on the
** ButtonObject.
**
****************************************************************************/

#ifndef MENUOBJECT_H
#define MENUOBJECT_H

// The different button types ...
// General base class for all objects relating to the MenuPreview - class
//#define MENU_OBJECT        "menu_object"
// Only a frame to be drawn
//#define FRAME_OBJECT       "frame_object"
// Text is apealing
//#define TEXT_OBJECT        "text_object"
// An image is nice too ...
//#define IMAGE_OBJECT       "image_object"
// This is for movies. Currently only one image, later on it should also include a movie (sub movie)
//#define MOVIE_OBJECT       "movie_object"

//#define OBJECT_COLLECTION  "object_collection"

#include <qwidget.h>
#include <qwmatrix.h>
#include <qdom.h>

#include "modifiers.h"

class QListViewItem;

class MenuObject : public QObject
{
	Q_OBJECT
public:
	MenuObject (QWidget *pParent);
	virtual ~MenuObject();
	virtual void drawContents         (QPainter *) = 0;
	virtual bool mouseMoveEvent       (QMouseEvent *) = 0;
	virtual bool mousePressEvent      (QMouseEvent *) = 0;
	virtual bool mouseReleaseEvent    (QMouseEvent *) = 0;
	virtual bool mouseDoubleClickEvent(QMouseEvent *) = 0;

	virtual  bool readProjectFile  (QDomNode &);
	virtual  bool writeProjectFile (QDomElement &);
	virtual  void createStructure (QListViewItem *) = 0;
	virtual  bool contains (QPoint &);
	virtual  MenuObject *clone();
	virtual void replaceColor (QColor, QColor) {};

	void      update();
	void      setName (QString &);
	void      setParent(QWidget *);
	void      setRect (QRect &);
	void      setModifiers(Modifiers &);
	bool      drawRect();

	QString   &objectType();
	QString   &name();
	QRect     &boundingRect();
	QRect     &rect();
	QWidget   *parent();
	virtual Modifiers *modifiers();

signals:
	void signalUpdatePixmap();
	// Only used by Text, Frame, Button and only received if in ButtonDialog.
	void signalMaskColorChanged (QColor, QColor);

protected:
	QString   m_qsObjectType;
	QString   m_qsName;
	QRect	  m_rect;
	QRect	  m_boundingRect;
	QWidget  *m_pParent;
	bool      m_bDrawRect;
	Modifiers m_modifiers;
	QPoint    m_currentMousePos;
};

#endif	// MENUOBJECT_H
