/****************************************************************************
** Interface to the GUI.
**
** Created: Sun Dec 14 12:09:08 2003
**      by: Varol Okan using kate editor
**
** This class generates the command line for dvdauthor.
** Current Version of DVDAUTHOR used is 0.67
** You can find dvdauthor under http://dvdauthor.sourceforge.net/
**
****************************************************************************/

#ifndef MENUPREVIEW_H
#define MENUPREVIEW_H

#include <qvaluelist.h>

#include "buttonpreview.h"
#include "menuobject.h"

class ButtonObject;
class DialogButton;
class SourceFileEntry;

class MenuPreview : public ButtonPreview
{
	Q_OBJECT
	enum { TypeNone=0, FrameType, TextType, ImageType, MovieType, CollectionType};
public:
	 MenuPreview (QWidget * parent, const char * name = 0, WFlags f = 0 );
	~MenuPreview ();
	
	void initMe  (QColor *);

	void respondSourceFiles (QValueList<SourceFileEntry *>);
	void respondSubMenus    (QStringList);

	bool readProjectFile  (QDomNode &);
	bool writeProjectFile (QDomElement &);

	void setIsSubMenu(bool);
	MenuObject *readObject (QDomNode &objectNode);

public slots:
	virtual void slotAddFrameObject     ();
	virtual void slotAddTextObject      ();
	virtual void slotAddImageObject     ();
	virtual void slotAddMovieObject     ();
	virtual void slotAddCollection      ();
	virtual void slotUpdateStructure    ();
	virtual void slotUpdatePixmap       ();
	virtual void slotDefineAsButton     (MenuObject *);
	virtual void slotDeleteObject       (MenuObject *);
	virtual void slotModifyObject       (MenuObject *);
	virtual void slotUnbutton           (ButtonObject *);
	virtual void slotCreateButtonDialog (ButtonObject *);
	virtual void slotDeleteMenu         ();
	virtual void slotRenameMenu         ();
	virtual void slotDestroyedButtonDialog ();

signals:
	void signalUpdateStructure   ();
	void signalRequestSourceFiles();
	void signalRequestSubMenus   ();
	void signalDeleteMe          ();
	void signalRenameMe          ();
	void signalMaskColorChanged  (QColor, QColor);

protected:
	virtual void mousePressEvent		(QMouseEvent *);
	virtual void mouseReleaseEvent		(QMouseEvent *);
	virtual void mouseDoubleClickEvent	(QMouseEvent *);
	virtual void mouseMoveEvent 		(QMouseEvent *);

//	virtual void drawContents (QPainter *);
	MenuObject *createFrameObject      (bool b=true);
	MenuObject *createTextObject       (bool b=true);
	MenuObject *createImageObject      (bool b=true);
	MenuObject *createMovieObject      (bool b=true);
	MenuObject *createButtonObject     (bool b=true);
	MenuObject *createObjectCollection (bool b=true);

	QString &newButtonName();

private:
	int  m_iCursorStyle;// signals to be awaiting the next mouse click
		// which will then generate the rectangle for this text button.
	int  m_iCreateObjectStyle;	// What object, text, image, frame, or movie ?
	bool m_bActiveCursor;
	QRect m_rectCurrentObject;
	DialogButton *m_pDialogButton;
	bool m_bIsSubMenu;
	QColor *m_pPgcColors;
};

#endif // MENUPREVIEW_H
