/****************************************************************************
** qdvdauthor.h file.
**
** This file handles the user input to generate a DVD menu.
** Please note that this is work in progress and depends also oin the
** developement of dvdauthor, which is at the moment in version 0.67.
** Future versions of dvdauthort might need changes to this file.
**
*****************************************************************************/
#include <iostream>

#include <qapplication.h>
#include <qinputdialog.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qcombobox.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include <qlistbox.h>
#include <qfile.h>
#include <qframe.h>

#include "global.h"
#include "sourcefileentry.h"
#include "dialogsetup.h"
#include "dialogslide.h"
#include "qdvdauthor.h"
#include "dialogexecute.h"
#include "buttonobject.h"
#include "colortoolbar.h"
#include "sourcetoolbar.h"
#include "structuretoolbar.h"
#include "dvdinfo.h"
#include "dvdmenu.h"
#include "xml_dvd.h"
#include "xml_dvdauthor.h"
#include "qdvdauthorinit.h"
#include "qplayer/xineinfo.h"

#include <X11/Xlib.h>

QDVDAuthor::QDVDAuthor ()
{
	// One of the first things we ought to do is to ensure threating is turned on ...
	if (!XInitThreads ())	{
		QApplication::beep();
		QMessageBox::warning(NULL, tr ("XInitThreads failed!"), tr ("XInitThreads failed!"), QMessageBox::Ok, QMessageBox::NoButton);
		return;
	}

	m_pVMGMenu = NULL;
	m_pXineEngine = NULL;
	// Init the variables
	m_bModified = false;
	m_qsProjectFileName = QString (PROJECT_FILENAME);
	m_qsProjectName     = QString (PROJECT_NAME);
	m_qsCurrentPath     = QString ("./");
	m_qsDVDAuthorPath   = QString ("/usr/local/bin");
	m_qsMpegToolsPath   = QString ("/usr/local/bin");
	m_qsTempPath        = QString ("/tmp");
	// Next we init the callbacks and GUI parts.
	initMe();
}

/* How to get a screenshot of a video, using transcode :
transcode -i DolbyDigitalRain.vob -V -y jpg -F d -c 100-103 --export_fps 29.97 --export_asr 2 -E 48000 -b 224 -o test
transcode -i board.avi -c 110-111 -J smartdeinter -y jpg -F 100 -o board
puts frame No. 110 from DV board.avi into board0000.jpg
from transcode 0.6.12 www.transcoding.org

ogg to mp2 > oggdec test.ogg -o - | mp2enc -o test2.mp2
mp3 to mp2 > lame --decode blues.mp3 - | mp2enc -o blues.mp2
           > mplayer mymusicfile.mp3 -vo null -ao pcm -aofile menu_audio.pcm ; mp2enc -r 48000 -o menu_audio.mpa < menu_audio.pcm
>

*/
/*
Feature to add : with a ew project ask if the old temp files should be deleted.
*/

QDVDAuthor::~QDVDAuthor ()
{
	SaveIni ();
	if (m_pXineEngine)
		xine_exit(m_pXineEngine);

#ifndef DEBUG_INFO
	// remove temp files ...
	rm /tmp/dvdauthor.xml
	rm /tmp/spumux.xml
	rm /tmp/sllideshow.xml
#endif
	// THis might not be needed sinc e the destructor of the Widget takes care of this ... 
	delete m_pSourceToolbar;
	delete m_pStructureToolbar;
}

void QDVDAuthor::initMe()
{
	setDockMenuEnabled  (false);
	LoadIni ();
	initXine ();
	// Here we create the Structure, and the SourceFile ToolBars.
	m_pSourceToolbar    = new SourceToolBar(QString("SourceToolBar"), this, this, false, "SourceToolBar");
	m_pStructureToolbar = new StructureToolBar(QString("StructureToolBar"), this, this, false, "StructureToolBar");
	m_pColorToolbar     = new ColorToolBar (QString ("ColorToolBar"), this, this, false, "ColorToolBar");

	// Here we assign the icons to the actions ...
	fileNewAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "filenew" ) ) );
	fileOpenAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "fileopen" ) ) );
	fileSaveAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "filesave" ) ) );
	filePrintAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "print" ) ) );
	editUndoAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "undo" ) ) );
	editRedoAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "redo" ) ) );
	editCutAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "editcut" ) ) );
	editCopyAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "editcopy" ) ) );
	editPasteAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "editpaste" ) ) );
	editFindAction->setIconSet( QIconSet( QPixmap::fromMimeSource( "searchfind" ) ) );

	connect (m_pTabWidgetMain,      SIGNAL(currentChanged(QWidget *)), this, SLOT(slotTabChanged(QWidget *)));
	connect (m_pActionAddMovie,     SIGNAL(activated()), this, SLOT(slotEditAddMovie()));
	connect (m_pActionAddSlideshow, SIGNAL(activated()), this, SLOT(slotEditAddSlideshow()));
	connect (m_pActionAddSubMenu,   SIGNAL(activated()), this, SLOT(slotAddSubMenu()));
	connect (m_pActionCreateDVD,    SIGNAL(activated()), this, SLOT(slotCreateDVD()));
	connect (m_pComboSource,        SIGNAL(highlighted(const QString &)), this, SLOT(slotCreateXml(const QString &)));
}

bool QDVDAuthor::initXine ()
{
	QString qsConfigFile;

	qsConfigFile = QDir::homeDirPath();
	qsConfigFile.append("/.qdvdauthor/qxine_config");

	// the thread will remove itself from memory after run() has executed (I think).
	new CreateXineEngine (&m_pXineEngine, qsConfigFile);

	return true;
}

xine_t *QDVDAuthor::getXineEngine ()
{
	static int iCounter = 0;
	while (!m_pXineEngine)	{
		// Init does not seem to have finished yet ...
		// So we wait for a second ...
		sleep (1);
		// this counter will break out of the loop after 30 unsuccessfull seconds
		if (iCounter ++ > 30)
			break;
	}
	return m_pXineEngine;
}

void QDVDAuthor::addDVDMenu (DVDMenu *pDVDMenu, bool bVMGM)
{
	if (bVMGM)
		m_pVMGMenu = pDVDMenu;
	else
		m_listDVDMenus.append(pDVDMenu);

	m_pColorToolbar->setDVDMenu (pDVDMenu);
}

// The foillowing functions are only used in DVDMenu::slotRequestSourceFiles ()
int QDVDAuthor::sourceFileCount()
{
	return (int)m_pSourceToolbar->sourceFileCount();
}

SourceFileEntry *QDVDAuthor::sourceFileEntry(uint iEntryNumber)
{
	return m_pSourceToolbar->sourceFileEntry(iEntryNumber);
}

SourceFileEntry *QDVDAuthor::getSourceEntryByDisplayName(QString &qsDisplayName)
{
	int t;
	for (t=0;t<sourceFileCount();t++)	{
		if (sourceFileEntry(t)->qsDisplayName == qsDisplayName)
			return sourceFileEntry(t);
	}
	return NULL;
}

void QDVDAuthor::addSound (QStringList &listSoundFiles)
{
	m_pSourceToolbar->addSound(listSoundFiles);
}

void QDVDAuthor::setColor (uint iWhichColor, QColor theColor)
{
	m_pColorToolbar->setColor(iWhichColor, theColor);
}

void QDVDAuthor::removedSourceEntry (SourceFileEntry *pEntry)
{
	// This function is called after a SourceFileEntry has been deleted from the
	// SourceToolBar - class.
	// We should remove all subsequent dependencies (buttons connected with movie files, or background sound files ...)
	uint t;
	QFileInfo fileInfo;
	QString qsFileName;

	m_pVMGMenu->removeSourceEntry(pEntry->qsDisplayName);
	for (t=0;t<m_listDVDMenus.count();t++)
		m_listDVDMenus[t]->removeSourceEntry(pEntry->qsDisplayName);
}

bool QDVDAuthor::isSourceEntryUsed(QString &qsInquireEntry)
{
	uint t;
	// This function is called when the user wants to delete a SourceFileEntry
	// it returns true if the entry is in use.
	if (m_pVMGMenu->isSourceEntryUsed (qsInquireEntry))
		return true;
	// next we step through all sub-menus ...
	for (t=0;t<m_listDVDMenus.count();t++)	{
		if (m_listDVDMenus[t]->isSourceEntryUsed (qsInquireEntry))
			return true;
	}
	return false;
}

void QDVDAuthor::replaceSourceDisplayName (QString &qsOriginalDisplayName, QString &qsNewDisplayName)
{
	// This function is called when the user changed the DisplayName of a SourceFileEntry
	// DialogMovie::accept()->SourceToolBar::slotEditMovie->QDVDAuthor::replaceSourceDisplayName()
	uint t;
	
	m_pVMGMenu->replaceSourceDisplayName (qsOriginalDisplayName, qsNewDisplayName);
	for (t=0;t<m_listDVDMenus.count();t++)	
		m_listDVDMenus[t]->replaceSourceDisplayName (qsOriginalDisplayName, qsNewDisplayName);

	slotUpdateStructure ();
}

QValueList<DVDMenu *> &QDVDAuthor::getSubMenus()
{
	return m_listDVDMenus;
}

QString &QDVDAuthor::currentPath()
{
	return m_qsCurrentPath;
}

void QDVDAuthor::setCurrentPath(QString &qsCurrentPath)
{
	uint t;
	m_qsCurrentPath = qsCurrentPath;
	m_pVMGMenu->setCurrentPath ( qsCurrentPath, true );
	for (t=0;t<m_listDVDMenus.count();t++)
		m_listDVDMenus[t]->setCurrentPath( qsCurrentPath, true );
}

void QDVDAuthor::slotUpdateStructure ()
{
	int t;
	QListViewItem *pMainItem;

	m_pStructureToolbar->listView()->clear();
	m_pStructureToolbar->listView()->setSorting(-1, TRUE);
	pMainItem = new QListViewItem(m_pStructureToolbar->listView(), tr ("DVD Project"));
	pMainItem->setExpandable (TRUE);
	pMainItem->setOpen (TRUE);

	for (t=(int)m_listDVDMenus.count()-1;t>=0;t--)
		m_listDVDMenus[t]->createStructure (pMainItem);
	if (m_pVMGMenu)
		m_pVMGMenu->createStructure (pMainItem);
}

void QDVDAuthor::slotRenameCurrentSubMenu ()
{
	// Here we remove the current SubMenu ...
	QString qsSubMenuName;
	bool bOkay;
	DVDMenu *pMenu = getCurrentSubMenu ();
	if (pMenu == m_pVMGMenu)	{
		QMessageBox::information (NULL, tr ("Can not change VMGM name"),
		tr ("I can not change the name of the VMGM\n"), QMessageBox::Ok);
		return;
	}
	qsSubMenuName = m_pTabWidgetMain->tabLabel(m_pTabWidgetMain->currentPage());
	QString qsNewName = QInputDialog::getText (tr("Sub Menu Name"), tr("Please give the new SubMenu Name"),
			QLineEdit::Normal, QString::null, &bOkay, this );
	if (!bOkay)
		return;
	if (qsNewName.isEmpty())
		return;
	if (pMenu)	{
		pMenu->getInterface()->qsMenuName = qsNewName;
		m_pTabWidgetMain->setTabLabel (m_pTabWidgetMain->currentPage(), qsNewName);
	}
	slotUpdateStructure();
}

void QDVDAuthor::slotRemoveCurrentSubMenu ()
{
	// Here we remove the current SubMenu ...
	QString qsSubMenuName;
	qsSubMenuName = m_pTabWidgetMain->tabLabel(m_pTabWidgetMain->currentPage());
	DVDMenu *pMenu = getCurrentSubMenu ();
	if (pMenu == m_pVMGMenu)	{
		QMessageBox::information (NULL, tr ("Can not remove VMGM"),
		tr ("I can not remove the main VMGM\n"), QMessageBox::Ok);
		return;
	}
	int iReturn = QMessageBox::warning (NULL, tr ("Warning, deleting Sub Menu"),
		tr ("Are you sure you want to remove this sub-menu ?\n"
		"All data will be lost permanently."), QMessageBox::Yes ,  QMessageBox::No);
		if (iReturn == QMessageBox::Yes)
			m_pTabWidgetMain->removePage(m_pTabWidgetMain->currentPage());
	slotUpdateStructure();
}

void QDVDAuthor::slotTabChanged (QWidget *pWidget)
{
	// Here we  need to take care of two things
	// 1) The Tab has changed to a SubMenu (including vmgm)
	// 2) the tab has changed into the XML tab -=> Create XML output
	QString qsTabLabel = m_pTabWidgetMain->tabLabel(pWidget);
	if (qsTabLabel == QString(VMGM_LABEL))	{
		DVDMenu *pMenu = getCurrentSubMenu ();
		if (pMenu)
			m_pColorToolbar->setDVDMenu (pMenu);
	}
	// The last tab is the one to dispaly the XML code
	else if (qsTabLabel == m_pTabWidgetMain->label(m_pTabWidgetMain->count()-1))	{
		m_pComboSource->clear();
		m_pComboSource->insertItem (QString (""));
		m_pComboSource->insertItem (DVDAUTHOR_XML);
		m_pComboSource->insertItem(m_pVMGMenu->name());
		m_pTextEditXml->clear();
		for (uint t=0;t<m_listDVDMenus.count();t++)
			m_pComboSource->insertItem(m_listDVDMenus[t]->name());
	}
	else	{
		DVDMenu *pMenu = getCurrentSubMenu ();
		if (pMenu)
			m_pColorToolbar->setDVDMenu (pMenu);
	}
}

void QDVDAuthor::slotExportDVDAuthorXML()
{
	QString qsFileName = QFileDialog::getSaveFileName (currentPath(), tr ("Xml files (*.xml *.XML)"));
	createDvdauthorXml (qsFileName);
}

void QDVDAuthor::slotEditAddMovie ()
{
	m_pSourceToolbar->slotAddMovie ();
}

void QDVDAuthor::slotEditAddSlideshow ()
{
	m_pSourceToolbar->slotAddSlideshow();
}
/*
void QDVDAuthor::slotSetSlideshowEntry(QString qsSlideshowName)
{
	// We simply call the right function in the SourceToolbar ..
	m_pSourceToolbar->addSlideshow(qsSlideshowName);
}
*/
/*
void QDVDAuthor::slotSlideshowDone(QString qsSlideshowName)
{
	m_pSourceToolbar->replaceSlideshowEntry(qsSlideshowName);
}
*/
void QDVDAuthor::slotStructureClicked(QListViewItem *pItem)
{
	m_pVMGMenu->slotStructureClicked(pItem);
}

void QDVDAuthor::filePrint()
{
	QMessageBox::warning (this, tr("Warning"), tr ("Not implemented Yet"), (int)QMessageBox::Ok, (int)QMessageBox::NoButton);
}

void QDVDAuthor::fileExit()
{
	close();
}

void QDVDAuthor::slotAddSubMenu()
{
	QString qsNewTabLabel = QString ("SubMenu %1").arg(m_listDVDMenus.count()+1);
	DVDMenu *pNewMenu = new DVDMenu(this);
	pNewMenu->getInterface()->qsMenuName = qsNewTabLabel;
	pNewMenu->setTabLabel(qsNewTabLabel);
	addDVDMenu(pNewMenu);
	slotUpdateStructure();
}

DVDMenu *QDVDAuthor::getCurrentSubMenu ()
{
	// determines the SubMenu which is currently selected in the main Tab widget
	QString qsSubMenuName;
	uint t;
	if (!m_pVMGMenu)
		return NULL;
	qsSubMenuName = m_pTabWidgetMain->tabLabel(m_pTabWidgetMain->currentPage());
	if (m_pVMGMenu->getInterface()->qsMenuName == qsSubMenuName)	{
		return m_pVMGMenu;
	}
	for (t=0;t<m_listDVDMenus.count();t++)	{
		if (m_listDVDMenus[t]->getInterface()->qsMenuName == qsSubMenuName)	{
			return m_listDVDMenus[t];
		}
	}
	return NULL;
}

void QDVDAuthor::slotGenerateMasks()
{
	int iMenuCounter = 0;
	QString qsFileName;
	QString qsHeader (tr("Generating Masks ..."));
	QString qsText (tr("Please be patient, I am generating the masks for the Menus.\n"));

	QMessageBox *pTheMessage = new QMessageBox (qsHeader, qsText, QMessageBox::Information, (int)QMessageBox::Ok, (int)QMessageBox::NoButton, (int)QMessageBox::NoButton, NULL, tr("info"), false );
	pTheMessage->show();
	pTheMessage->setText(qsText);

	DVDMenu *pMenu = m_pVMGMenu;
	while (iMenuCounter <= (int)m_listDVDMenus.count())	{
		qsFileName  = getTempFile(pMenu->name() + QString(HIGHLIGHTED_NAME));
		pMenu->createMask (qsFileName, HIGHLIGHTED_MASK);
		qsFileName = getTempFile (pMenu->name() + QString (SELECTED_NAME));
		pMenu->createMask (qsFileName, SELECTED_MASK);
		qsFileName = getTempFile (pMenu->name() + QString (BACKGROUND_NAME));
		pMenu->createMask(qsFileName, BACKGROUND_IMG);
		pMenu = m_listDVDMenus[iMenuCounter++];
	}
	createMenuXml();
	delete pTheMessage;
}

void QDVDAuthor::editUndo()
{
	createDvdauthorXml();
}

void QDVDAuthor::editRedo()
{
	m_pStructureToolbar->listView()->resize(m_pStructureToolbar->listView()->width(), 100);
	m_pStructureToolbar->resize(m_pStructureToolbar->width(), 150);
	m_pSourceToolbar->resize(m_pSourceToolbar->width(), 150);
}

void QDVDAuthor::editCut()
{

}

void QDVDAuthor::editPaste()
{

}

void QDVDAuthor::editFind()
{

}

void QDVDAuthor::helpIndex()
{

}

void QDVDAuthor::helpContents()
{

}

void QDVDAuthor::helpAbout()
{

}

// Here are the standard aux functions
void QDVDAuthor::LoadIni ()
{
	// the fileName of the INI file is a #define in global.h
	QFile file (INI_FILE_NAME);
}

void QDVDAuthor::SaveIni ()
{
	
}

//////////////////////////////////////////////////////////////////////////////////////////
//
// Here we have the routines which create the DVD structure.
//
///////////////////////////////////////////////////////////////////////////////////////////
void QDVDAuthor::slotCreateSVCD()
{
		QMessageBox::information (NULL, tr ("Not implemented yet"),
		tr ("This function is not yet implemented.\n"), QMessageBox::Ok);
		return;
}
void QDVDAuthor::slotCreateVCD()
{
		QMessageBox::information (NULL, tr ("Not implemented yet"),
		tr ("This function is not yet implemented.\n"), QMessageBox::Ok);
}

void QDVDAuthor::slotCreateDVD()
{
	// This function is invoked when the user wants to create the menu structure.
	// THus this function does the following
	// create /tmp/spumux.xml
	// create /tmp/dvdauthor.xml
	// invoke spumux -> output to dialog
	// invoke dvdauthor, but use dummy vob files rather then the original (hiuge) ones.

	// This command will generate the Project path under the temp directory. This'll ensure the directory is present and writable for the temp data
	QString qsTempPath = getTempFile (QString());

	// The following line is already called from slotGenerateMasks
//	createMenuXml ();		// /tmp/spumux.xml
	createDvdauthorXml ();	// /tmp/dvdauthor.xml
	// And then we create the script to generate all those funcky files ...
	createDVD ();
}

void QDVDAuthor::createMenuXml ()
{
	createMenuXml (m_pVMGMenu);
	uint t;
	for (t=0;t<m_listDVDMenus.count();t++)
		createMenuXml (m_listDVDMenus[t]);
}
// The following function will display the XML code for the specified Submenu (spumux)
// or the dvdauthor.xml - file in the XML - tab.
void QDVDAuthor::slotCreateXml(const QString &qsWhich)
{
	uint t;
	QString fileSpumux;
	getTempFile( QString () );
	if (qsWhich.isEmpty())	{
		m_pTextEditXml->clear();
		return;
	}
	if (qsWhich == QString (DVDAUTHOR_XML)) 	{
		createDvdauthorXml();
		fileSpumux = getTempFile(QString(DVDAUTHOR_XML));
	}
	else if (qsWhich == m_pVMGMenu->name())	{
		// Here we create the xml - file in the temp dir.
		createMenuXml(m_pVMGMenu);
		fileSpumux = getTempFile(m_pVMGMenu->name()+QString (".xml"));
	}
	else {
		for (t=0;t<m_listDVDMenus.count();t++)	{
			if (qsWhich == m_listDVDMenus[t]->name())	{
				// Here we create teh xml - file in the temp dir.
				createMenuXml(m_listDVDMenus[t]);
				fileSpumux = getTempFile(m_listDVDMenus[t]->name()+QString (".xml"));
				break;
			}
		}
	}
	// Finally we read in the xml file.
	m_pTextEditXml->clear();
	QFile file( fileSpumux ); // Read the text from a file
	if ( file.open( IO_ReadOnly ) ) {
		QTextStream stream( &file );
		m_pTextEditXml->setText( stream.read() );
	}
}

void QDVDAuthor::createMenuXml (DVDMenu *pMenu)
{
	uint t, i;
//	CDVDMenuInterface *pInterface = m_pDVDMenu->getInterface();
	QString qsUp, qsDown, qsLeft, qsRight;
	CXmlSpumux xmlSpumux;
	CXmlSpumux::spu_struct *pSpu = xmlSpumux.m_subpictures.stream.addSpu();
	CXmlSpumux::button_struct *pXmlButton;
	ButtonObject *pButton;
	QColor transparentColor = pMenu->getColor(1); // for highlighted layer ... (TRANSPARENT_COLOR);

	pSpu->start			= QString ("00:00:00.0");
	pSpu->end			= QString ("00:00:00.0");
	pSpu->force			= QString ("yes");		// force is required for menus.

	char s[] = "000000";
	sprintf (s, "%02x%02x%02x",
		transparentColor.red  (), 
		transparentColor.green(), 
		transparentColor.blue ());
	pSpu->transparent	= QString (s);

//	pSpu->autooutline	= QString ("infer");
//	pSpu->autoorder		= QString ("rows");
	pSpu->highlight		= getTempFile(pMenu->name() + QString(HIGHLIGHTED_NAME));
	pSpu->select		= getTempFile(pMenu->name() + QString(HIGHLIGHTED_NAME)); // for now two diff images does not work ...
		// Need to figure this one out ...
//	pSpu->select		= getTempFile(pMenu->name() + QString(SELECTED_NAME) + pMenu->name());
//	pSpu->outlinewidth	= 5;
	QValueList<ButtonObject *> listButtons;
	QValueList<CXmlSpumux::button_struct *> listXmlButtons;
	listButtons = pMenu->getButtons();
	for (t=0;t<listButtons.count ();t++)	{
		pXmlButton = pSpu->addButton();
		pXmlButton->x0 = listButtons[t]->boundingRect().left();
		pXmlButton->y0 = listButtons[t]->boundingRect().top();
		pXmlButton->x1 = listButtons[t]->boundingRect().right();
		pXmlButton->y1 = listButtons[t]->boundingRect().bottom();
		pXmlButton->label=QString ("%1").arg(t+1);
		listXmlButtons.append(pXmlButton);
	}
	// After we have generated the Xml Buttons and assigned them some nice names,
	// we should connect up/down/left/right.
	for (t=0;t<listButtons.count ();t++)	{
		pXmlButton = listXmlButtons[t];	// Ought to be same number as listButtons.count()
		pButton = listButtons[t];
		for (i=0;i<listButtons.count();i++)	{
			// Here we find the buttoin label which fits the button. 
			// I.e. we associate the label in the xml file to the label in the ButtonObject
			if ( (!pButton->next(NEXT_BUTTON_UP).isEmpty()) && 
				(pButton->next(NEXT_BUTTON_UP) == listButtons[i]->name()) )
				pXmlButton->up = QString ("%1").arg(i+1);
			if ( (!pButton->next(NEXT_BUTTON_DOWN).isEmpty()) && 
				(pButton->next(NEXT_BUTTON_DOWN) == listButtons[i]->name()) )
				pXmlButton->down = QString ("%1").arg(i+1);
			if ( (!pButton->next(NEXT_BUTTON_LEFT).isEmpty()) && 
				(pButton->next(NEXT_BUTTON_LEFT) == listButtons[i]->name()) )
				pXmlButton->left = QString ("%1").arg(i+1);
			if ( (!pButton->next(NEXT_BUTTON_RIGHT).isEmpty()) && 
				(pButton->next(NEXT_BUTTON_RIGHT) == listButtons[i]->name()) )
				pXmlButton->right = QString ("%1").arg(i+1);
		}
	}
//	QString fileSpumux = getTempFile(QString ("spumux.xml"));
	QString fileSpumux = getTempFile(pMenu->name() + QString (".xml"));
	xmlSpumux.writeXml (fileSpumux);
}

QString QDVDAuthor::getButtonAction (ButtonObject *pButton, int iCurrentTitleset, bool bVMGM)
{
	int t, i, iTitleset, iSubMenuNumber, iTitleNumber, iChapterNumber, iChapterCounter;

	QString qsAction;
	QFileInfo fileInfo;
	SourceFileInfo *pInfo;
	// Lets recoup the three action strings again ...
	QStringList actionList = QStringList::split(QString (STRING_SEPARATOR), pButton->action());

	iChapterCounter = 0;
	if (pButton->sourceFileEntry())	{	// Button to Movie file
		SourceFileEntry *pEntry = pButton->sourceFileEntry();
		// Here we get the Number of the title for the Movie - file
		iTitleNumber = pEntry->iTitle;
		iTitleset    = pEntry->iTitleset;
		// Here we get the Number of the chapter ...
		iChapterNumber = 1;
		if (actionList.count() > 2)	{	// This is to prevent asking for something that does not exist.
			for (i=0;i<(int)pEntry->listFileInfos.count();i++)	{
				pInfo = pEntry->listFileInfos[i];
				for (t=0;t<(int)pInfo->listChapters.count();t++)	{
					// here we count the chapters ...
					iChapterCounter ++;
					// If we have multiple video streams in this Source Entry, then 
					// we are only interested to find the chapter of the right file.
					fileInfo.setFile(pInfo->qsFileName);
					if ( (actionList.count() == 4) && (fileInfo.fileName() != actionList[actionList.count()-2]) )	// the name of the file
						continue;
					// Okay, at this point we have th right file and we are really seeking the chapter.
					if (pInfo->listChapters[t] == actionList[actionList.count()-1])	// the chapter
						iChapterNumber = iChapterCounter; // + i;	// +i since each file is a chapter in itself
				}
			}
		}
		// Next is to build the ACTION
		if (bVMGM)	// VMGM calls titles by a flat list rather then by Titleset / title.
			qsAction = actionList[0] + QString (" title %1 chapter %2; ").arg(iTitleNumber).arg(iChapterNumber);
		if (iTitleset == iCurrentTitleset)	// The currentTitleset does not need to jump to VMGM firsdt in order to return then !!!
			qsAction = actionList[0] + QString (" title %1 chapter %2; ").arg(iTitleNumber).arg(iChapterNumber);
		else
			qsAction = actionList[0] + QString (" titleset %1 title %2 chapter %3; ").arg(iTitleset).arg(iTitleNumber).arg(iChapterNumber);
	}
	else	{	// Button to Menu (SubMenu)m_listDVDMenu
		DVDInfo *pInfo = NULL;
		int iVMGMTitleset=0;
		if (bVMGM)	{
			// Here we check if the VMGM has a  button to a movie, in which case we generate a Titleset for it.
			// And thus bump up the other Titlesets by one.
			QValueList <ButtonObject *>listButtons = m_pVMGMenu->getButtons();
			for (t=0;t<(int)listButtons.count();t++)	{
				if (listButtons[t]->sourceFileEntry() != NULL)	{
					iVMGMTitleset = 1;
					break;
				}
			}
		}
		for (i=0;i<(int)m_listDVDMenus.count();i++)	{
			// Okay, if we found the DVDMenu - name equals the second action ...
			if (m_listDVDMenus[i]->name() == actionList[1])	{
				pInfo = m_listDVDMenus[i]->getDVDInfo();
				if (pInfo)	{
					iTitleset = pInfo->titleset ();
					iSubMenuNumber = pInfo->subMenuNumber ();
				}
				else	// Error, got NULL back ...
					iTitleset = iSubMenuNumber = 1;
				// Next we could check if the Button is in the same Titleset(which it must) and
				// in case not we could offer the User an Option to choose from ...

				// For now every Menu has one Titleset ...
				qsAction = actionList[0] +
					QString (" titleset %1 menu %2; ").arg(i+1+iVMGMTitleset).arg(iSubMenuNumber);
//				qsAction = actionList[0] + QString (" titleset %1 menu %2; ").arg(iTitleset).arg(iSubMenuNumber);
				break;
			}
		}
		if ( (m_pVMGMenu->name() == actionList[1]) || (QString ("vmgm") == actionList[1]) )	{
			pInfo = m_pVMGMenu->getDVDInfo();
			if (pInfo)
				iSubMenuNumber = pInfo->subMenuNumber ();
			else
				iSubMenuNumber = 1;
			qsAction = actionList[0] + QString (" vmgm menu %2; ").arg(iSubMenuNumber);
		}
//printf ("QDVDAuthor::getButtonAction <%s> - <%s>\n", (const char *)actionList[1], (const char *)qsAction);
//		pButton->value = qsAction;	// jump titleset x menu y ;
	}
	return qsAction;
}

// Change of Logic May 1'st
// o	Find all movies related to one Menu
// o	Set Titleset, and Title of Titleset
// o	Check if movie already exists in previous Titleset.
//		- yes -> Use previouse Titleset.
//		- No  -> implement in this (Menus) Titleset.
// o	Check if Menu and Movie have the same Format.
//		- Yes -> proceed
//		- No  -> generate a new Titleset for this movie.
	
	
void QDVDAuthor::createDvdauthorXml ()
{
	// And here we save it to the temp directory.
	QString fileName = getTempFile(QString (DVDAUTHOR_XML));
	createDvdauthorXml (fileName);
}

void QDVDAuthor::createDvdauthorXml (QString &qsFileName)
{
	int t, i, j, k;
	bool bFound;
	int iCurrentTitleset, iVMGMTitles;
	iVMGMTitles = 0;
	iCurrentTitleset = 1;

	CDVDMenuInterface *pInterface = m_pVMGMenu->getInterface();

	CXmlDVDAuthor xmlDvdauthor;
	CXmlDVDAuthor::button_struct *pButton;
	CXmlDVDAuthor::vob_struct *pVob;
	CXmlDVDAuthor::menus_struct *pMenus;
	CXmlDVDAuthor::titles_struct *pTitles;
	CXmlDVDAuthor::pgc_struct *pPgc;
	CXmlDVDAuthor::titleset_struct *pTitleset;
	xmlDvdauthor.m_dvdauthor.dest = m_qsProjectPath;
	xmlDvdauthor.m_dvdauthor.jumppad = QString ("yes");
	SourceFileEntry *pEntry = NULL;
	// First we create the main menu ...
	pMenus = xmlDvdauthor.m_dvdauthor.vmgm.addMenus();

	int iFormat;
	// iFormat > 4 equals PAL, otherwise NTSC
	iFormat = m_pVMGMenu->getFormat (pInterface->iWidth, pInterface->iHeight);
	// The first thing we specify is the video settings ...
	if (iFormat > 4)
		pMenus->video.format = QString ("pal");
	else
		pMenus->video.format = QString ("ntsc");
	pMenus->video.resolution = QString ("%1x%2").arg(pInterface->iWidth).arg(pInterface->iHeight);
//	pMenus->video.aspect = QString ("4:3");

	pPgc = pMenus->addPgc();
	pPgc->entry = QString ("title");

	QValueList<ButtonObject *> listButtons;
	listButtons = m_pVMGMenu->getButtons();

	// Here we create a list of all Movie Files associated with the VMGMenu
	// The list holds only one record per movie (I.e. if the movie is accessible twice only one record is stored)!!!
	QStringList listMenuMovies;
	int iTitleNumber = 0;
	for (t=0;t<(int)listButtons.count ();t++)	{
		if (listButtons[t]->sourceFileEntry())	{	// We found a button associated to a Movie
			bFound = false;
			for (i=0;i<(int)listMenuMovies.count();i++)	{ // Let's make sure we have only one entry per movie.
				if (listMenuMovies[i] == listButtons[t]->sourceFileEntry()->qsDisplayName)
					bFound = true;
			}
			if (!bFound)	{	// here we add the movie only if it does not already exist in this titleset.
				listMenuMovies.append (listButtons[t]->sourceFileEntry()->qsDisplayName);
				// Oh and we also set the associated Titleset for this entry ... VMGM always 1!
				listButtons[t]->sourceFileEntry()->iTitleset = 1;
				listButtons[t]->sourceFileEntry()->iTitle = ++iTitleNumber;
			}
		}
	}

	// We need to put some brain into this since we neeed to convert from fileNames, to numbers etc.
	for (t=0;t<(int)listButtons.count ();t++)	{
		pButton = pPgc->addButton();
		pButton->name = QString ("%1").arg(t+1);
		pButton->value = getButtonAction (listButtons[t], iCurrentTitleset, true); // jump titleset x menu y ;
	}
	pVob = pPgc->addVob ();
	// The menu movie file name for the Menu itself ...
	if (pInterface->qsMovieFileName.isNull())
		pVob->file = QString ("%1_menu.mpg").arg(getTempFile(m_pVMGMenu->name())); //getTempFile(BACKGROUND_NAME));
	else
		pVob->file = QString (pInterface->qsMovieFileName);
	pVob->pause = QString ("inf");
	// And then we create the titles which are directly associated to the VMGM - menu ... (Titleset 1)
	QValueList<SourceFileEntry *>listSourceFileEntries;
	listSourceFileEntries = m_pVMGMenu->getSourceFileEntries();
	pTitleset = NULL;	// It could be that we have only menus here in which case we would not need a Titleset
	pTitles = NULL;		// It could be that we have only menus here in which case we would not need a Titleset
	if (listSourceFileEntries.count() > 0)	{
		for (t=0;t<(int)listSourceFileEntries.count();t++)	{
			pEntry = listSourceFileEntries[t];
			// Next we check if we have this SourceFileEntry already handled in the SubMenu.
			bFound = false;
			for (i=0;i<t;i++)
				if (pEntry == listSourceFileEntries[i])
					bFound = true;
			if ( (pEntry) && (!bFound) )	{
				if (!pTitleset)	{// Okay, we found at least one movie ...
					pTitleset = xmlDvdauthor.m_dvdauthor.addTitleset();
					// Next for the Jumppad we need a dummy menu ...
					pMenus = pTitleset->addMenus();
					pTitles = pTitleset->addTitles();
					iVMGMTitles = 1;
				}
				pPgc = pTitles->addPgc();
				pPgc->post.value = QString (" call vmgm menu 1; ");
				// For each filename in this SourceFileEntry we create one VOB ( another chapter ... )
				for (i=0;i<(int)pEntry->listFileInfos.count();i++)	{
					pVob = pPgc->addVob();
					pVob->file= QString(pEntry->listFileInfos[i]->qsFileName);
					pVob->chapters = QString (pEntry->listFileInfos[i]->listChapters.join(QString(",")));
				}
			}
		}
	}

	// And here follows nearly the same for each m_listSubMenus - entry.
	for (t=0;t<(int)m_listDVDMenus.count();t++)	{
		iCurrentTitleset = t+iVMGMTitles + 1;	// it is 1 based, thus +1
		pInterface = m_listDVDMenus[t]->getInterface();
		pTitleset = xmlDvdauthor.m_dvdauthor.addTitleset();
		pMenus = pTitleset->addMenus();
		// iFormat > 4 equals PAL, otherwise NTSC
		iFormat = m_listDVDMenus[t]->getFormat (pInterface->iWidth, pInterface->iHeight);
		// The first thing we specify is the video settings ...
		if (iFormat > 4)
			pMenus->video.format = QString ("pal");
		else
			pMenus->video.format = QString ("ntsc");
		pMenus->video.resolution = QString ("%1x%2").arg(pInterface->iWidth).arg(pInterface->iHeight);
//		pMenus->video.aspect = QString ("4:3");

		pPgc = pMenus->addPgc();
		listButtons = m_listDVDMenus[t]->getButtons();

		// Here we append to the list of all Movie Files
		// The list holds only one record per movie !!!
//		listMenuMovies.clear();
		iTitleNumber = 0;
		for (j=0;j<(int)listButtons.count ();j++)	{
			if (listButtons[j]->sourceFileEntry())	{	// We found a button associated to a Movie
				bFound = false;
				for (i=0;i<(int)listMenuMovies.count();i++)	{ // Let's make sure we have only one entry per movie.
					if (listMenuMovies[i] == listButtons[j]->sourceFileEntry()->qsDisplayName)
						bFound = true;
				}
				if (!bFound)	{
					listMenuMovies.append (listButtons[j]->sourceFileEntry()->qsDisplayName);
					// Oh and we also set the associated Titleset for this entry ... VMGM always 1!
					listButtons[j]->sourceFileEntry()->iTitleset = iCurrentTitleset;
					listButtons[j]->sourceFileEntry()->iTitle = ++iTitleNumber;
				}
			}
		}

		for (i=0;i<(int)listButtons.count ();i++)	{
			pButton = pPgc->addButton();
			pButton->name = QString ("%1").arg(i+1);
			pButton->value = getButtonAction (listButtons[i], iCurrentTitleset); // jump titleset x menu y ;
		}
		pVob = pPgc->addVob ();
		// The menu movie file name.
		if (pInterface->qsMovieFileName.isNull())
			pVob->file = QString ("%1_menu.mpg").arg(getTempFile(m_listDVDMenus[t]->name())); //getTempFile(BACKGROUND_NAME));
		else
			pVob->file = QString (pInterface->qsMovieFileName);
		pVob->pause = QString ("inf");

		listSourceFileEntries =  m_listDVDMenus[t]->getSourceFileEntries();
		pTitles = pTitleset->addTitles();
		bFound = false;
		for (j=0;j<(int)listSourceFileEntries.count();j++)	{
			pEntry = listSourceFileEntries[j];
			// check if this entry was created by a button to a menu. in which case pEntry = NULL.
			// Next we check if we have this SourceFileEntry already handled in the SubMenu.
			bFound = false;
			for (i=0;i<t;i++)	{
				// so first we got to get the SourceFileEntries of the previous menus ...
				QValueList<SourceFileEntry *> listCompare =  m_listDVDMenus[i]->getSourceFileEntries();
				for (k=0;k<(int)listCompare.count();k++)	{
					if (pEntry == listCompare[k])
						bFound = true;
				}
			}
			if ( (pEntry) && (!bFound) )	{
				// Next we check if the Entry is pointing to another Titleset
				// in which case we don't need this movie here any more ...
				bool bContinue = false;
				for (i=0;i<(int)listMenuMovies.count();i++)	{
					if ( (pEntry->qsDisplayName == listMenuMovies[i]) &&
						 (pEntry->iTitleset == iCurrentTitleset) )	{
						bContinue = true;
						break;
					}
				}
				if (bContinue)	{
					bFound = true;
					pPgc = pTitles->addPgc();
					pPgc->post.value = QString (" call menu; ");
					// For each filename in this SourceFileEntry we create one VOB ( another chapter ... )
					for (i=0;i<(int)pEntry->listFileInfos.count();i++)	{
						pVob = pPgc->addVob();
						pVob->file= QString(pEntry->listFileInfos[i]->qsFileName);
						pVob->chapters = QString (pEntry->listFileInfos[i]->listChapters.join(QString(",")));
					}
				}
			}
		}
		// This one ensures that we add an empty pgc record which dvdauthor insists upon.
		if (!bFound)
			pTitles->addPgc();
	}
	xmlDvdauthor.writeXml(qsFileName);
}

bool QDVDAuthor::checkHealth ()
{
	// This function checks if all is in order
	// o  There is a background image.
	//    - If not only a standard VideoDVD is created without menu.
	// o  There are buttons defined
	//    - Wether through a mask, or manually defined.
	// o  There is enough space on the defined temp - path.
	//    - approximately by adding all sizes together.
	// o  And the temp drive should be writeable.

	CDVDMenuInterface *pInterface = m_pVMGMenu->getInterface();
	// primary implementation only checks for Background, and mask images.
	if (m_qsTempPath.isEmpty())	{
		QMessageBox::warning ( this, tr ("Error, missing temp path."),
			tr ("You forgot to specify a temp path.\n"
				"I can not build this DVD without temp path.\n"
				"Please define the missing temp path first.\n"),
				QMessageBox::Ok, QMessageBox::NoButton);
		return false;
	}
	else	{
		// Check if we can write to the temp path.
		QFile file( m_qsTempPath + QString ("/test_file") );
		if ( !file.open( IO_WriteOnly ) )	{
			QMessageBox::warning ( this, tr ("Error, can't write to temp."),
				tr ("I can not write to the specified temp directory.\n%1\n"
					"Please verify the temp path and try again.\n").arg(m_qsTempPath),
					QMessageBox::Ok, QMessageBox::NoButton);
			return false;
		}
		else	{
        	file.close();
			file.remove();
		}
	}
	if (m_qsProjectPath.isEmpty())	{
		if (QMessageBox::warning ( this, tr ("Error, missing DVD path."),
			tr ("You forgot to specify the DVD path.\n"
				"I can not build this DVD without a DVD path.\n"
				"Do you want to define the missing DVD path now ?\n"),
				QMessageBox::Yes, QMessageBox::No) == QMessageBox::Yes)
				slotSetup();
		return false;
	}
	else	{
		// Check if we can write to the projectPath.
		QFile file( m_qsProjectPath + QString ("/test_file") );
		if ( !file.open( IO_WriteOnly ) )	{
			if (QMessageBox::warning ( this, tr ("Error, can't write to project path."),
				tr ("I can not write to the specified Project directory.\n%1\n"
					 "Do you want to change the specified path now ?\n").arg(m_qsProjectPath),
					QMessageBox::Yes, QMessageBox::No) == QMessageBox::Yes)
				slotSetup();
			return false;
		}
		else	{
        	file.close();
			file.remove();
		}
	}
	if (pInterface->qsBackgroundFileName.isEmpty())	{
		if (QMessageBox::warning ( this, tr ("No background defined."),
			tr ("You did not define a background image.\n"
				"Do you want to create a VideoDVD without Menu ?\n"),
				QMessageBox::Yes, QMessageBox::No) == QMessageBox::Yes)	{
			// Here we create a Video DVD without a menu
		}
		// otherwise we abort here.
		else
			return false;
	}

	QValueList<ButtonObject *> listButtons;
	listButtons = m_pVMGMenu->getButtons();
	if ( (pInterface->qsHighlightedMaskFileName.isEmpty()) && (pInterface->qsSelectedMaskFileName.isEmpty()) &&
		(listButtons.count() == 0) )	{
		if (QMessageBox::warning ( this, tr ("No button masks defined."),
			tr ("You did not define any buttons.\n"
				"Do you want to create a VideoDVD without Menu ?\n"),
				QMessageBox::Yes, QMessageBox::No) == QMessageBox::Yes)	{
			// Here we create a Video DVD without a menu
		}
		// otherwise we abort here.
		else
			return false;
	}
	if (m_pSourceToolbar->sourceFileCount() < 1)	{
		if (QMessageBox::warning ( this, tr ("No movies defined."),
			tr ("You did not select any movies.\n"
				"Do you want to create a DVD with Menu and no movies ?\n"),
				QMessageBox::Yes, QMessageBox::No) == QMessageBox::Yes)	{
			// Here we create a Video DVD without movie files.
		}
		// otherwise we abort here.
		else
			return false;
	}
	// Here we check if there is already a dvd in place where the new one should be
	uint t;
	QDir projectDir (m_qsProjectPath + QString ("/VIDEO_TS/"));
	QStringList listFiles = projectDir.entryList ("*");
	if (listFiles.count() > 2)	{	// the two standard directories . and ..
		QString stringFiles;
		for (t=0;t<listFiles.count();t++)	{
			if ( (listFiles[t] == ".") || (listFiles[t] == "..") )
				continue;
			stringFiles += QString ("%1\n").arg(listFiles[t]);
		}
		if (QMessageBox::warning ( this, tr ("DVD files found."),
			tr ("I found DVD files most likely from a previous run.\n%1"
				"Do you want to remove those files first ?\n").arg(stringFiles),
				QMessageBox::Yes, QMessageBox::No) == QMessageBox::Yes)	{
				// Here we remove all files under m_qsProjectPath/VIDEO_TS/
			for (t=0;t<listFiles.count();t++)	{
				if ( (listFiles[t] == ".") || (listFiles[t] == "..") )
					continue;
				projectDir.remove (listFiles[t]);
			}
		}
	}

	return true;
}

QString &QDVDAuthor::getTempFile (QString qsOrigFileName)
{
	static QString qsTempFile;
	static QString qsTempDir = m_qsTempPath + QString ("/");
	if (qsOrigFileName.isEmpty())	{
		// we take this to check if the temp drive xists and if not, then we will create one ...
//		QDir tempDir (m_qsTempPath + QString ("/qdvdauthor%1").arg(QThread::currentThread()));
		QDir tempDir (m_qsTempPath + QString ("/") + m_qsProjectName);
		if (!tempDir.exists())
			tempDir.mkdir (m_qsTempPath + QString ("/") + m_qsProjectName);
		if (!tempDir.exists())	{
			QMessageBox::warning ( this, tr ("Could not create temp directory"),
			tr ("Failed to create temp directory\n"
				"%1").arg (m_qsTempPath + QString ("/") + m_qsProjectName),
				QMessageBox::Ok, QMessageBox::Ok);
				qsTempFile = m_qsTempPath;
				return qsTempFile;
		}
		qsTempDir = m_qsTempPath + QString ("/") + m_qsProjectName + QString ("/");
	}
	QFileInfo fileInfo = QFileInfo(qsOrigFileName);
	qsTempFile = QString (qsTempDir + fileInfo.fileName());
	return qsTempFile;
}

void QDVDAuthor::createDVD ()
{
	// Note: All the logic has been put into the file and is created in QDVDAuthorInit.
	if (!checkHealth())
		return;

	// First let us create the directory under the temp - drive
	QString qsBackgroundFileName;
	QString qsMenuName;
	// Ensure that the temp drive is present, otherwise create it.
	// Error message if not possible.
	QString qsTempPath = getTempFile (QString());
	QStringList stringList;

	int iMenuCounter = 0;
	DVDMenu *pMenu = m_pVMGMenu;

	QDVDAuthorInit *pInit = new QDVDAuthorInit (qsTempPath, m_qsProjectPath, getTempFile(DVDAUTHOR_XML));
	// Here we go through all Menus (including VMGM) and generate the appropriate commands.
	pInit->appendPreProcessing ();
	while (iMenuCounter <= (int)m_listDVDMenus.count())	{
		qsMenuName = getTempFile (pMenu->name());
		qsBackgroundFileName = getTempFile (pMenu->name() + QString (BACKGROUND_NAME));
		pInit->appendMenu (pMenu, qsMenuName, qsBackgroundFileName);
		pMenu = m_listDVDMenus[iMenuCounter++];
	}	// end of loop ...
	pInit->appendPostProcessing ();

	// And finally we call the CommandQueue - Dialog.
	DialogExecute *pDialogExecute = new DialogExecute(pInit->getList());
	connect (pDialogExecute, SIGNAL (signalGenerateMasks()), this, SLOT (slotGenerateMasks()));
	pDialogExecute->setPaths(m_qsProjectPath, m_qsTempPath);
	pDialogExecute->setInit(pInit);
	pDialogExecute->exec();
	// And after this I don't need the QDVDAuthorInit - object any more ...
	delete pInit;
	// Okay if I were to delete this dialog here then the commands are not beeing executed and I look stupid.
	// So Dr clever, how do I clean up this memory swallowing state ? 
//	delete pDialogExecute;
}

/*
Here is the version before May 12'th 2004.
This version is hardcoded and does not include the flexibility of the init - file under the
~/.qdvdauthor - directory.
void QDVDAuthor::createDVD ()
{
	uint t;
	// Okay, this does not really belong to the menu object.
	// But I want to get this alpha working so I can publish the code ...
	// so here we generate the menu mpg - file
	if (!checkHealth())
		return;
	QColor arrayColors[12];
	arrayColors[0] = QColor (158,238,129); // #9EEE81
	arrayColors[1] = QColor (143,238,211); // #8FEED3
	arrayColors[2] = QColor (224,238,143); // #E0EE8F
	arrayColors[3] = QColor (237,151,238); // #ED97EE
	arrayColors[4] = QColor (158,238,129); // #9EEE81
	arrayColors[5] = QColor (143,238,211); // #8FEED3
	arrayColors[6] = QColor (224,238,143); // #E0EE8F
	arrayColors[7] = QColor (237,151,238); // #ED97EE
	arrayColors[8] = QColor (158,238,129); // #9EEE81
	arrayColors[9] = QColor (143,238,211); // #8FEED3
	arrayColors[10]= QColor (224,238,143); // #E0EE8F
	arrayColors[11]= QColor (249,47,94);   // #F92F5E

	QValueList <ExecuteInterface *>listExecute;

	// First let us create the directory under the temp - drive
	ExecuteInterface *pInterface = new ExecuteInterface;
	QString qsBackgroundFileName;
	QString qsMenuName;
	
	// Ensure that the temp drive is present, otherwise create it.
	// Error message if not possible.
	QString qsTempPath = getTempFile (QString());
	QStringList stringList;

	int iMenuCounter = 0;
	int iFormat = 0;
	DVDMenu *pMenu = m_pVMGMenu;
	// Here we go through all Menus (including VMGM) and generate the appropriate commands.
	while (iMenuCounter <= (int)m_listDVDMenus.count())	{
		qsMenuName = getTempFile (pMenu->name());
		qsBackgroundFileName = getTempFile (pMenu->name() + QString (BACKGROUND_NAME));

		// iFormat > 4 equals PAL, otherwise NTSC
		iFormat = pMenu->getFormat (pMenu->getInterface()->iWidth, pMenu->getInterface()->iHeight);

		pInterface = new ExecuteInterface;
		if (iFormat > 4)	// PAL
			pInterface->qsBlockName = pMenu->name() +QString (" (PAL %2x%3)").arg(pMenu->getInterface()->iWidth).arg(pMenu->getInterface()->iHeight);
		else
			pInterface->qsBlockName = pMenu->name() +QString (" (NTSC %2x%3)").arg(pMenu->getInterface()->iWidth).arg(pMenu->getInterface()->iHeight);

		pInterface->backgroundColor = arrayColors[iMenuCounter%12];

		// Okay if the user selected a movie as background, then we need to convert it to the propper Format.
		QFileInfo backgroundInfo (qsBackgroundFileName);
		if ( (backgroundInfo.extension() == "mpg")  ||
			 (backgroundInfo.extension() == "mpeg") ||
			 (backgroundInfo.extension() == "avi"))	{
			QString qsCommentMenu;
			QString qsGenerateMenu;
			if (iFormat > 4)	{	// PAL
		 		qsCommentMenu = QString (tr("<p align=\"center\">This line of command will convert the background movie<BR>into a MPEG2 stream in PAL format %1x%2</p>").arg(pMenu->getInterface()->iWidth).arg(pMenu->getInterface()->iHeight));
				qsGenerateMenu = QString ("transcode -i -V -J fps 25 --export_asr 2 --keep_asr -Z %1x%2 -y jpg,wav -m %3/audio%4.wav -o background%5" ).arg(pMenu->getInterface()->iWidth).arg(pMenu->getInterface()->iHeight).arg(qsTempPath).arg(qsMenuName).arg(qsMenuName);
				stringList.append(qsGenerateMenu);
			}
			else	{
		 		qsCommentMenu = QString (tr("<p align=\"center\">This line of command will convert the background movie<BR>into a MPEG2 stream in NTSC format %1x%2</p>").arg(pMenu->getInterface()->iWidth).arg(pMenu->getInterface()->iHeight));
				qsGenerateMenu = QString ("transcode -i -V -J fps 29.970 --export_asr 2 --keep_asr -Z %1x%2 -y jpg,wav -m %3/audio%4.wav -o background%5" ).arg(pMenu->getInterface()->iWidth).arg(pMenu->getInterface()->iHeight).arg(qsTempPath).arg(qsMenuName).arg(qsMenuName);
				stringList.append(qsGenerateMenu);
			}
			pInterface->listCommandList.append(stringList);
			pInterface->commentList.append(qsCommentMenu);
			stringList.clear();
		}
		else	{	// The menubackground is a image file.
			// First variant does not stop due to a problem in the current version of jpeg2yuv
			QString qsCommentMpg;
			QString qsGenerateMpg;
			if (iFormat > 4)	{	// PAL
			 	qsCommentMpg = QString (tr("<p align=\"center\">This line of command will convert the background image<BR>into a MPEG2 stream in PAL format %1x%2</p>").arg(pMenu->getInterface()->iWidth).arg(pMenu->getInterface()->iHeight));
				qsGenerateMpg = QString ("jpegtopnm \"%1\" | ppmtoy4m -n 1 -F25:1 -A59:54 -I t -L | mpeg2enc -f 8 -n p -o \"%2.m2v\"").arg(qsBackgroundFileName).arg(qsMenuName);
				stringList.append(qsGenerateMpg);
				qsGenerateMpg = QString ("jpeg2yuv -n 50 -I p -f 25 -j \"%1\" | mpeg2enc -n p -f 8 -o \"%2.m2v\"").
				arg(qsBackgroundFileName).arg(qsMenuName);
				stringList.append(qsGenerateMpg);
			}
			else	{
			 	qsCommentMpg = QString (tr("<p align=\"center\">This line of command will convert the background image<BR>into a MPEG2 stream in NTSC format %1x%2</p>").arg(pMenu->getInterface()->iWidth).arg(pMenu->getInterface()->iHeight));
				qsGenerateMpg = QString ("jpegtopnm \"%1\" | ppmtoy4m -n 1 -F30000:1001 -A10:11 -I t -L | mpeg2enc -f 8 -n n -o \"%2.m2v\"").arg(qsBackgroundFileName).arg(qsMenuName);
				stringList.append(qsGenerateMpg);
				qsGenerateMpg = QString ("jpeg2yuv -n 50 -I p -f 29.97 -j \"%1\" | mpeg2enc -n n -f 8 -o \"%2.m2v\"").
				arg(qsBackgroundFileName).arg(qsMenuName);
				stringList.append(qsGenerateMpg);
			}
			pInterface->listCommandList.append(stringList);
			pInterface->commentList.append(qsCommentMpg);
			stringList.clear();
		}

// Note, spumux > button 'label' is ought to be 'name' now ??? (spumux from 19 Feb 2004)
// More on multichannel audio can be found under : http://www.dahnielson.com/primer.txt
// -- pcm2aiff inFile -c5 -r1
// -- mctoolame -m s -n d -L 6channelAiffFile.aiff output.m2v

// Trial and error : arecord -S -M -t 1 -w /dev/stdout | mp2enc -r 48000 -o \"%1.mp2\"
		QStringList soundList;
		if (pMenu->getInterface()->listSoundFiles.count() == 0)	{
			QString qsCommentSound ("<p align=\"center\">This line creates an empty sound file to mix into the menu-movie.</P>");
			QString qsSound;
			if (iFormat > 4)	{	// PAL
 				qsSound = QString ("arecord -f dat -twav -d 1 /dev/stdout | mp2enc -r 48000 -o %1.mp2").arg(qsMenuName);
				stringList.append(qsSound);
//				qsSound = QString ("arecord -t 1 -f s16l -M -w  /dev/stdout | mp2enc -r 48000 -o \"%1.mp2\"").arg(qsMenuName); this one does not work .. why ?
				qsSound = QString ("arecord -S -M -t 1 -w /dev/stdout | mp2enc -r 48000 -o \"%1.mp2\"").arg(qsMenuName);
				stringList.append(qsSound);
// This worked at work ... arecord 0.5.10
//arecord -t 1 -f s16l -M -w  /dev/stdout | mp2enc -r 48000 -o "/tmp/TestMe/Main Menu VMGM.mp2"

				qsSound = QString ("sox -t raw -s -w -c 2 -r 48000 /dev/zero -t wav -c 2 -r 48000 /dev/stdout trim 0 1 | mp2enc -r 48000 -o \"%1.mp2\"").arg(qsMenuName);
				stringList.append(qsSound);
				qsSound = QString ("dd if=/dev/zero bs=4 count=1920 | toolame -b128 -s 48 /dev/stdin \"%1.mp2\"").arg(qsMenuName);
				stringList.append(qsSound);
			}
			else	{
 				qsSound = QString ("arecord -f dat -twav -d 1 /dev/stdout | mp2enc -r 48000 -o %1.mp2").arg(qsMenuName);
				stringList.append(qsSound);
				qsSound = QString ("arecord -S -M -t 1 -w /dev/stdout | mp2enc -r 48000 -o \"%1.mp2\"").arg(qsMenuName);
//				qsSound = QString ("arecord -t 1 -f s16l -M -w  /dev/stdout | mp2enc -r 48000 -o \"%1.mp2\"").arg(qsMenuName);
				stringList.append(qsSound);

				qsSound = QString ("sox -t raw -s -w -c 2 -r 48000 /dev/zero -t wav -c 2 -r 48000 /dev/stdout trim 0 1 | mp2enc -r 48000 -o \"%1.mp2\"").arg(qsMenuName);
				stringList.append(qsSound);
				qsSound = QString ("dd if=/dev/zero bs=4 count=1601.6 | toolame -b128 -s 48 /dev/stdin \"%1.mp2\"").arg(qsMenuName);
				stringList.append(qsSound);
			}
			pInterface->listCommandList.append(stringList);
			pInterface->commentList.append(qsCommentSound);
			stringList.clear();
			soundList.append (QString ("%1.mp2").arg(qsMenuName));
		}
		else	{
			QString qsConvertedSound;
			for (t=0;t<pMenu->getInterface()->listSoundFiles.count();t++)	{
				qsConvertedSound = convertSoundFile (pMenu->getInterface()->listSoundFiles[t]);
				soundList.append (qsConvertedSound);
			}
		}

		QString qsCommentMpg2 (tr("<p align=\"center\">The following command will multiplex the sound file into the menu-movie.</p>"));
		QString qsGenerateMpg2 = QString ("mplex -f 8 -o \"%1.mpg\" \"%2.m2v\"").arg(qsMenuName).arg(qsMenuName);
		// Here we mplexing all sound files into the video stream ...
		for (t=0;t<soundList.count();t++)
			qsGenerateMpg2 += QString (" \"%1\" ").arg (soundList[t]);
		stringList.append(qsGenerateMpg2);
		pInterface->listCommandList.append(stringList);
		pInterface->commentList.append(qsCommentMpg2);
		stringList.clear();

		// Here we call spumux
		QString qsCommentSpumux (tr("<p align=\"center\">Here we use spumux to add the subpicture (buttons) the the mpeg2 video.</p>"));
		QString qsSpumux = QString ("spumux \"%1.xml\" < \"%2.mpg\" > \"%3_menu.mpg\"").arg(qsMenuName).arg(qsMenuName).arg(qsMenuName);
		stringList.append(qsSpumux);
		pInterface->listCommandList.append(stringList);
		pInterface->commentList.append(qsCommentSpumux);
		stringList.clear();

		listExecute.append (pInterface);
		pMenu = m_listDVDMenus[iMenuCounter++];
	}	// end of loop ...

	pInterface = new ExecuteInterface;
	pInterface->qsBlockName = QString ("dvdauthor");
	pInterface->backgroundColor = arrayColors[11];
	// And finally we call dvdauthor
	QString qsCommentDvdauthor (tr("Here we start dvdauthor with the  generated xml file."));

	QString qsDvdauthor = QString ("dvdauthor -x \"%1\"").arg(getTempFile(DVDAUTHOR_XML));	///tmp/dvdauthor.xml");
	stringList.append(qsDvdauthor);
	pInterface->listCommandList.append(stringList);
	pInterface->commentList.append(qsCommentDvdauthor);
	listExecute.append(pInterface);

	// Here we take care of the burning commands ...
	stringList.clear ();
	pInterface = new ExecuteInterface;
	pInterface->qsBlockName = QString ("Burn DVD");
	pInterface->backgroundColor = arrayColors[10];
	QString qsCommentBurn (tr("Last we burn the DVD."));
	QString qsBurn = QString ("growisofs -Z /dev/dvd -dvd-video %1/").arg(m_qsProjectPath);
	pInterface->commentList.append(qsCommentBurn);
	stringList.append(qsBurn);
	qsCommentBurn = QString(tr("This command will format a empty -RW DVD (only needed for older drives)."));
	qsBurn = QString ("dvd+rw-format -f /dev/srcd0");
	pInterface->commentList.append(qsCommentBurn);
	stringList.append(qsBurn);
	qsCommentBurn = QString(tr("This command generates an iso image of the DVD."));
	qsBurn = QString ("mkisofs -dvd-video -udf -o %1/dvd.iso %2/").arg(qsTempPath).arg(m_qsProjectPath);
	pInterface->commentList.append(qsCommentBurn);
	stringList.append(qsBurn);
	qsCommentBurn = QString(tr("This command burns the iso DVD image to DVD/"));
	qsBurn = QString ("dvdrecord -dao speed=2 dev=0,0,0 %1/dvd.iso").arg(qsTempPath);
	pInterface->commentList.append(qsCommentBurn);
	stringList.append(qsBurn);
	pInterface->listCommandList.append(stringList);
	pInterface->commentList.append(qsCommentBurn);
	pInterface->bShowBlock = false;
	listExecute.append(pInterface);

	// And finally we call the CommandQueue - Dialog.
	DialogExecute *pDialogExecute = new DialogExecute(listExecute);
	connect (pDialogExecute, SIGNAL (signalGenerateMasks()), this, SLOT (slotGenerateMasks()));
	pDialogExecute->setProjectPath(m_qsProjectPath);
	pDialogExecute->exec();
}
*/

void QDVDAuthor::slotSetup()
{
	// Calling the setup dialog.
	CSetupDialog *pDialog = new CSetupDialog (this);

	// Here we set up the data of the Setup dialog ...
	pDialog->m_pEditProjectPath->setText(m_qsProjectPath);
	pDialog->m_pEditDVDAuthorPath->setText(m_qsDVDAuthorPath);
	pDialog->m_pEditMpegToolsPath->setText(m_qsMpegToolsPath);
	pDialog->m_pEditTempPath->setText(m_qsTempPath);
	pDialog->m_pEditProjectName->setText(m_qsProjectName);

	if (pDialog->exec() == QDialog::Rejected)
		return;

/*	Here I wanted to take care of a new project sub directory under the temp dir.
	if (m_qsProjectName != pDialog->m_pEditProjectName->text())	{
		// Here the user changed the name of the project but we might have already some
		// temp data under /TmpDir/newProjectName/,
		QString qsNewTempDir = m_qsTempPath + QString ("/") + pDialog->m_pEditProjectName->text() + QString ("/");
		QDir newTempDir (qsNewTempDir);
		if (newTempDir.exists())	{
			iReturn = QMessageBox::warning ( this, QString ("Project Exists already."),
				QString ("I found an existing directory for the new ProjectName under :\n%1\n"
				"Do you want to remove all files in this directory ?").arg(qsNewTempDir),
				QMessageBox::Yes, QMessageBox::No);
			if (iReturn == QMessageBox::Yes)	{
				// remove all files in the temp dir
			}
		}
	}
	Note: We might not care since the source files are stored with  absolute path names
*/
	m_qsProjectPath 	= pDialog->m_pEditProjectPath->text();
	m_qsDVDAuthorPath	= pDialog->m_pEditDVDAuthorPath->text();
	m_qsMpegToolsPath	= pDialog->m_pEditMpegToolsPath->text();
	m_qsTempPath		= pDialog->m_pEditTempPath->text();
	m_qsProjectName		= pDialog->m_pEditProjectName->text();
}

void QDVDAuthor::fileNew()
{
	cleanUp();
}

bool QDVDAuthor::cleanUp()
{
	// here we close all Menus, unload the SourceFileEntries and re-set all other variables
	uint t;
	int iReturn;
	// First we should check back if that is what the user wants ...
//	iReturn = QMessageBox::warning ( this, QString ("Closing current Session."),
//		QString ("This will close the current Project.\nAre you sure ?"),
//		QMessageBox::Yes, QMessageBox::No);
//	if (iReturn == QMessageBox::No)
//		return false;
	if ( (m_pVMGMenu->getInterface()->bModified) || (m_bModified) )	{
		// Now we see if there is something to loose which might be worth saving ...
		iReturn = QMessageBox::warning ( this, tr ("File not saved"),
			tr ("The current modifications have not been save to the file. \nDo you want to save the project now ?"),
			QMessageBox::Yes, QMessageBox::No, QMessageBox::Cancel);
		if (iReturn == QMessageBox::Yes)
			fileSave ();
		else if (iReturn == QMessageBox::Cancel)
			return false;
	}

	// Okay let us start with deleting the SubMenus ...
	for (t=0;t<m_listDVDMenus.count();t++)
		delete m_listDVDMenus[t];
	m_listDVDMenus.clear();
	
	// Here we delete the Main VMGM - menu ...
	delete m_pVMGMenu;
	m_pVMGMenu = NULL;
	VMGMenu *pVMGMenu = new VMGMenu (this);
	addDVDMenu(pVMGMenu, true);

	// Next on the list are the SourceFileEntries ...
	m_pSourceToolbar->clear();
	
	// And finally re-set the variables ...
	m_qsProjectFileName = QString ( PROJECT_FILENAME );
	m_bModified = false;
	m_qsProjectPath = QString ("");
	m_qsCurrentPath = QString ("./");
	return true;
}

void QDVDAuthor::fileOpen ()
{
	// This function reads in a project file.
	bool bError = false;
	if (!cleanUp())
		return;
	// Now let the user pick a new project to open.
	QString qsProjectFileName = QFileDialog::getOpenFileName(m_qsCurrentPath, tr("Project Files (*.xml *.XML)"), this, tr("Open Project file dialog"), tr ("Open Project File"));
	// Sanity check .. Did te user choose a new project file ?
	if (qsProjectFileName.isNull ())
		return;

	QFileInfo fileInfo  (qsProjectFileName);
	QString qsPath = fileInfo.dirPath ( TRUE );
	setCurrentPath( qsPath );

	// Assign the file
	QFile projectFile(qsProjectFileName);
	if (!projectFile.open(IO_Raw | IO_ReadWrite))
		return;
	// Try to get the right xml contents ...
	QDomDocument xmlDoc( XML_DOCTYPE );
	if (!xmlDoc.setContent (&projectFile))	{
		// Error handling ...
		projectFile.close();
		int iReturn = QMessageBox::warning ( this, tr ("xml project file seems to be defective."),
			tr ("Do you want to try to load another project file ?"),
			QMessageBox::Yes, QMessageBox::No);
		if (iReturn == QMessageBox::Yes)
			fileOpen ();	// Okay, user wants to specify another project file.
		return;
	}

	// Here is the main loop to extract the info ...
	QDomElement docElem = xmlDoc.documentElement();
	QDomNode xmlNode = docElem.firstChild();
	// First we take care of the QDVDAuthor variables ...
	while( !xmlNode.isNull() ) {
		QDomElement searchXMLTree = xmlNode.toElement();
		if (DVDAUTHOR == searchXMLTree.tagName () )	{
			bError = !readProjectFile (searchXMLTree);
		}
		else if (DVDAUTHOR_ROOT_VMGM == searchXMLTree.tagName () )	{
			m_pVMGMenu->readProjectFile(searchXMLTree);
			m_pVMGMenu->updateDVDMenu();
		}
		else if (DVDAUTHOR_ROOT_MENU == searchXMLTree.tagName () )	{
			DVDMenu *pDVDMenu = new DVDMenu(this);
			addDVDMenu(pDVDMenu);
			pDVDMenu->readProjectFile(searchXMLTree);
			pDVDMenu->updateDVDMenu();
		}
		else
			printf ("Warning: QDVDAuthor::fileOpen -=> wrong XML Node <%s>\nContinuing ...\n",
					(const char *)searchXMLTree.tagName());

		if (bError)
			break;
		// Go to the next node ...
		xmlNode = xmlNode.nextSibling();
	}
	projectFile.close();
	if (bError)	{
		QMessageBox::warning ( this, tr ("Error occured reading project file."),
			tr ("An unknow error occured when trying to read teh project xml file."),
			QMessageBox::Ok, QMessageBox::NoButton);
		return;
	}
	// Setting of the variables ...
	m_bModified = false;
	m_qsProjectFileName = qsProjectFileName;
	DVDMenu *pMenu = getCurrentSubMenu ();
	if (pMenu)
		m_pColorToolbar->setDVDMenu (pMenu);
}

bool QDVDAuthor::readProjectFile (QDomNode &xmlNode)
{
	QString qsVersionNumber;
	
	QDomElement theElement = xmlNode.parentNode().toElement();
	QDomAttr attribute;

	attribute = theElement.attributeNode ( THE_PROJECT_NAME );
	if (!attribute.isNull())
		m_qsProjectName = attribute.value();

	// Here we get the DVDAuthor Nodes ...
	QDomNode xmlDVDAuthor = xmlNode.firstChild();
	while ( !xmlDVDAuthor.isNull () )	{
		// Okay, here we retain the stored data from the xml file.
		theElement = xmlDVDAuthor.toElement();
		QString tagName = theElement.tagName();
		QString nodeText = theElement.text ();
		// Okay, this is ugly but after all it is the simplest of all xml file structure.
		// No need to get fancy ...
		if (tagName == QDVDAUTHOR_VERSION)
			qsVersionNumber = nodeText;
		else if (tagName == DVDAUTHOR_PATH)
			m_qsDVDAuthorPath = nodeText;
		else if (tagName == DVDAUTHOR_TEMP_PATH)
			m_qsTempPath = nodeText;
		else if (tagName == DVDAUTHOR_PROJECT_PATH)
			m_qsProjectPath = nodeText;
		else if (tagName == DVDAUTHOR_CURRENT_PATH)
			m_qsCurrentPath = nodeText;
		else if (tagName == DVDAUTHOR_MPEG_TOOLS_PATH)
			m_qsMpegToolsPath = nodeText;
		else if (tagName == SOURCE_OBJECT)	{
			SourceFileEntry *pNewEntry = new SourceFileEntry;
			pNewEntry->readProjectFile(xmlDVDAuthor);
			m_pSourceToolbar->appendSourceFileEntry(pNewEntry);
		}
		else
			printf ("Warning: QDVDAuthor::readProjectFile -=> wrong XML Node <%s>\nContinuing ...\n",
					(const char *)tagName);
		// So lets get the next sibling ... until we hit hte end of DVDMenu ...
		xmlDVDAuthor = xmlDVDAuthor.nextSibling();
	}
	return true;
}

bool QDVDAuthor::writeProjectFile(QDomElement &rootElement)
{
	QDomDocument xmlDoc = rootElement.ownerDocument();
	
	if (!m_qsProjectName.isNull())
		rootElement.setAttribute( THE_PROJECT_NAME,   m_qsProjectName );

	QDomElement rootDVDAuthor = xmlDoc.createElement( DVDAUTHOR );
	rootElement.appendChild ( rootDVDAuthor );
	// Okay, the main Node is created, now all DVDAuthor related information belon under it.
		QDomElement tag = xmlDoc.createElement( QDVDAUTHOR_VERSION );
		rootDVDAuthor.appendChild ( tag );
		QDomText text = xmlDoc.createTextNode ( QDVDAUTHOR_VERSION_NUMBER );
		tag.appendChild ( text );

		tag = xmlDoc.createElement   ( DVDAUTHOR_CURRENT_PATH );
		rootDVDAuthor.appendChild    ( tag );
		text = xmlDoc.createTextNode ( m_qsCurrentPath );
		tag.appendChild ( text );

		tag = xmlDoc.createElement   ( DVDAUTHOR_PATH );
		rootDVDAuthor.appendChild    ( tag );
		text = xmlDoc.createTextNode ( m_qsDVDAuthorPath );
		tag.appendChild ( text );

		tag = xmlDoc.createElement   ( DVDAUTHOR_TEMP_PATH );
		rootDVDAuthor.appendChild    ( tag );
		text = xmlDoc.createTextNode ( m_qsTempPath );
		tag.appendChild ( text );

		tag = xmlDoc.createElement   ( DVDAUTHOR_PROJECT_PATH );
		rootDVDAuthor.appendChild    ( tag );
		text = xmlDoc.createTextNode ( m_qsProjectPath );
		tag.appendChild ( text );

		tag = xmlDoc.createElement   ( DVDAUTHOR_MPEG_TOOLS_PATH );
		rootDVDAuthor.appendChild    ( tag );
		text = xmlDoc.createTextNode ( m_qsMpegToolsPath );
		tag.appendChild ( text );
	// Here we write the SourceFileEntry - records ...
	int t;
	for (t=0;t<m_pSourceToolbar->sourceFileCount();t++)	
		m_pSourceToolbar->sourceFileEntry(t)->writeProjectFile (rootDVDAuthor);
		
	return true;
}

void QDVDAuthor::fileSave()
{
	uint t;
	if (m_qsProjectFileName == QString (PROJECT_FILENAME))
		return fileSaveAs();	
	QFile projectFile(m_qsProjectFileName);
	if (!projectFile.open(IO_WriteOnly))
		return;

	QDomDocument xmlDoc( XML_DOCTYPE );
	QDomElement mainElement = xmlDoc.createElement( DVD_PROJECT );
	xmlDoc.appendChild( mainElement );
	// First we store the data from the QDVDAuthor - class
	writeProjectFile  (mainElement);

	// next in line is the VMGMenu - class
	m_pVMGMenu->writeProjectFile (mainElement);

	// And lastly we store the infos in all SubMenus ...
	for (t=0;t<m_listDVDMenus.count();t++)
		m_listDVDMenus[t]->writeProjectFile(mainElement);

	QString xml = xmlDoc.toString();
//	printf ("%s\n", (const char *)xml);
	projectFile.writeBlock(xml, qstrlen (xml));

	projectFile.close();
	m_bModified = false;
	return;
}

void QDVDAuthor::fileSaveAs()
{
	QString qsProjectFileName = QFileDialog::getSaveFileName(m_qsCurrentPath, tr ("Project Files (*.xml)"), this, tr("Save file dialog"), tr("Save File As ..."));
	if (qsProjectFileName.isNull ())
		return;

	QFileInfo fileInfo(qsProjectFileName);
	QString qsPath = fileInfo.dirPath ( TRUE );
	setCurrentPath( qsPath );
	// Here we check if the user wants to use unnamed.xml -the default-
	// In this case we change the name slightly, so we have a clue it has bee initialized.
	if (fileInfo.fileName() == QString (PROJECT_FILENAME))
		qsProjectFileName = fileInfo.filePath() + QString ("unnamed.xml");

	m_qsProjectFileName = qsProjectFileName;
	m_bModified = true;
//	m_bProjectNameInitialized = true;
	fileInfo = QFileInfo(qsProjectFileName);
	if (fileInfo.extension(FALSE).isEmpty())	// Indication there is no extension ...
		m_qsProjectFileName += QString (".xml");

	fileSave();
}

QString QDVDAuthor::getImageFilter ()
{
	return QString("*.jpg *.jpeg *.png *.xbm *.bmp *.JPG *.JPEG *.PNG *.XBM *.BMP");
}

QString QDVDAuthor::getMovieFilter ()
{
	return QString ("*.mpg *.mpeg *.avi *.mwa *.mov *.wma *.vob *.dv *.wmv *.mjpeg *.mve *.asf *.asx *.MPG *.MPEG *.AVI *.MWA *.MOV *.WMA *.VOB *.DV *.WMV *.MJPEG *.MVE *.ASF *.ASX");
}

QString QDVDAuthor::getSoundFilter ()
{
	return QString("*.wav *.mp3 *.mp2 *.mpa *.mpega *.ogg *.WAV *.MP3 *.MP2 *.MPA *.MPEGA *.OGG");
}
