/****************************************************************************
** DialogChapters class
**
** Created: Fri Jun 18 22:48:00 2004
**      by: Varol Okan using Kate
**
****************************************************************************/

#include <qfileinfo.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

#include "dialogchapters.h"


DialogChapters::DialogChapters(QWidget * parent, const char * name, WFlags f)
	: uiDialogChapters (parent, name, f)
{
}

DialogChapters::~DialogChapters ()
{
}

void DialogChapters::initMe(SourceFileInfo *pInfo)
{
	if (!pInfo)
		return;
	int iLength = pInfo->getMsFromString(pInfo->qsLength);
	// Check if the default 5 minutes chapter creation is out of range anyways ...
	QString qsReturn = pInfo->getStringFromMs (iLength);
	if (iLength < 5*60*1000)	{
		m_pEditEvery->setText (QString ("%1").arg((int)(iLength/1000)));
		m_pEditAdd->setText (qsReturn);
	}
	m_pEditEnding->setText(qsReturn);
	// Here we copy the infos over ...
	m_sourceFileInfo = *pInfo;
	QFileInfo fileInfo(m_sourceFileInfo.qsFileName);

	// and now on to initializing the dialog. Length : 00:07:23.123 File : Cool Video.mpg
	m_pTextTitle->setText (tr ("Length : <%1> File : %2").arg(qsReturn).arg(fileInfo.fileName()));

	m_pListBoxChapters->clear ();
	if (m_sourceFileInfo.listChapters.count() == 0)
		m_pListBoxChapters->insertItem (QString ("00:00:00.000"));
	m_pListBoxChapters->insertStringList (m_sourceFileInfo.listChapters);

	m_pButtonPreview->setEnabled (false);
	// And finally here are the callback functions ...
	connect (m_pButtonAdd,       SIGNAL(clicked ()), this, SLOT (slotAddChapter()));
	connect (m_pButtonDel,       SIGNAL(clicked ()), this, SLOT (slotDelChapters()));
	connect (m_pButtonAuto,      SIGNAL(clicked ()), this, SLOT (slotAutoChapters()));
	connect (m_pButtonPreview,   SIGNAL(clicked ()), this, SLOT (slotPreview()));
	connect (m_pListBoxChapters, SIGNAL(highlighted (int)), this, SLOT (slotHighlighted(int)));
}

SourceFileInfo *DialogChapters::getSourceFileInfo ()
{
	return &m_sourceFileInfo;
}

void DialogChapters::slotAutoChapters ()
{
	uint t, i, iDeltaStep, iStarting, iEnding, iChapter, iPreviousChapter;
	int iTotalLength, iNumberOfNewChapters;
	QString qsTimeString;
	// Here we read in the list of currently generated chapters
	// then we convert them into milliseconds, and store them in an array
	// And finally we generate the chapters, sort the array and put it back into the
	// m_pListBoxChapters, and m_sourceFileInfo - structures.
	uint *pArrayExistingChapters = new uint[m_pListBoxChapters->count()];
	for (t=0;t<m_pListBoxChapters->count(); t++)	{
		qsTimeString = m_pListBoxChapters->text(t);
		pArrayExistingChapters[t] = m_sourceFileInfo.getMsFromString (qsTimeString);
	}
	iStarting  = m_sourceFileInfo.getMsFromString (m_pEditStarting->text());
	iEnding    = m_sourceFileInfo.getMsFromString (m_pEditEnding->text());
	iDeltaStep = m_sourceFileInfo.getMsFromString (m_pEditEvery->text());
	iTotalLength = (int)(iEnding - iStarting);
	// a DeltaStep of 0 woudl generate infinite number of chapters
	if (iDeltaStep < 1)
		return;
	if (iDeltaStep > (uint) iTotalLength)
		iDeltaStep = iTotalLength;
	iNumberOfNewChapters = (int)((float)iTotalLength / (float)iDeltaStep) + 1;

	QValueList<int> listAllChapters;
	// Okay this is the worst sort algo around but we would'nt sort thousands of chapters, now would we ???
	i = 0;
	for (t=0;t<(uint)iNumberOfNewChapters;t++)	{
		iChapter = t*iDeltaStep;
		for (i=0;i<m_pListBoxChapters->count();i++)	{
			// If we find an entry which is the same as a calculated chapter we should skip it ...
			if (pArrayExistingChapters[i] == iChapter)
				pArrayExistingChapters[i] = 0;
			// If we find an entry which is smaller but not 0, then we should include them ...
			else if ( (pArrayExistingChapters[i] < iChapter) && (pArrayExistingChapters[i] > 0) )	{
				listAllChapters.append (pArrayExistingChapters[i]);
				// Here we ensure the next time this entry is higher
				pArrayExistingChapters[i] = 0;
			}
		}
		listAllChapters.append (iChapter);
	}

	m_pListBoxChapters->clear ();
	iChapter = iPreviousChapter = 0;
	for (t=0;t<listAllChapters.count();t++)	{
		iChapter = listAllChapters[t];
		if (iChapter >= iPreviousChapter)
			m_pListBoxChapters->insertItem(m_sourceFileInfo.getStringFromMs (iChapter));
		iPreviousChapter = iChapter;
	}

	delete []pArrayExistingChapters;
}

void DialogChapters::slotAddChapter ()
{
	// Here we add a chapter in the right space,
	// but only if this chapter does not already exists ...
	int iChapter, iAddChapter;
	uint t;
	iChapter = 0;
	iAddChapter = m_sourceFileInfo.getMsFromString (m_pEditAdd->text());
	for (t=0;t<m_pListBoxChapters->count();t++)	{
		iChapter = m_sourceFileInfo.getMsFromString (m_pListBoxChapters->text(t));
		if (iAddChapter == iChapter)
			break;
		else if (iAddChapter < iChapter)	{
			m_pListBoxChapters->insertItem (m_sourceFileInfo.getStringFromMs (iAddChapter), t);
			break;
		}
	}
	// and in case the Chpater is to be added at the end ...
	if (iAddChapter > iChapter)
		m_pListBoxChapters->insertItem (m_sourceFileInfo.getStringFromMs (iAddChapter));
}

void DialogChapters::slotDelChapters ()
{
	// This function will remove all chapters which are currently selected in m_pListBoxChapters
	uint t;
	QValueList<QListBoxItem *> listItems;
	for (t=0;t<m_pListBoxChapters->count();t++)	{
		if (m_pListBoxChapters->isSelected (t))
			listItems.append (m_pListBoxChapters->item(t));
	}
	for (t=0;t<listItems.count();t++)
			delete listItems[t];
}

void DialogChapters::slotHighlighted (int)
{
	// Here we re-set the m_pButtonPreview text, and status
	m_pButtonPreview->setText (tr("Preview"));
	uint t, iCount;
	iCount = 0;
	for (t=0;t<m_pListBoxChapters->count();t++)	{
		if (m_pListBoxChapters->isSelected (t))
			iCount ++;
	}
	if ( (iCount > 1) || (iCount == 0) )
		m_pButtonPreview->setEnabled (false);
	else
		m_pButtonPreview->setEnabled (true);
}

void DialogChapters::slotPreview ()
{
	if (m_pButtonPreview->text() == tr ("Preview"))
		preview ();
	else if (m_pButtonPreview->text() == tr ("Play"))
		play ();
	else if (m_pButtonPreview->text() == tr ("Pause"))
		pause ();
}

void DialogChapters::preview ()
{
	// Here we will preview the chapter but only if
	// a)	there is only one chapter selected and
	// b)	the stream is seekable
	uint t, iCount;
	iCount = 0;
	for (t=0;t<m_pListBoxChapters->count();t++)	{
		if (m_pListBoxChapters->isSelected (t))
			iCount ++;
	}
	if (iCount == 0)	{
		QMessageBox::information (this, tr("Error."), tr ("Please select at one chapter to preview."), QMessageBox::Ok);
		return;
	}
	else if (iCount > 1)	{
		QMessageBox::information (this, tr("Error."), tr ("Please select only one chapter to preview."), QMessageBox::Ok);
		return;
	}
//	if (!m_pXineEngine->isSeekeable ())	{
//		QMessageBox::information (this, QString("Warning."), QString ("This stream is not seekeable.\nNo Preview is possible"), QMessageBox::Ok);
//		return;
//	}


	// m_pXineEngine->stop(m_pXineStream);

	// m_pXineEngine->seek(iPosition);

	// m_pXineEngine->getScreenShot();

	m_pButtonPreview->setText (tr("Play"));
}
void DialogChapters::play ()
{
	// m_pXineEngine->play(m_pXineStream);
	m_pButtonPreview->setText (tr("Pause"));
}

void DialogChapters::pause ()
{
	// m_pXineEngine->pause(m_pXineStream);
	m_pButtonPreview->setText (tr("Play"));
}

void DialogChapters::accept ()
{
	// Here we set the chapters to the SourceFileInfo ...
	uint t;
	m_sourceFileInfo.listChapters.clear ();

	for (t=0;t<m_pListBoxChapters->count ();t++)
		m_sourceFileInfo.listChapters.append(m_pListBoxChapters->text (t));
	QDialog::accept();
}








