/****************************************************************************
**
** Created: Sun Apr 11 22:06:50 2004
**      by: Varol Okan using the kate text editor.
**
**
****************************************************************************/

#ifndef QXINE_H
#define QXINE_H

#include "uiqxine.h"
#include <qstringlist.h>

class QXineWidget;
class QGridLayout;
class QToolBar;
class QComboBox;

class QXine : public uiQXine
{
    Q_OBJECT

public:
	// list the states of the xine engine.
	enum {	STATE_STOPPED=0,
		STATE_PLAYING,
		STATE_PAUSED,
		STATE_UNKNOWN};
	// Constructor / destructor.
	 QXine (QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	virtual ~QXine ();

	void setFileName (QString, bool b=true);

private:
	void colorMovieButtons (void *);
	void loadHistory ();
	void saveHistory ();
	void addFileToHistory(QString);
	void getImage(uint i=0 );

protected slots:
	// Here are the standard slots which are implemented in QXine
	virtual void fileOpen();
	virtual void fileOpenRecent();
	virtual void fileExit();
	virtual void helpAbout();
	virtual void slotSetup();

	virtual void slotPrev ();
	virtual void slotNext ();
	virtual void slotStop ();
	virtual void slotPlay ();
	virtual void slotSpeedPlus    ();
	virtual void slotSpeedMinus   ();
	virtual void slotSeekPosition ();
	virtual void slotSetVolume    (int);
	virtual void slotScreenshot   ();
	
	virtual void slotHistory(int);
	virtual void slotNewPosition(int, const QString&);
	virtual void slotPlaybackFinished ();
	
protected:
	QXineWidget *m_pXineWidget;
	QToolBar    *m_pToolBarPrevious;
	QComboBox   *m_pComboPrevious;
	QGridLayout *m_pVideoLayout;
	QString      m_qsFileName;
	int          m_iSpeed;
	QStringList  m_listHistory;
	int          m_iIsPlaying;
	QString      m_qsCurrentVideoPlugin;
	QString      m_qsCurrentAudioPlugin;
};

#endif // QXINE_H
