/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <qfiledialog.h>
#include <qpixmap.h>
#include <qimage.h> 

#include "kimageeffect.h"
#include "quantize.h"

void MyDialog::slotDither()
{
	// First open the file 
	QString s = QFileDialog::getOpenFileName("./", "Images (*.png *.xpm *.jpg)", this,
                    "open file dialog", "Choose a file to open" );
	if (s.isEmpty())
		return;
		
	QImage theImage (s);
 
	//static QImage& dither(QImage &image, const QColor *palette, int size);
	uint iSize;
	iSize = 4;
	
	QColor *pPalette = new QColor[5];
	pPalette[0] = QColor (255, 255, 255);
//	pPalette[0] = QColor (  0,   0,   0);
	
	pPalette[1] = QColor (255,   0,   0);
	pPalette[2] = QColor (  0, 255,   0);
	pPalette[3] = QColor (  0,   0, 255);
	pPalette[4] = QColor (  0,   0,   0);
	
	CQuantizer quantize (8, 4);
	bool bReturn = quantize.ProcessImage (theImage);
	uint iColors = quantize.GetColorCount();
printf ("MyDialog::slotDither  bRet=<%d>  NumColors=<%d> \n", bReturn, iColors);
	QColor *pPal = new QColor [iColors];
	quantize.SetColorTable(pPal);

//	KImageEffect::normalize (theImage);
//	theImage = KImageEffect::dither (theImage, pPalette, 20);
	theImage = KImageEffect::dither (theImage, pPal, iColors);
//	theImage = KImageEffect::dither (theImage, NULL, iSize);
//	theImage = KImageEffect::flatten (theImage, pPalette[1], pPalette[0], iSize);
//	theImage = KImageEffect::flatten (theImage, QColor (0,0,0), QColor (255,255,255), iSize);
	
	QPixmap thePixmap;
	thePixmap.convertFromImage(theImage);

	labelPixmap->setPixmap(thePixmap);
}
