/****************************************************************************
** Interface to the GUI.
**
** Created: Sun Feb 23 21:45:00 2004
**      by: Varol Okan using kate editor
**
**  pure virtual class as base for the three button types.
**
****************************************************************************/

#ifndef OBJECTCOLLECTION_H
#define OBJECTCOLLECTION_H

#include <qpixmap.h>
#include "menuobject.h"

class MenuPreview;

class ObjectCollection : public MenuObject
{
	Q_OBJECT
public:
	// Public functions needed for the abstract base class.
	ObjectCollection (QWidget *pParent = 0);
	virtual ~ObjectCollection();
	virtual void drawContents          (QPainter *);
	virtual void drawContents          (QPainter *, int, int);
	virtual bool mouseMoveEvent        (QMouseEvent *);
	virtual bool mousePressEvent       (QMouseEvent *);
	virtual bool mouseReleaseEvent     (QMouseEvent *);
	virtual bool mouseDoubleClickEvent (QMouseEvent *);

	virtual bool readProjectFile       (QDomNode &);
	virtual bool writeProjectFile      (QDomElement &);
	virtual void createStructure       (QListViewItem *);
	virtual bool createContextMenu     (QPoint);

public:
	int         getCount               ();
	MenuObject *getObject              (int);

	bool readObjects                   (QDomNode &, MenuPreview *);
	void deleteAllObjects              (bool);
	void append                        (MenuObject *, bool b=true);
	

signals:
	void signalDefineAsButton          (MenuObject *);
	void signalDeleteMe                (MenuObject *);
//	void signalModifyMe                (MenuObject *);

protected slots:
	virtual void slotEdit              ();
	virtual void slotDelete            ();
	virtual void slotAddFrame          ();
	virtual void slotAddText           ();
	virtual void slotAddImage          ();
	virtual void slotAddMovie          ();
	virtual void slotDefineAsButton    ();

protected:
	virtual AnimationAttribute *getSpecificAttributes (long, QString);

private:
	QValueList<MenuObject *> m_listObjectCollection;
	QValueList<bool>         m_listDeleteThisObject;
	bool m_bDeleteAllObjects;
};

#endif	// OBJECTCOLLECTION_H

