unix {
  UI_DIR = ../.ui
  MOC_DIR = ../.moc
  OBJECTS_DIR = ../.obj
}


# Now we parse the env varaible IMAGE_LIB (set in the configurator GUI)
HAS_PLAYER_SUPPORT = false
HAS_MPLAYER_SUPPORT = $$(WITH_MPLAYER_SUPPORT)
HAS_XINE_SUPPORT = $$(WITH_XINE_SUPPORT)
HAS_VLC_SUPPORT = $$(WITH_VLC_SUPPORT)


# Here we check if MEDIA_CONFIG.h exists already OR qmake is called from configurator
# in which case we don't need to re-create the MEDIA_CONFIG.h - file again because it
# has been created by qdvdauthor.pro
WHICH_IMAGES = $$(QMAKE_IMAGES)

CREATE_MEDIA_CONFIG = 0
!exists (MEDIA_CONFIG.h) { 
	CREATE_MEDIA_CONFIG = 1
}
isEmpty (WHICH_IMAGES)   { 
	CREATE_MEDIA_CONFIG = 1
}

# So the question is if we should create the MEDIA_CONFIG.h - file ?
contains (CREATE_MEDIA_CONFIG, 1)	{
system (echo -e "\043ifndef MEDIA_CONFIG_H" | sed s/-e\ // > MEDIA_CONFIG.h )
system (echo -e "\043define MEDIA_CONFIG_H" | sed s/-e\ // >> MEDIA_CONFIG.h )
contains ( HAS_MPLAYER_SUPPORT, 1 ) { 
	system (echo -e "\043define MPLAYER_SUPPORT $$(WITH_MPLAYER_SUPPORT)" | sed s/-e\ // >> MEDIA_CONFIG.h ) 
}
contains ( HAS_XINE_SUPPORT, 1 )    { 
	system (echo -e "\043define XINE_SUPPORT  $$(WITH_XINE_SUPPORT)" | sed s/-e\ // >> MEDIA_CONFIG.h ) 
}
contains ( HAS_VLC_SUPPORT, 1 )     { 
	system (echo -e "\043define VLC_SUPPORT  $$(WITH_VLC_SUPPORT)" | sed s/-e\ // >> MEDIA_CONFIG.h ) 
}
system (echo -e "\043endif // MEDIA_CONFIG_H" | sed s/-e\ // >> MEDIA_CONFIG.h )
}

DISTFILES	= README

SOURCES	+=	qplayer.cpp    \
		mediainfo.cpp   \
		qplayer_main.cpp \
		mediascanner.cpp  \
		mediacreator.cpp   \
		sourcefiledialog.cpp\
		startstopcontrol.cpp \
		listviewfileitem.cpp  \
		../log.cpp             \
		../utils.cpp            \
		../global.cpp            \
#		../dialogmovie.cpp        \
		../sourcefileentry.cpp     \
		engines/dummywidget.cpp     \
		engines/mediainterface.cpp

HEADERS +=	MEDIA_CONFIG.h\
		qplayer.h   \
		mediainfo.h  \
		xml_qplayer.h \
		mediascanner.h \
		mediacreator.h  \
		qplayer_global.h \
		sourcefiledialog.h\
		startstopcontrol.h \
		listviewfileitem.h  \
		../log.h             \
		../utils.h            \
		../global.h            \
#		../dialogmovie.h        \
		../sourcefileentry.h     \
		engines/dummywidget.h     \
		engines/mediainterface.h

LIB_EXTRA=
# Next we take care of the media backend dependencies
contains ( HAS_XINE_SUPPORT, 1 )	{
	HAS_PLAYER_SUPPORT=true
	message ("Build with Xine Support")
	LIB_EXTRA += xine-config --cflags --libs 
	SOURCES	+=	engines/xineinfo.cpp \
			engines/xinewidget.cpp\
			engines/kxinewidget.cpp\
			engines/qxinewidget.cpp \
			engines/kaffeineswidget.cpp
	HEADERS	+=	engines/xineinfo.h \
			engines/xinewidget.h\
			engines/kxinewidget.h\
			engines/qxinewidget.h \
			engines/kaffeineswidget.h
	FORMS +=	engines/dialogqxinesetup.ui
}
contains( HAS_VLC_SUPPORT, 1) {
	HAS_PLAYER_SUPPORT=true
	message ("Build with VLC support")
	! isEmpty (LIB_EXTRA)	{
		LIB_EXTRA += &&
	}
	LIB_EXTRA += vlc-config --cxxflags --libs
	LIBS +=-L/usr/local/lib/vlc -lvlc -ldl -lavcodec -lavformat -lvlc -lmemcpymmx -li420_rgb_mmx -li422_yuy2_mmx -li420_ymga_mmx -li420_yuy2_mmx -lmemcpymmxext -lmemcpy3dn -lffmpeg -lstream_out_switcher -lpthread -lxvideo -lX11 -lXaw -lXv -lXinerama
	SOURCES	+=	engines/vlcinfo.cpp \
			engines/vlcwidget.cpp \
			engines/qvlcwidget.cpp
	HEADERS	+=	engines/vlcinfo.h \
			engines/vlcwidget.h \
			engines/qvlcwidget.h
}
contains( HAS_MPLAYER_SUPPORT, 1) {
	HAS_PLAYER_SUPPORT=true
	message ("Build with MPlayer support")
	# Note : mplayer has no library. Thus we don't need to add dependencies here.
	SOURCES +=	engines/qmplayerwidget.cpp \
			engines/mplayerinfo.cpp  \
			engines/mplayerwidget.cpp \
			engines/dialogmplayersetup.cpp
	HEADERS +=	engines/xml_mplayer.h \
			engines/mplayerinfo.h \
			engines/mplayerwidget.h\
			engines/qmplayerwidget.h\
			engines/dialogmplayersetup.h
	FORMS   +=	engines/uidialogmplayersetup.ui
}
#Finally we check if at least one player engine has been enabled
contains( HAS_PLAYER_SUPPORT, false )	{
	message("You need to at least specify one media player engine. I will default to MPlayer (non-lib based)")
	SOURCES +=	engines/qmplayerwidget.cpp \
			engines/mplayerinfo.cpp \
			engines/mplayerwidget.cpp\
			engines/dialogmplayersetup.cpp
	HEADERS +=	engines/xml_mplayer.h \
			engines/mplayerinfo.h \
			engines/mplayerwidget.h\
			engines/qmplayerwidget.h \
			engines/dialogmplayersetup.h
	FORMS   +=	engines/uidialogmplayersetup.ui
}
# Add the ending quote.
LIBS += `$${LIB_EXTRA}`

# Here we check if the environmane variable QMAKE_IMAGES is set
# If not then we generate qmake_image_collection.o
# This is needed because qdvdauthor is building qplayer as well and the qplayer qmake_image_collection 
# would overwrite the qmake_image_collection from qdvdauthor.
# Note: we also create all qplayer images in qdvdauthor but since qplayer is an external Program
#       we want to keep it seperate from qdvdauthor.pro itself.
#isEmpty(WHICH_IMAGES) {
exists(../.obj/qmake_image_collection.o) {
IMAGES	= images/desktop.png images/documents.png images/home.png images/project.png \
	  images/root.png images/babytux.png images/play.png \
	  images/pause.png images/temp.png
}
# in order to also link against qmake_image_collection.o we need at least one image. So this one is a dummy ...
IMAGES += images/faster.png

FORMS	+= uiqplayer.ui   \
	../uidialogmovie.ui\
	dialogconfigure.ui  \
	uisourcefiledialog.ui\
	uistartstopcontrol.ui \
	dialogaboutqplayer.ui

WHICH_PREFIX = $$(PREFIX)
isEmpty(WHICH_PREFIX) {
	WHICH_PREFIX =/usr
}

# Here we handle the language file generation
!exists (../i18n/qplayer_de.qm)	{
	LRELEASE=$$(QTDIR)/bin/lrelease
	!exists ( $${LRELEASE} ) {
		LRELEASE=lrelease
	}
	system (  $${LRELEASE} qplayer.pro )
}

prefix.path = $${WHICH_PREFIX}/bin
prefix.files = ../../bin/qplayer

i18n.path = $${WHICH_PREFIX}/share/qdvdauthor
i18n.files = ../i18n/qplayer_*.qm
#i18n.extra = $${LRELEASE} qplayer.pro

TRANSLATIONS    = ../i18n/qplayer_de.ts \
                  ../i18n/qplayer_fr.ts \
                  ../i18n/qplayer_es.ts 

WHICH_DEBUG = $$(DEBUG_QDVDAUTHOR)
# here we set the default type ...
isEmpty(WHICH_DEBUG)	{
	WHICH_DEBUG=release
}

RC_FILE                 =qplayer.rc
RES_FILE                =qplayer.res
LIBS                   +=$$(LDFLAGS)
INSTALLS                = prefix i18n
RES_FILE                =qxine_resources.cpp
TEMPLATE                =app
DESTDIR                 =../../bin
CONFIG	               += thread warn_on $${WHICH_DEBUG}
QMAKE_CXXFLAGS_WARN_ON += -Wno-non-virtual-dtor
LANGUAGE                = C++
