/****************************************************************************
** FilterLine class
**
** Created: Tue Feb 02 22:06:51 2004
**      by: Varol Okan using Kate
**
****************************************************************************/

#include <qslider.h>

#include "slidertime.h"

SliderTime::SliderTime (QWidget * parent, const char * name)
	: QSlider (parent, name)
{
}

SliderTime::~SliderTime()
{

}

void SliderTime::mousePressEvent (QMouseEvent *pEvent)
{
	// and finally we'll handle the nominal usage of mousePressEvent
	QSlider::mousePressEvent(pEvent);
	
	// This is the only function I want to differ in that the 
	// user clicks on any part of the slider bar and the cursor 
	// get automagically to the clicked position.
	int iSliderPos = 0;
	// first we get the range
	int iRange = maxValue()-minValue();
	// Then we get the pixel length of this slider control.
	int iWidth = width();
	float fSliderPos = (float)iRange / iWidth * pEvent->pos().x();
	iSliderPos = (int)fSliderPos;
	iSliderPos += minValue();
	setValue (iSliderPos);
	emit (sliderMoved (iSliderPos));
}


