/****************************************************************************
** DialogAnimation class
**
** Created: Mon Jun 10 22:48:00 2005
**      by: Varol Okan using Kate
**
**
****************************************************************************/

#include <qmessagebox.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qslider.h>

#include "dvdmenu.h"
#include "dialoganimation.h"

DialogAnimation::DialogAnimation (QWidget *pParent, const char *pName, WFlags f )
	: uiDialogAnimation (pParent, pName, f)
{
}

DialogAnimation::~DialogAnimation ()
{
	// The Dialog takes care of the destruction of the generated tabs,
	// so we won't have to do it manually here
}

void DialogAnimation::initMe ( QString qsAnimation, long iFrames, float fFPS, int iType )
{
	char *standardProperties[] = {"rect", "visibleFromTo", "transparency", "rotate", "zoom", "scale", "shear"}; // index 0-14
	char *frameProperties [] = {"color", "frameWidth", "frameStyle", "frameJoin"}; // index 15-26
	//	char *imageProperties [] = {"backgroundFileName", "showBackground", "startPos", "res", "aspectRatio", "blendColor", "brightness" }; // index 15-26
	char *imageProperties [] = {"backgroundFileName", "showBackground", "startPos", "pos", "blendColor", "brightness" }; // index 15-24
	char *movieProperties [] = {"frameNo"}; // index 26
	char *textProperties  [] = {"text", "font", "textAlign", "foregroundColor", "backgroundColor"}; // index 15-27
	// Note we have to synch those entries when we make the changes. I.e. 
	// standard properties.rect has 6 variables, index 0-5 (x1, y1, x2, y2, width, height)
	// standard properties.rotate has 1 variable, index 6 etc.

	uint t;
	QStringList listAttributes;

	// Every object has those attributes
	for (t=0;t<sizeof (standardProperties) / sizeof (standardProperties[0]);t++)
		listAttributes.append (standardProperties[t]);

	switch (iType)	{
	case TypeFrame:
		for (t=0;t<sizeof (frameProperties) / sizeof (frameProperties[0]);t++)
			listAttributes.append (frameProperties[t]);
	break;
	case TypeImage:
		for (t=0;t<sizeof (imageProperties) / sizeof (imageProperties[0]);t++)
			listAttributes.append (imageProperties[t]);
	break;
	case TypeMovie:
		for (t=0;t<sizeof (imageProperties) / sizeof (imageProperties[0]);t++)
			listAttributes.append (imageProperties[t]);
		for (t=0;t<sizeof (movieProperties) / sizeof (movieProperties[0]);t++)
			listAttributes.append (movieProperties[t]);
	break;
	case TypeText:
		for (t=0;t<sizeof (textProperties) / sizeof (textProperties[0]);t++)
			listAttributes.append (textProperties[t]);
	break;
	case TypeImageBackground:
	break;
	case TypeMovieBackground:
	break;
	}

	m_qsAnimation = qsAnimation;
	m_iMaxFrames  = iFrames;
	m_fFPS        = fFPS;

	if ( ! qsAnimation.isEmpty () )
		m_pEditScript->setText (qsAnimation);
	m_pEditScript->moveCursor (QTextEdit::MoveEnd, false);
	m_pComboAttributes->clear ();
	m_pComboAttributes->insertStringList ( listAttributes );
	m_pSliderPosition->setMaxValue  ( iFrames );
	m_pSliderPosition->setLineStep ( (int)(iFrames/15.0) );
	m_pSliderPosition->setPageStep ( (int)(iFrames/5.0 ) );
	m_pSpinBoxPosition->setMaxValue ( iFrames );

	connect (m_pButtonAdd,       SIGNAL (clicked ()), this, SLOT(slotAddAttribute ()));
	connect (m_pButtonHelp,      SIGNAL (clicked ()), this, SLOT(slotHelp ()));
	connect (m_pSliderPosition,  SIGNAL (valueChanged(int)), this, SLOT (slotValueChanged(int)));
	connect (m_pSpinBoxPosition, SIGNAL (valueChanged(int)), this, SLOT (slotValueChanged (int)));
	connect (m_pComboAttributes, SIGNAL (activated (const QString &)), this, SLOT(slotAttribute (const QString &)));

	slotAttribute ( QString ("rect") );
}

QString &DialogAnimation::string ()
{
	m_qsAnimation = m_pEditScript->text ();
	return m_qsAnimation;
}

void DialogAnimation::setFontName (QString qsFontName )
{
	m_qsFontName = qsFontName;
}

void DialogAnimation::slotHelp ()
{
  QMessageBox::information ( NULL, tr("Animation Dialog"), tr(
"This dialog will allow you to modify an objects properties over time (I.e. animate the object).\n"
" You will be offered the available properties for the object you selected.\n\n"
" The generated output is in the format:\n"
" FrameNumber::object-property=value\n\n"

" E.g. to move an object diagonal over the screen (NTSC) within 100 frames you could use this little script.\n"
" for ((t=0;t<100;t++))\n"
" {\n"
"   echo \"$t::rect.x1=$(($t/100 * 720))\"\n"
"   echo \"$t::rect.y1=$(($t/100 * 480))\"\n"
" }\n"), QMessageBox::Ok, QMessageBox::NoButton );
}

void DialogAnimation::slotValueChanged ( int iNewValue )
{
	static bool bChanging = false;
	if (bChanging)
		return;
	bChanging = true;
	m_pSliderPosition->setValue  ( iNewValue );
	m_pSpinBoxPosition->setValue ( iNewValue );
	bChanging = false;
}

void DialogAnimation::slotAddAttribute ()
{
	// This function adds the set Attribute at the curren cursor position in the text edit
	
	// The following attributes should show up as N::property.attribute=
	char *arrayProperties[] = {"visibleFromTo", "color", "startPos", "res", "blendColor", "foregroundColor", "backgroundColor", "rect", "scale", "shear"};

	uint t;
	bool bFound = false;
	QString qsNewText;
	qsNewText=QString ("%1::%2").arg (m_pSpinBoxPosition->text ()).arg (m_pComboAttributes->currentText());

	for (t=0; t < sizeof (arrayProperties) / sizeof (arrayProperties[0]); t++)	{
		if (m_pComboAttributes->currentText () == arrayProperties[t])	{
			bFound = true;
			break;
		}
	}

	if (bFound)	{
		if (m_pComboAttributeSub->count () > 0)
			qsNewText += QString (".%1=").arg(m_pComboAttributeSub->currentText());
		else
			qsNewText += QString ("=");
	}
	else	{
		qsNewText += QString ("=%1").arg(m_pComboAttributeSub->currentText ());
	}

	m_pEditScript->insert (qsNewText);
}

void DialogAnimation::slotAttribute (const QString &newText)
{
	// Here we set the m_pComboAttributeSub according to the value of m_pComboAttributes
	m_pComboAttributeSub->clear ();
	if ( (newText == "color") || (newText == "blendColor") || (newText == "backgroundColor") || (newText == "foregroundColor") )	{
		m_pComboAttributeSub->insertItem ( "red" );
		m_pComboAttributeSub->insertItem ( "green" );
		m_pComboAttributeSub->insertItem ( "blue" );
	}
	else if ( newText == "rect" )	{
		m_pComboAttributeSub->insertItem ( "x1" );
		m_pComboAttributeSub->insertItem ( "y1" );
		m_pComboAttributeSub->insertItem ( "x2" );
		m_pComboAttributeSub->insertItem ( "y2" );
		m_pComboAttributeSub->insertItem ( "width" );
		m_pComboAttributeSub->insertItem ( "height" );
	}
	else if ( newText == "visibleFromTo" )	{
		m_pComboAttributeSub->insertItem ( "startFrame" );
		m_pComboAttributeSub->insertItem ( "stopFrame" );
	}
	else if ( ( newText == "startPos" ) || ( newText == "pos" )|| ( newText == "res" ) || ( newText == "scale" ) || ( newText == "shear" ) )	{
		m_pComboAttributeSub->insertItem ( "x" );
		m_pComboAttributeSub->insertItem ( "y" );
	}
	else if ( newText == "showBackground" )	{
		m_pComboAttributeSub->insertItem ( "true" );
		m_pComboAttributeSub->insertItem ( "false" );
	}
	else if ( newText == "frameStyle" )	{
		m_pComboAttributeSub->insertItem ( "SolidLine" );
		m_pComboAttributeSub->insertItem ( "DashLine" );
		m_pComboAttributeSub->insertItem ( "DashDotLine" );
		m_pComboAttributeSub->insertItem ( "DashDotDotLine" );
	}
	else if ( newText == "frameJoin" )	{
		m_pComboAttributeSub->insertItem ( "MiterJoin" );
		m_pComboAttributeSub->insertItem ( "BevelJoin" );
		m_pComboAttributeSub->insertItem ( "RoundJoin" );
	}
	else if ( newText == "font" )	{
		m_pComboAttributeSub->insertItem ( m_qsFontName );
	}
	else if ( newText == "textAlign" )	{
		m_pComboAttributeSub->insertItem ( "AlignLeft" );
		m_pComboAttributeSub->insertItem ( "AlignRight" );
		m_pComboAttributeSub->insertItem ( "AlignHCenter" );
		m_pComboAttributeSub->insertItem ( "AlignJustify" );
	}
}

