/****************************************************************************
** Interface to the GUI.
**
** Created: Wed Feb 18 22:48:00 2004
**      by: Varol Okan using kate editor
**
**
****************************************************************************/

#ifndef DIALOGTEXTFONT_H
#define DIALOGTEXTFONT_H

#include <qfont.h>
#include <qstring.h>

// the designer created GUI.
#include "uidialogtextfont.h"

class QPaintEvent;

class DialogTextFont : public uiDialogTextFont
{
	Q_OBJECT
public:
	 DialogTextFont (QWidget * parent, const char * name = 0, WFlags f = 0 );
	~DialogTextFont ();

	void     setFont (const QFont &);
	QFont   &getFont              ();
	void     setText     (QString &);
	void     setTextAlign (QPoint &);
	void     setTransparency (float);
	void     setRect       (QRect &);
	QRect   &getRect              ();
	void     setAnimation(QString &);
	QString &getAnimation         ();
	bool     getFit               ();
	QString  getText              ();
	QPoint  &getTextAlign         ();
	QColor  &getBackgroundColor   ();
	QColor  &getForegroundColor   ();
	float    getTransparency      ();
	void     setBackgroundColor   (const QColor &);
	void     setForegroundColor   (QColor &);

protected:
	void initMe             ( );
	void updateFont         ( uint iSwitch );
	void updateButtons      ( );
	int  findString         ( QStringList &list, QString string);
	virtual void paintEvent ( QPaintEvent * );

protected slots:
	virtual void resizeEvent ( QResizeEvent * );
	virtual void slotFontFamilyChanged ( int  );
	virtual void slotFontStyleChanged  ( int  );
	virtual void slotFontSizeChanged   ( int  );
	virtual void slotFontSizeChanged   ( const QString & );
	virtual void slotScriptChanged     ( int  );
	virtual void slotRight             ( bool );
	virtual void slotCenter            ( bool );
	virtual void slotLeft              ( bool );
	virtual void slotJustify           ( bool );
	virtual void slotVCenter           ( bool );
	virtual void slotFit               ( bool );
	virtual void slotUnderline         ( bool );
	virtual void slotStrikeout         ( bool );
	virtual void slotAnimation         (      );
	virtual void slotForegroundColor   (      );
	virtual void slotBackgroundColor   (      );
	virtual void slotTransparency      ( int  );
	virtual void slotOkay              (      );

private:
	QFont	m_qfFont;
	QColor	m_backgroundColor;
	QColor	m_foregroundColor;
	float   m_fTransparency;
	QString m_qsAnimation;

	static QFont    m_previousFont;
	static QString  m_previousText;
	static float    m_previousTransparency;
	static QPoint   m_previousTextAlign;
	static QColor   m_previousForeground;
	static QColor   m_previousBackground;
};

#endif // DIALOGTEXTFONT_H
