/****************************************************************************
** Interface to the GUI.
**
** Created: Sun Dec 14 12:09:08 2003
**      by: Varol Okan using kate editor
**
** This class generates the command line for dvdauthor.
** Current Version of DVDAUTHOR used is 0.67
** You can find dvdauthor under http://dvdauthor.sourceforge.net/
**
****************************************************************************/

#ifndef MENUPREVIEW_H
#define MENUPREVIEW_H

#define DRAGGED_IMAGE_NAME "draggedImage.png"

#include <qvaluelist.h>

#include "selectionobject.h"
#include "buttonpreview.h"
#include "menuobject.h"

class ButtonObject;
class ImageObject;
class TextObject;
class MovieObject;
class DialogButton;
class SourceFileEntry;

class MenuPreview : public ButtonPreview
{
	Q_OBJECT
	// m_iCreatreObjectStyle
	enum { TypeNone=0, FrameType, TextType, ImageType, MovieType, CollectionType };
	// m_iPointerState
	enum { StateUnknown=0, StateNormal, StateMoveSelected, StateReadyToCreate, StateCreating, StateSelecting, StateSelected };
public:
	// type of what has dropped on this MenuPreview
	enum { DroppedDontKnow=0, DroppedImage, DroppedText, DroppedImageAndText, DroppedMovieAndText, DroppedPants};
	 
	 MenuPreview ( QWidget * parent, const char * name = 0, WFlags f = 0 );
	~MenuPreview ( );
	void clear   ( QColor * );
	void initMe  ( QColor * );

	void respondSourceFiles ( QValueList<SourceFileEntry *> );
	void respondSubMenus    ( QStringList );

	bool readProjectFile    ( QDomNode    & );
	bool writeProjectFile   ( QDomElement & );
	bool createContextMenu  ( QPoint);

	void setIsSubMenu       ( bool );
	void setIsMovieMenu     ( bool );
	MenuObject *readObject  ( QDomNode &objectNode );

	void setVisibleRegion   ( bool );
	void setImageButton     ( bool );
	void createAnimationData( QString &, long );

	MenuObject *createFrameObject      ( bool b=true );
	MenuObject *createTextObject       ( bool b=true );
	MenuObject *createImageObject      ( bool b=true );
	MenuObject *createMovieObject      ( bool b=true );
	MenuObject *createButtonObject     ( bool b=true );
	MenuObject *createObjectCollection ( bool b=true );

public slots:
	virtual void slotAddFrameObject        ( );
	virtual void slotAddTextObject         ( );
	virtual void slotAddImageObject        ( );
	virtual void slotAddMovieObject        ( );
	virtual void slotAddCollection         ( );
	virtual void slotUpdateStructure       ( );
	virtual void slotUpdatePixmap          ( );
	virtual void slotAddShadow             ( MenuObject   * );
	virtual void slotDefineAsButton        ( MenuObject   * );
	virtual void slotDeleteObject          ( MenuObject   * );
	virtual void slotModifyObject          ( MenuObject   * );
	virtual void slotUnbutton              ( ButtonObject * );
	virtual void slotCreateButtonDialog    ( ButtonObject * );
	virtual void slotEmitDeleteMe          ( );
	virtual void slotDeleteMenu            ( );
	virtual void slotRenameMenu            ( );
	virtual void slotDestroyedButtonDialog ( );
	virtual void slotEditTimeline          ( );

signals:
	void signalUpdateStructure    ( );
	void signalRequestSourceFiles ( );
	void signalRequestSubMenus    ( );
	void signalDeleteMe           ( );
	void signalEditTimeline       ( );
	void signalRenameMe           ( );
	void signalDroppedSomething   ( uint );
	void signalMaskColorChanged   ( QColor, QColor );
	void signalCreatedMovieObject ( MovieObject  *, bool );

protected:
	virtual void mousePressEvent	   ( QMouseEvent * );
	virtual void mouseReleaseEvent	   ( QMouseEvent * );
	virtual void mouseDoubleClickEvent ( QMouseEvent * );
	virtual void mouseMoveEvent 	   ( QMouseEvent * );

	// Drag'n drop stuff
	virtual void dropEvent      ( QDropEvent      * );
	virtual void dragEnterEvent ( QDragEnterEvent * );

//	virtual void drawContents (QPainter *);
	QString &newButtonName ( );

private:	// Private functions ...
	MenuObject *insertDraggedObject     ( QDropEvent *, QImage  & );
	MenuObject *insertDraggedImage      ( QDropEvent *, QImage  & );
	MenuObject *insertDraggedMovie      ( QDropEvent *, QImage  &, long i=0 );
	MenuObject *insertDraggedText       ( QDropEvent *, QString & );
	MenuObject *insertDraggedSourceInfo ( QDropEvent *, QImage  & );// ButtonObject
	MenuObject *insertDraggedSourceEntry( QDropEvent *, QImage  & );// FullScale Layouts and new menus and all the bells and whistles (In future release anyhow ...SORRY)
	void        connectStdSlots         ( MenuObject * );
	void        checkSelection          ( );

private:
	QPixmap m_doubleBuffer;
	int     m_iCreateObjectStyle;  // What object, text, image, frame, or movie ?
	int     m_iPointerState;
	bool    m_bImageButton;        // Should we create ImageButton objects or MovieButtons when dropping ?
	QRect   m_rectCurrentObject;
	bool    m_bIsSubMenu;
	bool    m_bIsMovieMenu;
	QColor *m_pPgcColors;
	DialogButton   *m_pDialogButton;
	SelectionObject m_selectionObject;
};

#endif // MENUPREVIEW_H
