/****************************************************************************
** Class DialogConvert
**
** Created: Tue Oct 14 09:13:25 2006
**      by: Varol Okan, using XEmaxs
**
**
****************************************************************************/

#ifndef DIALOGALIGN_H
#define DIALOGALIGN_H

#include <qimage.h>
#include <qpixmap.h>

#include "uidialogalign.h"

class SelectionObject;
class MenuPreview;
class MenuObject;
class QPainter;

class DialogAlign : public uiDialogAlign
{
    Q_OBJECT

public:
   DialogAlign ( MenuPreview * );
  ~DialogAlign ( );

  void initMe ( SelectionObject *, QPixmap * );

protected:
  void refresh    ( bool b=false );
  void drawLine   ( QPainter   * );
  void resetZoom  ( MenuObject * );
  void resetObjectPos          ( );
  void refreshBackgroundPixmap ( );
  void alignDistance           ( QPtrList<MenuObject> &theList );
  void alignHorizontalCenter   ( QPtrList<MenuObject> &theList );
  void alignVerticalCenter     ( QPtrList<MenuObject> &theList );
  void alignHorizontalSpace    ( QPtrList<MenuObject> &theList );
  void alignVerticalSpace      ( QPtrList<MenuObject> &theList );

protected slots:
  virtual void accept          ( );
  virtual void resizeEvent     ( QResizeEvent * );
  virtual void timerEvent      ( QTimerEvent  * );
  virtual void slotAlign       ( int  );
  virtual void slotAlignPos    ( int  );
  virtual void slotDistance    ( int  );
  virtual void slotSliderAlign ( int  );
  virtual void slotRefresh     (      );
  virtual void slotRefresh     ( bool );
  virtual void slotRefresh     ( const QString & );

private:
  SelectionObject *m_pSelectionObject;
  MenuPreview     *m_pMenuPreview;
  QImage           m_backgroundImage;  // Orig size background
  QPixmap          m_backgroundPixmap; // scaled background
  QLabel          *m_pPreview;
  QPtrList<MenuObject> m_listOfObjects;
  
  int              m_iTimerID;
  int              m_iTimerObjectSizeID;
  double           m_fZoom;
};

#endif // DIALOGALIGN_H
