/****************************************************************************
** Form implementation generated from reading ui file 'uidialogconvert.ui'
**
** Created: Tue Oct 14 09:13:25 2006
**      by: Varol Okan, using XEmacs
**
** This dialog does either convert the current project or creates a 
** multi format DVD which holds both NTSC and PAL versions of the DVD.
**
** Converting only requires to change the resolution of he menus and mark 
** all sourcefileInfos for transcoding (if required)
**
** If you Keep the Menus, you have to also change all jumps to sub menus 
** to the newly created menus instead of jumping to the defined Sub menu 
** ( this would get the user back to the wrong formated SubMenu).
**
** If you keep the original videos, then you will also have to take care 
** of the naming of the source files, the new name of the SourceFileEntry
** etc.
** 
** NTSC -> PAL
** - SourceFileEntry.qsDisplayName = PAL-<Orig Name>
** - SourceFileInfo.fileName = Global::qsTempPath/Global::qsProjectName/PAL_<origName>
** - Menus:
**   "Main Menu VMGM" -> "PAL-Main Menu"
**   <OrigName>       -> PAL-<OrigName> ( with N=[1 .. 356656] )
**
** PAL -> NTSC
** SourceFileEntry.qsDisplayName = NTSC-<Orig Name>
** SourceFileInfo.fileName = Global::qsTempPath/Global::qsProjectName/NTSC_<origName>
** - Menus:
**   "Main Menu VMGM" -> "NTSC-Main Menu"
**   <OrigName>       -> NTSC-<OrigName> ( with N=[1 .. 356656] )
**
** In case a chooser menu is to be created, then we rename the VMGM to 
** Orig VMGM
**
****************************************************************************/

#include <stdlib.h>

#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qapplication.h>
#include <qcheckbox.h>
#include <qcursor.h>
#include <qfileinfo.h>


#include "utils.h"
#include "dvdmenu.h"
#include "qdvdauthor.h"
#include "imageobject.h"
#include "shadowobject.h"
#include "textobject.h"
#include "movieobject.h"
#include "menupreview.h"
#include "buttonobject.h"
#include "dialogconvert.h"
#include "sourcefileentry.h"

DialogConvert::Pair::Pair ( SourceFileEntry *pOrig, SourceFileEntry *pNew )
{
  entries[0] = pOrig;
  entries[1] = pNew;
  menus  [0] = NULL;
  menus  [1] = NULL;
}

DialogConvert::Pair::Pair ( DVDMenu *pOrig, DVDMenu *pNew )
{
  entries[0] = NULL;
  entries[1] = NULL;
  menus  [0] = pOrig;
  menus  [1] = pNew;
}

DialogConvert::DialogConvert ( QDVDAuthor *pDVDAuthor )
    : uiDialogConvert ( NULL )
{
  m_pDVDAuthor = pDVDAuthor;
  m_qsOrigNorm = "NTSC";

  connect ( m_pCheckAllMenus,          SIGNAL ( toggled ( bool ) ), this, SLOT ( slotAllMenus    ( bool ) ) );
  connect ( m_pCheckAllVideos,         SIGNAL ( toggled ( bool ) ), this, SLOT ( slotAllVideos   ( bool ) ) );
  connect ( m_pCheckKeepMenus,         SIGNAL ( toggled ( bool ) ), this, SLOT ( slotKeepOriginalMenus ( bool ) ) );
  connect ( m_pCheckCreateChooserMenu, SIGNAL ( toggled ( bool ) ), this, SLOT ( slotChooserMenu ( bool ) ) );
}

DialogConvert::~DialogConvert ( )
{
  uint t;
  for ( t=0; t<m_listSourceFileEntryPair.count ( ); t++ ) 
    delete m_listSourceFileEntryPair.at ( t );
  m_listSourceFileEntryPair.clear ( );

  for ( t=0; t<m_listDVDMenuPair.count ( ); t++ ) 
    delete m_listDVDMenuPair.at ( t );
  m_listDVDMenuPair.clear ( );

}

void DialogConvert::slotAllMenus ( bool bChecked )
{ 
  m_pCheckKeepMenus->setEnabled ( bChecked );
  if ( m_pCheckKeepMenus->isChecked ( ) )
    m_pGroupCreateVMGM->setEnabled ( bChecked );
}

void DialogConvert::slotAllVideos ( bool bChecked )
{
  m_pCheckKeepVideos->setEnabled ( bChecked );
}

void DialogConvert::slotChooserMenu ( bool bChecked )
{
  m_pRadioChooserInNTSC->setEnabled ( bChecked );
  m_pRadioChooserInPAL ->setEnabled ( bChecked );
}

void DialogConvert::slotKeepOriginalMenus ( bool bChecked )
{
  m_pGroupCreateVMGM->setEnabled ( bChecked );
  slotChooserMenu ( m_pCheckCreateChooserMenu->isChecked ( ) );
}

void DialogConvert::accept ( )
{
  if ( ! m_pDVDAuthor )
    QDialog::accept ( );

  // Attributes to ake care off ...
  bool bConvertToPAL       = m_pRadioToPAL->isChecked             ( );
  bool bConvertAllVideos   = m_pCheckAllVideos->isChecked         ( );
  bool bConvertAllMenus    = m_pCheckAllMenus->isChecked          ( );
  bool bCheckKeepMenus     = m_pCheckKeepMenus->isChecked         ( );
  bool bCheckKeepVideos    = m_pCheckKeepVideos->isChecked        ( );
  bool bCreateVMGMChooser  = m_pCheckCreateChooserMenu->isChecked ( );
  bool bVMGMChooserInPAL   = m_pRadioChooserInPAL->isChecked      ( );

  SourceFileEntry *pSourceFileEntry = NULL;
  //  SourceFileInfo  *pSourceFileInfo  = NULL;
  QValueList<SourceFileEntry *> listSourceFileEntries;
  QString strNorm = "NTSC";

  int t, i, iRet = 0;
  SourceFileInfo *pInfo;
  QString qsCommand, qsNewFileName;
  QFileInfo fileInfo;

  if ( bConvertToPAL )
    strNorm = "PAL";

  QCursor myCursor (QCursor::WaitCursor);
  QApplication::setOverrideCursor (myCursor);

  if ( bConvertAllVideos ) {
    for ( t=0;t<m_pDVDAuthor->sourceFileCount ( ); t++ ) {
      pSourceFileEntry = m_pDVDAuthor->sourceFileEntry ( t );
      if ( bCheckKeepVideos ) {
	SourceFileEntry *pNewEntry = new SourceFileEntry;
	*pNewEntry = *pSourceFileEntry;
	m_listSourceFileEntryPair.append ( new Pair ( pSourceFileEntry, pNewEntry ) );
	pNewEntry->qsDisplayName = strNorm + "-" + pNewEntry->qsDisplayName;
	convert ( pNewEntry, bConvertToPAL );
	// we're not quite there yet.
	// In order to have the DVD created we ought to rename the source files,
	// so that PAL/NTSC material is not delleting each other out.
	for ( i=0;i<(int)pNewEntry->listFileInfos.count (); i++ ) {
	  pInfo = pNewEntry->listFileInfos[i];
	  fileInfo.setFile ( pInfo->qsFileName );
	  qsNewFileName = QString ( "%1/%2/%3_%4" ).arg ( Global::qsTempPath ).arg ( Global::qsProjectName ).arg ( strNorm ).arg ( fileInfo.fileName ( ) );
	  qsCommand = QString ( "ln -s \"%1\" \"%2\" > /dev/null 2>&1" ).arg ( pInfo->qsFileName).arg ( qsNewFileName );
	  pInfo->qsFileName = qsNewFileName;
	  iRet = system ( qsCommand.ascii ( ) );
//printf ( "CMD<%s> FILE<%s>\n", qsCommand.ascii(), qsNewFileName.ascii() );
	}
	// Still we have to take care of the Buttons for the new menus, which connect to 
	// the newly created SourceFileInfos instead of to the originals.

	listSourceFileEntries.append ( pNewEntry );
      }
      else
	convert ( pSourceFileEntry, bConvertToPAL );
    }

    for ( t=0;t<(int)listSourceFileEntries.count ( ); t++ ) 
      m_pDVDAuthor->appendSourceFileEntry ( listSourceFileEntries [ t ] );

  }

  if ( bConvertAllMenus ) {
    if ( bCreateVMGMChooser ) {
      bVMGMChooserInPAL = bVMGMChooserInPAL; // ...
    }

    convert ( bConvertToPAL, bCheckKeepMenus );
  }
  QApplication::restoreOverrideCursor ();

  QDialog::accept ( );
}

void DialogConvert::convert ( bool bConvertToPAL, bool bKeepMenus )
{
  uint t;
  bool bCreateVMGMChooser = m_pCheckCreateChooserMenu->isChecked ( );
  bool bVMGMChooserInPAL  = m_pRadioChooserInPAL->isChecked      ( );
  QValueList<DVDMenu *>listOfMenus  =  m_pDVDAuthor->getSubMenus ( );
  // Note VMGM is already converted or has been replaced by the Chooser - menu.
  QString  qsNewTitle, qsNorm, qsOrigTitle;
  DVDMenu *pOrigMenu, *pNewMenu;
  pOrigMenu = pNewMenu  = NULL;

  qsNorm = "NTSC";
  m_qsOrigNorm = "PAL"; // assume we convert from one norm into the other
  if ( bConvertToPAL ) {
    qsNorm = "PAL";
    m_qsOrigNorm = "NTSC";
  }

  pOrigMenu = m_pDVDAuthor->getVMGMenu ( );
  pNewMenu  = pOrigMenu;
  if ( bKeepMenus ) {
    if ( bCreateVMGMChooser ) { // only needed if user want's to keep orig menus
      // Lets create a clone first ...
      QString qsCurrentNorm = "NTSC";
      if ( pOrigMenu->getInterface ( )->iFormat > 4 )
	qsCurrentNorm = "PAL";
      m_qsOrigNorm = qsCurrentNorm;

      qsNewTitle =  tr ( "%1-Main Menu" ).arg ( qsCurrentNorm );
//printf ( "%s::%s::%d %d=<%s>\n", __FILE__, __FUNCTION__, __LINE__, pOrigMenu->getInterface ( )->iFormat, qsCurrentNorm.ascii () );
      pNewMenu = pOrigMenu->clone  ( );
      pNewMenu->getInterface   ( )->qsMenuName = qsNewTitle; 
      m_pDVDAuthor->addDVDMenu ( pNewMenu );
      pNewMenu->setTabLabel    ( qsNewTitle );
      // After we cloned the VMGM, we should create the chooser menu ...
      createChooserMenu ( pOrigMenu, bVMGMChooserInPAL );

      // And finally we assume the newly created clone is the original ...
      pOrigMenu = pNewMenu;
    }
    // at this point we will clone the VMGM ...
    qsNewTitle = tr ( "%1-Main Menu" ).arg ( qsNorm );
//printf ( "%s::%s::%d <%s>\n", __FILE__, __FUNCTION__, __LINE__, qsNewTitle.ascii () );
    pNewMenu  = pOrigMenu->clone  ( );
    m_listDVDMenuPair.append ( new Pair ( pOrigMenu, pNewMenu ) );
    //setDVDMenuInterface ( pNewMenu, qsNewTitle, bConvertToPAL );
    pNewMenu->getInterface   ( )->qsMenuName = qsNewTitle; 
    pNewMenu->getInterface   ( )->bIsSubMenu = true;
    m_pDVDAuthor->addDVDMenu ( pNewMenu );
    pNewMenu->setTabLabel    ( qsNewTitle );
  }
  convert ( pNewMenu, bConvertToPAL );

  for ( t=0; t<listOfMenus.count ( ); t++ ) {
    pOrigMenu = listOfMenus [t];
    if ( ! pOrigMenu )
      continue;

    pNewMenu = pOrigMenu;
    if ( bKeepMenus ) {
      qsNewTitle  = qsNorm + QString ( "-" ) + pOrigMenu->getInterface ( )->qsMenuName;
      pNewMenu    = pOrigMenu->clone ( );
      m_listDVDMenuPair.append ( new Pair ( pOrigMenu, pNewMenu ) );
      //setDVDMenuInterface ( pNewMenu, qsNewTitle, bConvertToPAL );      
      pNewMenu->getInterface   ( )->qsMenuName = qsNewTitle;
      m_pDVDAuthor->addDVDMenu ( pNewMenu   );
      pNewMenu->setTabLabel    ( qsNewTitle );
    }
    convert ( pNewMenu, bConvertToPAL );
  }

  // Here we should take care of the buttons, they need to be pointing now to the 
  // correct menus
  fixButtonObjects ( bConvertToPAL, bKeepMenus );
  // and this will adjust the buttons pointing to the VMGM if a chooser menu was created 
  if ( ( bKeepMenus ) && ( bCreateVMGMChooser ) ) 
    fixButtonObjects (  );
}


void DialogConvert::setDVDMenuInterface ( DVDMenu *pMenu, QString &qsTitle, bool bConvertToPAL )
{
  int  iHeight;
  pMenu->getInterface   ( )->qsMenuName = qsTitle;
  pMenu->getInterface   ( )->iWidth  = 720;
  if ( bConvertToPAL ) {
    iHeight = 576;
    if ( pMenu->getInterface ( )->iHeight < 400 )
      iHeight = 288;
  }
  else {
    iHeight = 480;
    if ( pMenu->getInterface ( )->iHeight < 400 )
      iHeight = 240;
  }
  pMenu->getInterface   ( )->iHeight = iHeight;
  
  m_pDVDAuthor->addDVDMenu ( pMenu   );
  pMenu->setTabLabel    ( qsTitle );
}

void DialogConvert::fixButtonObjects ( bool bConvertToPAL, bool bKeepMenus )
{
  // This function goes in concert with the changes to the SourceFileInfos made further up.
  // Note this only applies if we do not convert this menu from PAL to PAL or from
  // NTSC to NTSC.
  // It also applies only if we want to keep the original videos (for usage in original menus ...)
  bool bCheckKeepVideos = m_pCheckKeepVideos->isChecked ( );
  if ( ! bCheckKeepVideos )
    return;

  uint t, i, j;
  QValueList<ButtonObject *> listOfButtons;
  SourceFileEntry *pEntry;
  ButtonObject    *pButton;
  DVDMenu    *pOrigDVDMenu,  *pNewDVDMenu;
  QString     qsButtonAction, qsNewAction, qsNorm;
  QStringList actionList;

  qsNorm = "NTSC";
  if ( bConvertToPAL )
    qsNorm = "PAL";

  for ( i=0; i < m_listDVDMenuPair.count ( ); i++ ) {
    pOrigDVDMenu = m_listDVDMenuPair.at ( i )->menus [ 0 ];
    pNewDVDMenu  = m_listDVDMenuPair.at ( i )->menus [ 1 ];
    listOfButtons.clear ( );
    listOfButtons = pNewDVDMenu->getButtons ( );
    for ( t=0; t<listOfButtons.count ( );t++ ) {
      pButton = listOfButtons[t];
      if ( ! pButton )
	continue;
      qsButtonAction  = pButton->action ( );
      pEntry = pButton->sourceFileEntry ( );
      if ( ! pEntry ) {
	// Here we handle jumps to the 'new' SubMenus
	if ( bKeepMenus ) { // the menus have changed (added new clones and converted format 
	  // At this point we know that we have a button to a Menu source.
	  actionList = QStringList::split (QString (STRING_SEPARATOR), qsButtonAction);
	  if ( actionList.count ( ) > 1 ) {
	    qsNewAction = actionList[0] + QString ( STRING_SEPARATOR );
	    if ( actionList[1] == QString ( "vmgm" ) )
	      qsNewAction += qsNorm + QString ( "-Main Menu" ) + QString ( STRING_SEPARATOR );
	    else
	      qsNewAction += qsNorm + QString ( "-" ) + actionList[1] + QString ( STRING_SEPARATOR );
//printf ( "%s::%s::%d <%s>\n", __FILE__, __FUNCTION__, __LINE__, qsNewAction.ascii () );
	    pButton->setAction ( qsNewAction );
	  }
	}
	continue;
      }
      // At this point we know that we have a button to a Video source.
      actionList = QStringList::split (QString (STRING_SEPARATOR), qsButtonAction);
      // in case the user specified a manual name ... No can do ...
      if ( actionList.count ( ) >= 2 ) {
	qsNewAction  = actionList[0] + QString ( STRING_SEPARATOR ) + qsNorm + QString ( "-" );
	qsNewAction += actionList[1] + QString ( STRING_SEPARATOR );
	if ( actionList.count ( ) == 4 )
	  qsNewAction += qsNorm + QString ("_" ) + actionList[2] + QString ( STRING_SEPARATOR ) + actionList[3];
	else if ( actionList.count ( ) > 2 )
	  qsNewAction += actionList[2];
	pButton->setAction ( qsNewAction );
	// But lo and behold we also have to change the pointer to the sourceFileEntry in the button.
	for ( j=0; j<m_listSourceFileEntryPair.count ( ); j++ ) {
	  if ( m_listSourceFileEntryPair.at ( j )->entries[0] == pEntry ) {
	    pButton->setSourceFileEntry ( m_listSourceFileEntryPair.at ( j )->entries[1] );
	    j = 10000; // exit for - loop
	  }
	}
      }
    }
  }
}

void DialogConvert::createChooserMenu ( DVDMenu *pMenu, bool bPal )
{
  // The chooser menu is simply a menu with two buttons.
  // One button is pointing towards the original VMGM (NTSC-Main Menu) [E.g. NTSC format]
  // the other button points towards the (PAL-Main Menu) menu.[E.g. PAL format]
  int iWidth, iHeight, iFormat;
  QPixmap thePixmap;
  QString qsFileName;
  MenuPreview *pPreview;
  QRect buttonRect;
  bool  bOrigIsPal;

  iWidth     = pMenu->getInterface ( )->iWidth;
  iHeight    = pMenu->getInterface ( )->iHeight;
  iFormat    = pMenu->getFormat ( iWidth, iHeight );
  bOrigIsPal = ( iFormat >= FORMAT_PAL1 );
  qsFileName = pMenu->getInterface ( )->qsBackgroundFileName;
  // We always have the VMGM here. Thus we can not delete the menu.
  pMenu->clear ( );
  // For now we create a plain light - blue background 
  iWidth  = 720;
  iHeight = 480;
  if ( bPal )
    iHeight = 576;

  if ( qsFileName.isEmpty ( ) ) {
    thePixmap = QPixmap ( iWidth, iHeight );
    thePixmap.fill ( QColor ( 0x2C, 0x4F, 0xFF ) ); // light blue.
  }
  else {
    QImage tempImage ( qsFileName );
    ShadowObject::blurImage ( tempImage, 24 );

    thePixmap.convertFromImage ( tempImage.smoothScale ( iWidth, iHeight, QImage::ScaleFree ) );
  }
  qsFileName = Global::qsTempPath + "/" + Global::qsProjectName + "/chooser.png";

  thePixmap.save ( qsFileName, "PNG", 100 );
  
  pMenu->initBackground ( qsFileName );
  
  // Next step is to create the two buttons ...
  buttonRect = QRect ( 55, 50, 220, 170 );
  pPreview = pMenu->getMenuPreview ( );
  if ( bOrigIsPal ) {
//printf ( "%s::%s::%d\n", __FILE__, __FUNCTION__, __LINE__ );
    createButtonObject ( pPreview, tr ( "PAL" ),    "PAL-Main Menu", buttonRect );
    buttonRect = QRect ( 450, 270 + bPal * 96, 220, 170 );    
    createButtonObject ( pPreview, tr ( "NTSC" ), "NTSC-Main Menu", buttonRect );
  }
  else {
//printf ( "%s::%s::%d\n", __FILE__, __FUNCTION__, __LINE__ );
    createButtonObject ( pPreview, tr ( "NTSC" ),   "NTSC-Main Menu", buttonRect );
    buttonRect = QRect ( 450, 270 + bPal * 96, 220, 170 );    
    createButtonObject ( pPreview, tr ( "PAL" ),  "PAL-Main Menu", buttonRect );
  }
  
  // Lastly we should point all buttons of the original menus to the "Orig VMGM" menu instead of this newly creaed VMGM.
  //  fixButtonObjects ( );
}

void DialogConvert::fixButtonObjects ( )
{
  // This function handles the buttons which are pointing to the VMGM menu only.
  // it is called after the Chooser menu took over as VMGM and the original VMGM 
  // has been renamed to Orig VMGM.
  uint t, i;
  QValueList<ButtonObject *> listOfButtons;
  ButtonObject *pButton;
  DVDMenu      *pMenu;
  QString       qsButtonAction, qsNewAction, qsNorm;
  QStringList   actionList;
  QValueList<DVDMenu *>listOfMenus  =  m_pDVDAuthor->getSubMenus ( );

  for ( i=0; i < listOfMenus.count ( ); i++ ) {
    pMenu = listOfMenus[ i ];

    listOfButtons.clear ( );
    listOfButtons = pMenu->getButtons ( );
    qsNorm = "NTSC";
    if ( pMenu->getInterface ( )->iFormat > 4 )
      qsNorm = "PAL";
    for ( t=0; t<listOfButtons.count ( );t++ ) {
      pButton = listOfButtons[t];
      if ( ! pButton )
	continue;
      qsButtonAction  = pButton->action ( );
      if ( ! pButton->sourceFileEntry ( ) ) {
	// At this point we know that we have a button to a Menu source.
	actionList = QStringList::split (QString (STRING_SEPARATOR), qsButtonAction);
	if ( actionList.count ( ) > 1 ) {
	  if ( actionList[1] == QString ( "vmgm" ) ) {
	    qsNewAction = actionList[0] + QString ( STRING_SEPARATOR ) + qsNorm + QString ( "-Main Menu" ) + QString ( STRING_SEPARATOR );
	    pButton->setAction ( qsNewAction );
	  }
	  else if ( qsNorm != m_qsOrigNorm ) {
	    qsNewAction = actionList[0] + QString ( STRING_SEPARATOR ) + qsNorm + QString ( "-" ) + actionList[1] + QString ( STRING_SEPARATOR );
	    pButton->setAction ( qsNewAction );
	  }
	}
      }
    }
  }
}

void DialogConvert::createButtonObject ( MenuPreview *pPreview, QString qsText, QString qsMenu, QRect theRect )
{
  // Create a text button with qsText as the text and the rectangle theRect.
  // qsMenu is pointing to the menu specified in this string 
  QFont theFont;
  if ( ! theFont.fromString ( "Nimbus Sans L,36,-1,5,75,0,0,0,0,0" ) )
    theFont.fromString ( "Sans Serif,36,-1,5,75,0,0,0,0,0" );
  QColor  theColor     ( 0x75, 0x20, 0x8D );
  QPoint  textAlign    ( 4, 64  );
  QString qsAction     ( "jump"STRING_SEPARATOR + qsMenu + STRING_SEPARATOR );
  TextObject   *pTextObject = NULL;
  ButtonObject *pButton = NULL;
  ShadowObject *pShadow = NULL;

  pTextObject = (TextObject *)pPreview->createTextObject ( false );
  pTextObject->setText ( qsText   );
  pTextObject->setRect ( theRect  );
  pTextObject->setFont ( theFont  );
  pTextObject->setForegroundColor( theColor  );
  pTextObject->setTextAlign      ( textAlign );

  pShadow = new ShadowObject ( pTextObject );
  pShadow->setBlur       (  5   );
  pShadow->setDistance   ( 20.0 );
  pShadow->setSunAngle   ( 33.0 );
  pTextObject->setShadow ( pShadow );

  pButton = pPreview->defineAsButton ( pTextObject, false );
  pButton->setAction ( qsAction );

  pPreview->updatePixmap ( );
}

void DialogConvert::convert ( SourceFileEntry *pEntry, bool bConvertToPAL )
{
  uint t;
  bool bIsPal;
  SourceFileInfo     *pInfo;
  TranscodeInterface *pInterface = NULL;

  for ( t=0;t<pEntry->listFileInfos.count ( ); t++  ) {
    pInfo = pEntry->listFileInfos[t];
    if ( ! pInfo )
      continue;

    // delete an existing transcoding interface.
    if ( pInfo->pTranscodeInterface ) {
      delete pInfo->pTranscodeInterface;
      pInfo->pTranscodeInterface = NULL;
    }

    bIsPal = isPal ( pInfo );
    if ( bIsPal == bConvertToPAL )
      continue;

    // okay at this point we shoul create a transcoding interface
    pInterface = new TranscodeInterface;
    if ( bConvertToPAL ) {
      pInterface->qsVideoFormat = "PAL";
      pInterface->qsResolution  = "720x576";
      pInterface->fFrameRate    = 25.0;
    }
    else {
      pInterface->qsVideoFormat = "NTSC";
      pInterface->qsResolution  = "720x480";
      pInterface->fFrameRate    = 29.97;
    }
    pInterface->qsVideoType     = "mpeg2";
    pInterface->iVideoBitrate   = 6600000;
    
    if ( pInfo->qsRatio.isEmpty ( ) )
      pInterface->qsRatio = "4:3";
    else
      pInterface->qsRatio = pInfo->qsRatio;
    

    pInterface->qsAudioFormat   = "Stereo 2.0";
    pInterface->qsAudioType     = "mp2";
    pInterface->iAudioBitrate   = 192000;
    pInterface->iSample         =  48000;

    pInfo->pTranscodeInterface = pInterface;

    m_pDVDAuthor->updateSourceFileInfo ( pInfo );
  }
}

void DialogConvert::convert ( DVDMenu *pDVDMenu, bool bConvertToPAL )
{
  Utils  theUtil;
  int    iFormat;
  uint   t;
  double fXRatio, fYRatio;
  CDVDMenuInterface *pInterface = pDVDMenu->getInterface ( );
  pInterface->iStretchType = CDVDMenuInterface::StretchToFit;
  // NTSC 720x480 / 704x480 / 352x480 / 352x240 (29.97 Hz )
  // #defined in global.h as FORMAT_NTSC1  / FORMAT_NTSC2 / FORMAT_NTSC3 / FORMAT_NTSC4
  // PAL  720x576 / 704x576 / 352x576 / 352x288 (25.00 Hz ) 
  // #defined in global.h as FORMAT_PAL1  / FORMAT_PAL2 / FORMAT_PAL3 / FORMAT_PAL4
  iFormat = theUtil.getFormat ( pInterface->iWidth, pInterface->iHeight );
  // If the format is PAL already and the request is to be PAL, don't do nothing
  if ( ( iFormat >= FORMAT_PAL1 ) && ( bConvertToPAL ) )
    return;
  else if ( ( iFormat <= FORMAT_NTSC4 ) && ( !bConvertToPAL ) )
    return;

  fXRatio = 1.0;
  fYRatio = 1.0;
  if ( pInterface->iFormat == FORMAT_NONE ) {
    fXRatio = pInterface->iWidth / 720.0;
    pInterface->iWidth = 720;
    if ( bConvertToPAL ) {
      fYRatio = pInterface->iHeight / 576.0;
      pInterface->iFormat = FORMAT_PAL1;
      pInterface->iHeight = 576;
    }
    else {
      fYRatio = pInterface->iHeight / 480.0;
      pInterface->iFormat = FORMAT_NTSC1;
      pInterface->iHeight = 480;
    }
  }
  else { // this will convert e.g. PAL1 into NTSC1 and vice versa.
    if ( bConvertToPAL )
      pInterface->iFormat += 4;
    else
      pInterface->iFormat -= 4;
  }
  if ( pInterface->iFormat == FORMAT_NTSC4 ) {
    pInterface->iHeight = 240;
    fYRatio = 240.0 / 288.0;
  }
  else if ( pInterface->iFormat < FORMAT_NTSC4 ) {
    pInterface->iHeight = 480;
    fYRatio = 480.0 / 576.0;
  }
  else if ( pInterface->iFormat == FORMAT_PAL4 ) {
    pInterface->iHeight = 288;
    fYRatio = 288.0 / 240.0;
  }
  else if ( pInterface->iFormat >= FORMAT_PAL1 ) {
    pInterface->iHeight = 576;
    fYRatio = 576.0 / 480.0;
  }

  //  pInterface->qsResizeAlgo = QString ( QT_RESIZE_ALGO );
  MenuPreview *pPreview = pDVDMenu->getMenuPreview ( );
  MenuObject  *pObject  = NULL;
  for ( t=0; t<pPreview->objectCount ( ); t++ ) {
    pObject = pPreview->menuObject ( t );
    if ( ! pObject )
      continue;
    convert ( pObject, fXRatio, fYRatio );
  }

  pDVDMenu->updateDVDMenu ( );
}

void DialogConvert::convert ( MenuObject *pObject, double fXRatio, double fYRatio )
{
  if ( ! pObject )
    return;

  QRect newRect, theRect   =  pObject->rect  ( );
  newRect.setLeft   ( (int) ( theRect.left   ( ) * fXRatio ) );
  newRect.setTop    ( (int) ( theRect.top    ( ) * fYRatio ) );
  newRect.setWidth  ( (int) ( theRect.width  ( ) * fXRatio ) );
  newRect.setHeight ( (int) ( theRect.height ( ) * fYRatio ) );

  pObject->setRect ( newRect );
  updateObject ( pObject );
}

void DialogConvert::updateObject ( MenuObject *pObject )
{
  ImageObject  tempImage;
  MovieObject  tempMovie;
  ButtonObject tempButton;

  //  pObject->update  ( );
  if ( ( pObject->objectType ( ) == tempImage.objectType ( ) ) ||
       ( pObject->objectType ( ) == tempMovie.objectType ( ) ) ) {
    ImageObject *pImage = (ImageObject *)pObject;
    pImage->updatePixmap ( );
  }
  else if ( pObject->objectType ( ) == tempButton.objectType ( ) ) {
    uint t;
    ButtonObject *pButton = (ButtonObject *)pObject;
    for ( t=0; t<pButton->getNormalCount ( ); t++ ) 
      updateObject ( pButton->getNormal ( t ) );
    for ( t=0; t<pButton->getSelectedCount ( ); t++ ) 
      updateObject ( pButton->getSelected ( t ) );
    for ( t=0; t<pButton->getHighlightedCount ( ); t++ ) 
      updateObject ( pButton->getHighlighted ( t ) );
  }
  pObject->updateShadow ( );
}

bool DialogConvert::isPal ( SourceFileInfo *pInfo )
{
  if ( pInfo->qsVideoFormat.lower ( ) == QString ( "pal" ) )
    return true;
  return false;
}
