/****************************************************************************
** DVDMenuUndoObject - code
** Created: Thursday Jan 2'nd 2003
** Varol Okan
****************************************************************************/

#include <qpixmap.h>

#include "sourcefileentry.h"
#include "dvdmenuundoobject.h"
#include "dvdmenu.h"
#include "menuobject.h"
#include "menupreview.h"

DVDMenuUndoObject::DVDMenuUndoObject()
{
	initMe ();
}

DVDMenuUndoObject::DVDMenuUndoObject(enUndoType type, MenuObject *pMenuObject)
{
	initMe ();
	m_enUndoType = (int)type;
	m_pMenuObject = pMenuObject;
	switch (m_enUndoType)	{
	case MOVED_OBJECT :
		m_rectPos = pMenuObject->rect();
	break;
	}
}

DVDMenuUndoObject::DVDMenuUndoObject(enUndoType type, QPixmap &theOldBackground, CDVDMenuInterface *pInterface)
{
	initMe();
	if (type != NEW_BACKGROUND)
		return;
	m_enUndoType = (int)type;
	m_backgroundInfo.background = theOldBackground;
	m_backgroundInfo.getBackgroundInfo( pInterface );
}

DVDMenuUndoObject::DVDMenuUndoObject(enUndoType type, SourceFileEntry *pSourceFileEntry)
{
	initMe();
	if (type != NEW_AUDIO)
		return;
	m_enUndoType = (int)type;
	m_pSourceFileEntry = pSourceFileEntry;
}

DVDMenuUndoObject::~DVDMenuUndoObject()
{
	// Okay if we have a m_pMenuObject and this UndoObject is to be deleted 
	// then we want to delete the m_pMenuObject only if this UndoObject is deleted while 
	// the UndoBuffer::redoBuffer is emptied 
	// BUT NOT when the UndoObject is deleted due to the MAX_UNDO_BUFFER is reached.
	if (m_bDeleteObject && m_pMenuObject)
		delete m_pMenuObject;
	if (m_bDeleteObject && m_pSourceFileEntry)
		delete m_pSourceFileEntry;
}

void DVDMenuUndoObject::initMe ()
{
	m_enUndoType        = (int)UNDEFINED;
	m_pMenuObject       = NULL;
	m_pSourceFileEntry  = NULL;
	m_bDeleteObject     = false;
}

DVDMenuUndoObject::BackgroundInfo::BackgroundInfo ( )
{
	bModified = false;
	bMovieBackgroundHasSound = false;
	iFormat = 0;
	iHeight = 0;
	iWidth  = 0;
	iStretchType = -1;
}

QString
DVDMenuUndoObject::getTypeString ()
{
//enum enUndoType {UNDEFINED = 0, DRAGGED_TEXT, DRAGGED_IMAGE, DRAGGED_BUTTON, MOVED_OBJECT, NEW_BACKGROUND};
	QString qsType;
	switch (m_enUndoType)	{
	case DRAGGED_TEXT :
		qsType = QObject::tr("New Text");
	break;
	case DRAGGED_IMAGE :
		qsType = QObject::tr("New Image");
	break;
	case DRAGGED_MOVIE :
		qsType = QObject::tr("New Clip");
	break;
	case DRAGGED_BUTTON :
		qsType = QObject::tr("New Button");
	break;
	case MOVED_OBJECT :
		qsType = QObject::tr("Move");
	break;
	case NEW_BACKGROUND :
		qsType = QObject::tr("New Background");
	break;
	case NEW_AUDIO :
		qsType = QObject::tr("New Sound");
	break;
	default:
		qsType = QObject::tr("Undefined");
	}
	return qsType;
}

// Here is the code, to restore the previous configuration.
void
DVDMenuUndoObject::undo(DVDMenu *pDVDMenu)
{
	QRect rectPos;
	QPixmap tempPix;
	BackgroundInfo tempInfo;
	CDVDMenuInterface *pInterface = NULL;

	switch (m_enUndoType)	{
	case DRAGGED_IMAGE  :
	case DRAGGED_MOVIE  :
	case DRAGGED_TEXT   :
	case DRAGGED_BUTTON :
		pDVDMenu->getMenuPreview()->removeObject(m_pMenuObject);
		m_bDeleteObject = true;
	break;
	case MOVED_OBJECT   :
		rectPos = m_pMenuObject->rect();
		m_pMenuObject->setRect(m_rectPos);
		m_rectPos = rectPos;
	break;
	case NEW_BACKGROUND :
		// First we change the Pixmap
		tempPix = *pDVDMenu->getMenuPreview()->paletteBackgroundPixmap ();
		pDVDMenu->getMenuPreview()->setPixmap (m_backgroundInfo.background);
		// STore the prvious Pixmap
		m_backgroundInfo.background = tempPix;
		// Next we get additional information
		pInterface = pDVDMenu->getInterface();
		tempInfo.getBackgroundInfo(pInterface);
		m_backgroundInfo.setBackgroundInfo(pInterface);
		m_backgroundInfo = tempInfo;
		pDVDMenu->getMenuPreview()->resize(720, 480);
		pDVDMenu->getMenuPreview()->setFixedSize(720, 480);
		pDVDMenu->updateDVDMenu();
	break;
	case NEW_AUDIO :
		// We remove the SourceFileEntry from the list and from the SourceToolBar
		pDVDMenu->removeSourceFileEntry (m_pSourceFileEntry);
 		// last we mark the entry for deletion if this undo-object gets deleted.
		m_bDeleteObject = true;
	break;
	};	// End of the switch loop.
	pDVDMenu->refresh();
}

void
DVDMenuUndoObject::redo(DVDMenu *pDVDMenu)
{
	QRect rectPos;
	QPixmap tempPix;
	BackgroundInfo tempInfo;
	CDVDMenuInterface *pInterface = NULL;

	switch (m_enUndoType)	{
	case DRAGGED_IMAGE  :
	case DRAGGED_MOVIE  :
	case DRAGGED_TEXT   :
	case DRAGGED_BUTTON :
		// inserted dragged text, image or button ... All's the smae !
		pDVDMenu->getMenuPreview()->addMenuObject (m_pMenuObject);
		m_bDeleteObject = false;
	break;
	case MOVED_OBJECT   :
		rectPos = m_pMenuObject->rect();
		m_pMenuObject->setRect(m_rectPos);
		m_rectPos = rectPos;
	break;
	case NEW_BACKGROUND :
		// First we change the Pixmap
		tempPix = *pDVDMenu->getMenuPreview()->paletteBackgroundPixmap ();
		pDVDMenu->getMenuPreview()->setPixmap (m_backgroundInfo.background);
		// STore the prvious Pixmap
		m_backgroundInfo.background = tempPix;
		// Next we get additional information
		pInterface = pDVDMenu->getInterface();
		tempInfo.getBackgroundInfo(pInterface);
		m_backgroundInfo.setBackgroundInfo(pInterface);
		m_backgroundInfo = tempInfo;
		pDVDMenu->getMenuPreview()->resize(720, 480);
		pDVDMenu->getMenuPreview()->setFixedSize(720, 480);
		pDVDMenu->updateDVDMenu();
	break;
	case NEW_AUDIO :
		pDVDMenu->appendSourceFileEntry(m_pSourceFileEntry);
 		// last we make sure the entry is preserved when the UndoObject is deleted
		m_bDeleteObject = false;
	break;
	};	// End of the switch loop.
	pDVDMenu->refresh();
}

MenuObject *
DVDMenuUndoObject::getMenuObject ()
{
	return m_pMenuObject;
}

// This function is called after a MouseRelease event in the BUttonPreview class
// It'll check if the object was moved or not.
bool
DVDMenuUndoObject::hasMoved ()
{
	if (!m_pMenuObject)
		return false;
	if ( (m_pMenuObject->rect().x() != m_rectPos.x()) || (m_pMenuObject->rect().y() != m_rectPos.y()) )
		return true;
	return false;
}

DVDMenuUndoObject::BackgroundInfo &
DVDMenuUndoObject::BackgroundInfo::operator = (DVDMenuUndoObject::BackgroundInfo &theOther)
{
//	QPixmap background;
	bModified                = theOther.bModified;
	// the following entries belong to the movie background
	qsMovieFileName          = theOther.qsMovieFileName;
	bMovieBackgroundHasSound = theOther.bMovieBackgroundHasSound;
	timeOffset               = theOther.timeOffset;
	timeDuration             = theOther.timeDuration;
	// The following var is the background image or screenshot of themovie ...
	qsBackgroundFileName     = theOther.qsBackgroundFileName;
	qsResizeAlgo             = theOther.qsResizeAlgo;
	iStretchType             = theOther.iStretchType;	// StretchToFit, BlackBorders, CutOffset
	posOffset                = theOther.posOffset;
	iFormat                  = theOther.iFormat;
	iWidth                   = theOther.iWidth;
	iHeight                  = theOther.iHeight;
	return *this;
}

void
DVDMenuUndoObject::BackgroundInfo::getBackgroundInfo (CDVDMenuInterface *pInterface)
{
	qsBackgroundFileName     = pInterface->qsBackgroundFileName;
	bModified                = pInterface->bModified;
	// the following entries belong to the movie background
	qsMovieFileName          = pInterface->qsMovieFileName;
	bMovieBackgroundHasSound = pInterface->bMovieBackgroundHasSound;
	timeOffset               = pInterface->timeOffset;
	timeDuration             = pInterface->timeDuration;
	// The following var is the background image or screenshot of themovie ...
	qsBackgroundFileName     = pInterface->qsBackgroundFileName;
	qsResizeAlgo             = pInterface->qsResizeAlgo;
	iStretchType             = pInterface->iStretchType;	// StretchToFit, BlackBorders, CutOffset
	posOffset                = pInterface->posOffset;
	iFormat                  = pInterface->iFormat;
	iWidth                   = pInterface->iWidth;
	iHeight                  = pInterface->iHeight;
}

void
DVDMenuUndoObject::BackgroundInfo::setBackgroundInfo (CDVDMenuInterface *pInterface)
{
	pInterface->qsBackgroundFileName     = qsBackgroundFileName;
	pInterface->bModified                = bModified;
	// the following entries belong to the movie background
	pInterface->qsMovieFileName          = qsMovieFileName;
	pInterface->bMovieBackgroundHasSound = bMovieBackgroundHasSound;
	pInterface->timeOffset               = timeOffset;
	pInterface->timeDuration             = timeDuration;
	// The following var is the background image or screenshot of themovie ...
	pInterface->qsBackgroundFileName     = qsBackgroundFileName;
	pInterface->qsResizeAlgo             = qsResizeAlgo;
	pInterface->iStretchType             = iStretchType;	// StretchToFit, BlackBorders, CutOffset
	pInterface->posOffset                = posOffset;
	pInterface->iFormat                  = iFormat;
	pInterface->iWidth                   = iWidth;
	pInterface->iHeight                  = iHeight;
}



