
#ifndef UTILS_H
#define UTILS_H

#include <qvaluelist.h>
#include <qstringlist.h>
#include <qcolor.h>

class Utils
{

public:
  enum enDefaultParameter {
    toolameSampleRate = 0,
    ppmtoy4mChroma,
    defaultParameterCount
  };
	// Structure to store the paths to the different tools.
	struct toolsPaths {
		toolsPaths ()	{ bPresent = false; };
//		toolsPaths &operator = (toolsPaths &theOther)
//		{
//			qsExecutableName = theOther.qsExecutableName;
//			qsFullPath  = theOther.qsFullPath;
//			bPresent = theOther.bPresent;
//			return *this;
//		}
		QString qsExecutableName; 
		QString qsFullPath; 
		bool bPresent;
	};

	 Utils ();
	~Utils ();

	QString currentStyleName     ( );
	QString formatChapter        ( QString );
	QString longToNorm           ( long );
	long    normToLong           ( QString );
	QString getAttribute         ( QString, QString);
	bool    recRmdir ( const QString &, const char *p=NULL) const;
	bool    recMkdir ( const QString & );
	QString iso639   ( QString, bool b=false, int i=-1 );
	QString checkForExe          ( QString );
	QString getToolsDisplayName  ( QString );
	int getIndexFromToolName     ( QString );
	QString getTempFile          ( QString );
	QString getTempPath          ( QString );
	QStringList getProjectsFromTempPath  ( );
	QString getUniqueTempFile    ( QString );
	QString getToolPath          ( QString );
	QString getToolByIndex       ( uint );
	bool    isMandatory          ( uint );
	QValueList<Utils::toolsPaths *> scanSystem ( );
	QRgb    nearestColor         ( QRgb *, int, QRgb );
	void    reduceColors         ( QImage &, int, QRgb * );
	long    countColors          ( QImage &  );

	QImage  convertStringToImage ( QString & );
	QString convertImageToString ( QImage  & );
	QString getVideoFormat       ( int,  int );
	int     getFormat            ( int,  int );

	long    getMsFromString      ( QString       );
	QString getStringFromMs      ( long          );
	int     getWHFromResolution  ( QString, bool );
	bool    isMpeg2              ( QString       );
	bool    hasVobus             ( QString       );
	bool    checkCommand         ( const char *  );
	QString getDefaultParameter  ( enDefaultParameter );
};

#endif  // UTILS_H
