/****************************************************************************
** Interface to the GUI.
**
**   Created : Wed March 16 22:48:00 2005
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
**
****************************************************************************/

#ifndef DIALOGMOVIE_H
#define DIALOGMOVIE_H

#include <qlistview.h>

#include "sourcefileentry.h"
#include "uidialogmovie.h"

class MovieObject;
class DVDMenu;
class QDVDAuthor;
class MediaInterface;
class StartStopControl;

class ListViewColorItem : public QListViewItem
{
public:
  ListViewColorItem (QListView *, Rgba, QString, QString l2=QString::null, QString l3=QString::null, QString l4=QString::null,
		     QString l5=QString::null, QString l6=QString::null, QString l7=QString::null, QString l8=QString::null);

  virtual void paintCell ( QPainter *, const QColorGroup &, int, int, int );
private:
  Rgba m_theColor;
};

class DialogMovie : public uiDialogMovie
{
	Q_OBJECT
public:
	 DialogMovie(QWidget *p=NULL, const char *n=NULL, WFlags f=0);
	~DialogMovie();

	void initMe(SourceFileInfo  *, const void *, QDVDAuthor * );
	void initMe(SourceFileEntry *);
	void initMe(MovieObject     *);
	void initMe(DVDMenu         *);

	bool transcodeEnabled ( );
	void initTranscodeTab ( );
	
	SourceFileInfo *sourceFileInfo ( );

protected slots:
	virtual void timerEvent       ( QTimerEvent * );
	virtual void slotNewVolume    ( int );
	virtual void accept           ( );
	virtual void slotBlink        ( );
	virtual void slotWidth        ( );
	virtual void slotHeight       ( );
	virtual void slotPlay         ( );
	virtual void slotStop         ( );
	virtual void slotSetThumbnail ( );
	virtual void slotStart        ( );
	virtual void slotEnd          ( );
	virtual void slotTranscode    ( );
	virtual void slotEncodeNow    ( );

	virtual void slotImportChapter( );
	virtual void slotAddChapter   ( );
	virtual void slotDelChapters  ( );
	virtual void slotAutoChapters ( );
	virtual void slotAnimation    ( );
	virtual void slotSizeDialog   ( );
	virtual void slotEditMediaInfo( );
	virtual void slotCurrentChanged ( QListBoxItem *);
	
	virtual void slotNewPosition    ( int, const QString &);
	virtual void slotSliderValues   ( float, float );
	virtual void slotSliderReleased ( bool );

	virtual void slotVideoOutChanged        (const QString &);
	virtual void slotVideoResolutionChanged (const QString &);
	virtual void slotVideoRateChanged       (const QString &);
	virtual void slotVideoTypeChanged       (const QString &);
	virtual void slotVideoAspectChanged     (const QString &);
	virtual void slotVideoBitrateChanged    (const QString &);
	virtual void slotAudioOutChanged        (const QString &);
	virtual void slotAudioTypeChanged       (const QString &);
	virtual void slotAudioBitrateChanged    (const QString &);

	virtual void slotSetStartStop       ( );
	virtual void slotSetMediaInfo       ( );
	virtual void slotInitMediaInterface ( );
	virtual void slotSameAsMenuLength   ( );
	virtual void slotCheckStart         ( );
	virtual void slotCheckEnd           ( );
	virtual void slotLoop               ( );

	virtual void slotAddColorKey    ( );
	virtual void slotDelColorKey    ( );
	virtual void slotBrowseColorKey ( );
	
	virtual void slotAddAudio       ( );
	virtual void slotEditAudio      ( );
	virtual void slotDeleteAudio    ( );
	virtual void slotAddSubtitle    ( );
	virtual void slotEditSubtitle   ( );
	virtual void slotDeleteSubtitle ( );
	virtual void slotAudioSelectionChanged    ( QListViewItem * );
	virtual void slotSubtitleSelectionChanged ( QListViewItem * );

	virtual void slotSetSelectedItem( );
	virtual void slotSubLangChanged ( bool );

signals:
	void signalSetThumbnail ( long );

private:
	QString keepClean   ( const QString  & );
	void setStartStop   ( bool             );
	void addChapter     ( QString &        );
	void initMediaInterface ( DVDMenu    * );
	void initAudioTab   ( SourceFileInfo *, DVDMenu *p=NULL );
	bool sanityCheckSubtitleTrack( int   & );
	void addSubtitle    ( QString, int, QValueList<Subtitles::entry *> & );
	bool subtitleDialog ( int &, QString & );
	void deleteSubtitle ( int );
	QTime maxEndTime    (     );
	QTime duration      (     );
	TranscodeInterface *checkRightAudioFormat ( QString & );

private:
	QRect             m_rectGeometry;
	QString           m_qsFileName;
	QString           m_qsPosition;
	int               m_iMovieLength;
	QWidget          *m_pTranscodeTab;
	QListViewItem    *m_pSelectItem;
	MediaInterface   *m_pMediaInterface;	
	StartStopControl *m_pStartStopControl;
	SourceFileInfo    m_sourceFileInfo;
	SourceFileEntry  *m_pParentSourceFileEntry;
	MovieObject      *m_pMovieObject;
	DVDMenu          *m_pDVDMenu;

	// the following is only used for the initializaion part
	const void       *m_pExistingEngine;
};

#endif // DIALOGMOVIE_H
