#!/bin/bash

# First we check if we are in the qrender directory
curDir=`pwd`
curDir=`echo $curDir | sed s/qrender$//g`

if [ x"$curDir" == x"`pwd`" ];
then
  echo; echo
  echo "    Your current directory is "`pwd`
  echo "    Please execute this script in the"
  echo "    qrender sub directory of QDVDAuthor"
  echo; echo
  exit -1
fi;

echo
echo "This script will pull the latest ffmpeg version off of :"
echo "http://ffmpeg.mplayerhq.hu/ffmpeg-export-snapshot.tar.bz2"

if [ x"`whoami`" == "xvokan" -o x`whoami` == "xvarol" ];
then
  echo avoid build local_ffmpeg at `date` > /tmp/local_ffmpeg
  qmake 
  make 
  exit
fi;

# Check if the file exists ...
if [ -e ffmpeg-export-snapshot.tar.bz2 ];
then
  rm ffmpeg-export-snapshot.tar.bz2
fi;
res=`wget --spider http://ffmpeg.mplayerhq.hu/ffmpeg-export-snapshot.tar.bz2 2>&1 | grep "200 OK"`

if [ "x$res" == "x" ];
then
  # Not found, lets try to use svn to DL the source
  svn checkout svn://svn.mplayerhq.hu/ffmpeg/trunk ffmpeg
  if [ ! -d ffmpeg ];
  then
    echo "Could not download ffmpeg. Please try to manually install it"
    echo "on your system and if needed set the FFMPEG environment"
    echo "variable before compiling qrender"
    exit -1
  fi;
else
  # The tar file exists ...
  wget http://ffmpeg.mplayerhq.hu/ffmpeg-export-snapshot.tar.bz2
  bzip2 -d ffmpeg-export-snapshot.tar.bz2
  extractDir=`tar --list -f ffmpeg-export-snapshot.tar | grep INSTALL | sed "s/\\/INSTALL$//"`
  tar -xf ffmpeg-export-snapshot.tar
  if [ -e ffmpeg ]; then
    rm ffmpeg
  fi;
  ln -s "$extractDir" ffmpeg
fi;

cd ffmpeg
#./configure --prefix=/home/varol/utils/ffmpeg --enable-gpl --enable-nonfree --enable-shared --enable-static
./configure --prefix="`pwd`" --enable-gpl --enable-swscale --enable-static --enable-shared

make && make install

# At this point the static libraries should have been built

# one last thing to do is to copy the header files to the include/ffmpeg directory
cd include
mkdir ffmpeg
cp `find . -name "*.h"` ffmpeg/

# and lastly we should clean qrender and re-build it
cd ../..
make clean 

qmake

make 

