/* === C R E D I T S  &  D I S C L A I M E R S ==============
 * Permission is given by the author to freely redistribute and include
 * this code in any program as long as this credit is given where due.
 *
 * CQuantizer (c)  1996-1997 Jeff Prosise
 *
 * 31/08/2003 Davide Pizzolato - www.xdp.it
 * - fixed minor bug in ProcessImage when bpp<=8
 * - better color reduction to less than 16 colors
 *
 * COVERED CODE IS PROVIDED UNDER THIS LICENSE ON AN "AS IS" BASIS, WITHOUT WARRANTY
 * OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * THAT THE COVERED CODE IS FREE OF DEFECTS, MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGING. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE COVERED
 * CODE IS WITH YOU. SHOULD ANY COVERED CODE PROVE DEFECTIVE IN ANY RESPECT, YOU (NOT
 * THE INITIAL DEVELOPER OR ANY OTHER CONTRIBUTOR) ASSUME THE COST OF ANY NECESSARY
 * SERVICING, REPAIR OR CORRECTION. THIS DISCLAIMER OF WARRANTY CONSTITUTES AN ESSENTIAL
 * PART OF THIS LICENSE. NO USE OF ANY COVERED CODE IS AUTHORIZED HEREUNDER EXCEPT UNDER
 * THIS DISCLAIMER.
 *
 * Use at your own risk!
 *
 * Adopted to Qt's QImage by Varol Okan 09/07/2004
 * ==========================================================
 */
 
//#include <stdio.h>
//#include <stdlib.h>

#include <qimage.h>
 
#ifndef BYTE
#define BYTE unsigned char
#endif

class CQuantizer
{
typedef struct _NODE {
    bool bIsLeaf;               // TRUE if node has no children
    uint nPixelCount;           // Number of pixels represented by this leaf
    uint nRedSum;               // Sum of red components
    uint nGreenSum;             // Sum of green components
    uint nBlueSum;              // Sum of blue components
    uint nAlphaSum;             // Sum of alpha components
    struct _NODE* pChild[8];    // Pointers to child nodes
    struct _NODE* pNext;        // Pointer to next reducible node
} NODE;
protected:
    NODE* m_pTree;
    uint m_nLeafCount;
    NODE* m_pReducibleNodes[9];
    uint m_nMaxColors;
    uint m_nOutputMaxColors;
    uint m_nColorBits;

public:
    CQuantizer (uint nMaxColors, uint nColorBits);
    virtual ~CQuantizer ();
//    bool ProcessImage (HANDLE hImage);
    bool ProcessImage (QImage &);
    uint GetColorCount ();
//    void SetColorTable (RGBQUAD* prgb);
    void SetColorTable (QColor* prgb);

protected:
    void AddColor (NODE** ppNode, BYTE r, BYTE g, BYTE b, BYTE a, uint nColorBits,
        uint nLevel, uint* pLeafCount, NODE** pReducibleNodes);
    void* CreateNode (uint nLevel, uint nColorBits, uint* pLeafCount,
        NODE** pReducibleNodes);
    void ReduceTree (uint nColorBits, uint* pLeafCount,
        NODE** pReducibleNodes);
    void DeleteTree (NODE** ppNode);
//    void GetPaletteColors (NODE* pTree, RGBQUAD* prgb, uint* pIndex, uint* pSum);
    void GetPaletteColors (NODE* pTree, QColor* prgb, uint* pIndex, uint* pSum);
	BYTE GetPixelIndex(long x,long y, int nbit, long effwdt, BYTE *pimage);
};

