/* 
 * Copyright (C) 1999-2002 Inter7 Internet Technologies, Inc. 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * 
 */
 
/* Known Bugs as of March 1, 2002

The -g and -o options don't stick when modifying a mailing list.

When modifying a mailing list, it's possible to end up with old symlinks
that qmailadmin doesn't delete:

   .qmail-<listname>-digest-return-default
   .qmail-<listname>-accept-default
   .qmail-<listname>-reject-default

Note that these bugs were present before Tom Collins beat this code with
a stick.  I cleaned a lot of stuff up, but there's still a lot of work to
be done.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <unistd.h>
#include <pwd.h>
#include <dirent.h>
#include "config.h"
#include "qmailadmin.h"
#include "qmailadminx.h"
#include <errno.h>

char dotqmail_name[MAX_FILE_NAME];
int dotnum;

int show_mailing_lists(char *user, char *dom, time_t mytime)
{
  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  /* see if there's anything to display */
  count_mailinglists();
   if ( CurMailingLists == 0 ) {
    sprintf(StatusMessage,"%s", get_html_text("231"));
    show_menu();
    vclose();
    exit(0);
  }

   if ( MaxMailingLists == 0 ) {
    return(0);
  }
  send_template( "show_mailinglist.html" );
}

int show_mailing_list_line(char *user, char* dom, time_t mytime, char *dir)
{
  DIR *mydir;
  struct dirent *mydirent;
  FILE *fs;
  char mailinglist_name[MAX_FILE_NAME];
  int i,j;

  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

   if ( MaxMailingLists == 0 ) {
    return(0);
  }

  if ( (mydir = opendir(".")) == NULL ) {
    fprintf(actout,"<tr><td>%s %d</tr><td>", get_html_text("143"), 1);
    return(0);
  }


  /* First display the title row */
  fprintf(actout, "<tr bgcolor=\"#cccccc\">");
#ifdef EZMLMIDX
  fprintf(actout, "<th align=left><font size=2>%s<br>%s</font></th>", get_html_text("081"), get_html_text("224"));
#else
  fprintf(actout, "<th align=left><font size=2>%s</font></th>", get_html_text("081"));
#endif
  fprintf(actout, "<th align=center><font size=2>%s</font></th>", get_html_text("072"));
  fprintf(actout, "<th align=center><font size=2>%s</font></th>", get_html_text("083"));
  fprintf(actout, "<th align=center><font size=2>%s</font></th>", get_html_text("084"));
  fprintf(actout, "<th align=center><font size=2>%s</font></th>", get_html_text("085"));
#ifdef EZMLMIDX
  fprintf(actout, "<th align=center><font size=2>%s</font></th>", get_html_text("086"));
  fprintf(actout, "<th align=center><font size=2>%s</font></th>", get_html_text("087"));
  fprintf(actout, "<th align=center><font size=2>%s</font></th>", get_html_text("088"));
  fprintf(actout, "<th align=center><font size=2>%s</font></th>", get_html_text("237"));
  fprintf(actout, "<th align=center><font size=2>%s</font></th>", get_html_text("238"));
  fprintf(actout, "<th align=center><font size=2>%s</font></th>", get_html_text("239"));
#endif
  fprintf(actout, "</tr>\n");
 

  /* Now, display each list */
  while( (mydirent=readdir(mydir)) != NULL ) {
    if ( strncmp(".qmail-", mydirent->d_name, 7) == 0 ) {
      if ( (fs=fopen(mydirent->d_name,"r"))==NULL) {
#ifdef EZMLMIDX
        fprintf(actout, "<tr><td colspan=\"8\">%s %s</td></tr>\n", get_html_text("144"), mydirent->d_name);
#else
        fprintf(actout, "<tr><td colspan=\"5\">%s %s</td></tr>\n", get_html_text("144"), mydirent->d_name);
#endif
        continue;
      }
      fgets( TmpBuf2, MAX_BUFF, fs);
      if ( strstr( TmpBuf2, "ezmlm-reject") != 0 ) {
        for(i=7,j=0;j<MAX_FILE_NAME-1&&mydirent->d_name[i]!=0;++i,++j) {
          mailinglist_name[j] = mydirent->d_name[i];
        }
        mailinglist_name[j] = 0;

                /* make dotqmail name */
                strcpy(dotqmail_name, mailinglist_name);
                for(dotnum=0;dotqmail_name[dotnum]!='\0';dotnum++) {
                    if(dotqmail_name[dotnum]==':') dotqmail_name[dotnum] = '.';
                }

        fprintf(actout,"<tr>");
#ifdef EZMLMIDX
        fprintf(actout, "<td align=left><a href=\"%s/com/modmailinglist?user=%s&dom=%s&time=%d&modu=%s\">%s@%s</a></td>\n", 
          CGIPATH,user,Domain,mytime,dotqmail_name,dotqmail_name,Domain); 
#else
        fprintf(actout,"<td align=left>%s@%s</td>\n", 
          dotqmail_name, Domain); 
#endif
        fprintf(actout, "<td align=center>");
        fprintf(actout, "<a href=\"%s/com/delmailinglist?user=%s&dom=%s&time=%d&modu=%s\">",
          CGIPATH,user,dom,mytime,dotqmail_name);
        fprintf(actout, "<img src=\"/images/qmailadmin/delete.png\" border=0></a>");
        fprintf(actout, "</td>\n");

        fprintf(actout, "<td align=center>");
        fprintf(actout, "<a href=\"%s/com/addlistuser?user=%s&dom=%s&time=%d&modu=%s\">",
          CGIPATH,user,dom,mytime,dotqmail_name);
        fprintf(actout, "<img src=\"/images/qmailadmin/delete.png\" border=0></a>");
        fprintf(actout, "</td>\n");

        fprintf(actout, "<td align=center><a href=\"%s/com/dellistuser?user=%s&dom=%s&time=%d&modu=%s\">",
          CGIPATH,user,dom,mytime,dotqmail_name);
        fprintf(actout, "<img src=\"/images/qmailadmin/delete.png\" border=0></a>");
        fprintf(actout, "</td>\n");

        fprintf(actout, "<td align=center>");
        fprintf(actout, "<a href=\"%s/com/showlistusers?user=%s&dom=%s&time=%d&modu=%s\">",
          CGIPATH,user,dom,mytime,dotqmail_name);
        fprintf(actout, "<img src=\"/images/qmailadmin/delete.png\" border=0></a>");
        fprintf(actout, "</td>\n");
#ifdef EZMLMIDX
        fprintf(actout, "<td align=center>");
        fprintf(actout, "<a href=\"%s/com/addlistmod?user=%s&dom=%s&time=%d&modu=%s\">",
          CGIPATH,user,dom,mytime,dotqmail_name);
        fprintf(actout, "<img src=\"/images/qmailadmin/delete.png\" border=0></a>");
        fprintf(actout, "</td>\n");

        fprintf(actout, "<td align=center>");
        fprintf(actout, "<a href=\"%s/com/dellistmod?user=%s&dom=%s&time=%d&modu=%s\">",
          CGIPATH,user,dom,mytime,dotqmail_name);
        fprintf(actout, "<img src=\"/images/qmailadmin/delete.png\" border=0></a>");
        fprintf(actout, "</td>\n");

        fprintf(actout, "<td align=center>");
        fprintf(actout, "<a href=\"%s/com/showlistmod?user=%s&dom=%s&time=%d&modu=%s\">",
          CGIPATH,user,dom,mytime,dotqmail_name);
        fprintf(actout, "<img src=\"/images/qmailadmin/delete.png\" border=0></a>");
        fprintf(actout, "</td>\n");
        fprintf(actout, "<td align=center>");
        fprintf(actout, "<a href=\"%s/com/addlistdig?user=%s&dom=%s&time=%d&modu=%s\">",
          CGIPATH,user,dom,mytime,dotqmail_name);
        fprintf(actout, "<img src=\"/images/qmailadmin/delete.png\" border=0></a>");
        fprintf(actout, "</td>\n");

        fprintf(actout, "<td align=center>");
        fprintf(actout, "<a href=\"%s/com/dellistdig?user=%s&dom=%s&time=%d&modu=%s\">",
          CGIPATH,user,dom,mytime,dotqmail_name);
        fprintf(actout, "<img src=\"/images/qmailadmin/delete.png\" border=0></a>");
        fprintf(actout, "</td>\n");

        fprintf(actout, "<td align=center>");
        fprintf(actout, "<a href=\"%s/com/showlistdig?user=%s&dom=%s&time=%d&modu=%s\">",
          CGIPATH,user,dom,mytime,dotqmail_name);
        fprintf(actout, "<img src=\"/images/qmailadmin/delete.png\" border=0></a>");
        fprintf(actout, "</td>\n");
#endif
        fprintf(actout, "</tr>\n");
      }
      fclose(fs);
    }
  }
  closedir(mydir);
}

int is_mailing_list(FILE *fs)
{
       while (!feof(fs)) {
               fgets( TmpBuf2, MAX_BUFF, fs);
               if ( strstr( TmpBuf2, "ezmlm-reject") != 0 ||
                    strstr( TmpBuf2, "ezmlm-send")   != 0 )
                       return -1;
       }
       return 0;
}

int show_mailing_list_line2(char *user, char *dom, time_t mytime, char *dir)
{
 DIR *mydir;
 struct dirent *mydirent;
 FILE *fs;
 char mailinglist_name[MAX_FILE_NAME];
 int i,j, cnt = 0;

  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

   if ( MaxMailingLists == 0 ) {
    return(0);
  }

    if ( (mydir = opendir(".")) != NULL){
    while( (mydirent = readdir(mydir)) != NULL)
      if( strncmp(".qmail-", mydirent->d_name, 7) == 0){
        if( (fs = fopen(mydirent->d_name, "r")) == NULL){
          fprintf(actout,"%s %s<br>\n", get_html_text("144"),
            mydirent->d_name);
          continue;
        }
        if (is_mailing_list(fs)) num_of_mailinglist++;
        fclose(fs);
      }
    closedir(mydir);
  }
  fprintf(actout, "<INPUT NAME=number_of_mailinglist TYPE=hidden VALUE=%d>\n", num_of_mailinglist);

  if ( (mydir = opendir(".")) == NULL ) {
    fprintf(actout,"%s %d<BR>\n", get_html_text("143"), 1);
    fprintf(actout,"</table>");
    return(0);
  }

    cnt = 0;
  while( (mydirent=readdir(mydir)) != NULL ) {
    if ( strncmp(".qmail-", mydirent->d_name, 7) == 0 ) {
      if ( (fs=fopen(mydirent->d_name,"r"))==NULL) {
        fprintf(actout,"%s %s<br>\n", get_html_text("144"),
          mydirent->d_name);
        continue;
      }
      fgets( TmpBuf2, MAX_BUFF, fs);
      if ( strstr( TmpBuf2, "ezmlm-reject") != 0 ) {

        for(i=7,j=0;j<MAX_FILE_NAME-1&&mydirent->d_name[i]!=0;++i,++j) {
          mailinglist_name[j] = mydirent->d_name[i];
        }
        mailinglist_name[j] = 0;

              fprintf(actout,"<TR><TD align=center>%s@%s</TD><TD \
align=center><INPUT NAME=\"subscribe%d\" TYPE=\"checkbox\" \
VALUE=%s></TD></TR>", mailinglist_name, Domain, cnt++, mailinglist_name); 
              
      }
      fclose(fs);
    }
  }
  closedir(mydir);

}


int addmailinglist(void)
{
  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  count_mailinglists();
  load_limits();
  if ( MaxMailingLists != -1 && CurMailingLists >= MaxMailingLists ) {
    fprintf(actout, "%s %d\n", get_html_text("184"), 
      MaxMailingLists);
    show_menu();
    vclose();
    exit(0);
  }
#ifdef EZMLMIDX
  send_template( "add_mailinglist-idx.html" );
#else
  send_template( "add_mailinglist-no-idx.html" );
#endif

}

int delmailinglist(void)
{
  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  send_template( "del_mailinglist_confirm.html" );
}

int delmailinglistnow(void)
{
 int pid;
 DIR *mydir;
 struct dirent *mydirent;

  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  if ( (mydir = opendir(".")) == NULL ) {
    fprintf(actout,"%s %d<BR>\n", get_html_text("143"), 1);
    fprintf(actout,"</table>");
    return 0;
  }
 
    /* make dotqmail name */
    strcpy(dotqmail_name, ActionUser);
    for(dotnum=0;dotqmail_name[dotnum]!='\0';dotnum++) {
        if(dotqmail_name[dotnum]=='.') dotqmail_name[dotnum] = ':';
    }

  sprintf(TmpBuf2, ".qmail-%s", dotqmail_name);
  sprintf(TmpBuf3, ".qmail-%s-", dotqmail_name);
  while( (mydirent=readdir(mydir)) != NULL ) {

    /* delete the main .qmail-"list" file */
    if ( strcmp(TmpBuf2, mydirent->d_name) == 0 ) {
      if ( unlink(mydirent->d_name) != 0 ) {
        ack(get_html_text("185"), TmpBuf2);
      }

    /* delete secondary .qmail-list"-* files */
    } else if ( strncmp(TmpBuf3, mydirent->d_name, strlen(TmpBuf3)) == 0 ) {
      if ( unlink(mydirent->d_name) != 0 ) {
        ack(get_html_text("185"), TmpBuf2);
      }
    }
  }
  closedir(mydir);


  sprintf(TmpBuf2, "%s/%s", RealDir, ActionUser);
  vdelfiles(TmpBuf2);

    count_mailinglists();
  sprintf(StatusMessage, "%s %s\n", get_html_text("186"), ActionUser);
    if ( CurMailingLists == 0 ) {
        show_menu();
    } else {
    show_mailing_lists(Username, Domain, Mytime);
  }

}


int addmailinglistnow(void)
{
  FILE * file;
  int pid;

#ifdef EZMLMIDX
  char list_owner[MAX_BUFF];
  char owneremail[MAX_BUFF+5];  
#endif
  char options[MAX_BUFF];
  char *arguments[MAX_BUFF];
  int i=0;
  char tmp[MAX_BUFF];
  char *tmpstr;
  char loop_ch[MAX_BUFF];
  int  loop;
  int  num_choices;

  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

        count_mailinglists();
        load_limits();
        if ( MaxMailingLists != -1 && CurMailingLists >= MaxMailingLists ) {
                fprintf(actout, "%s %d\n", get_html_text("184"),
                        MaxMailingLists);
                show_menu();
                vclose();
                exit(0);
        }

  if ( fixup_local_name(ActionUser) ) {
    sprintf(StatusMessage, "%s %s\n", get_html_text("188"), ActionUser);
    addmailinglist();
    vclose();
    exit(0);
  }
  if ( check_local_user(ActionUser) ) {
    sprintf(StatusMessage, "%s %s\n", get_html_text("175"), ActionUser);
    addmailinglist();
    vclose();
    exit(0);
  }


  memset(options, 0, MAX_BUFF);
  memset(loop_ch, 0, MAX_BUFF);

#ifdef EZMLMIDX
  /* check the list owner entry */
  GetValue(TmpCGI, list_owner, "listowner=", MAX_BUFF); 
  memset(owneremail, 0, MAX_BUFF);
  if ( strlen(list_owner) > 0 ) {
    strcpy( owneremail, "-5");
    strcat( owneremail, list_owner);
  }
#endif

#ifdef EZMLMIDX
  num_choices = NUM_EZMLM_IDX_CHOICES;
#else
  num_choices = NUM_EZMLM_NO_IDX_CHOICES;
#endif

  memset(options, 0, MAX_BUFF);
  for(loop = 0; loop < num_choices; loop++) {  
    sprintf(tmp, "param%d=", loop);
    memset(loop_ch, 0, MAX_BUFF);
    GetValue(TmpCGI, loop_ch, tmp, MAX_BUFF);

    if ( strlen(loop_ch) > 0 ) {
      strcat(options, loop_ch);
      strcat(options, " ");
    }
  }

#ifdef EZMLMIDX
  /* check for sql support */
  memset(tmp, 0, MAX_BUFF);
  GetValue(TmpCGI, tmp, "sqlsupport=", MAX_BUFF);
  if( strlen(tmp) > 0 ) {
    strcat(options, tmp);
    strcat(options, " ");
    for(loop = 0; loop < NUM_SQL_OPTIONS; loop++) {  
      sprintf(tmp, "sql%d=", loop+1);
      memset(loop_ch, 0, MAX_BUFF);
      GetValue(TmpCGI, loop_ch, tmp, MAX_BUFF);
      strcat(options, loop_ch);
          if(loop < NUM_SQL_OPTIONS - 1) strcat(options, ":");
    }
  }
#endif
  /* make dotqmail name */
  strcpy(dotqmail_name, ActionUser);
  for(dotnum=0;dotqmail_name[dotnum]!='\0';dotnum++) {
    if(dotqmail_name[dotnum]=='.') dotqmail_name[dotnum] = ':';
  }

  pid=fork();
  if (pid==0) {
    sprintf(TmpBuf1, "%s/ezmlm-make", EZMLMDIR);
    sprintf(TmpBuf2, "%s/%s", RealDir, ActionUser);

    sprintf(TmpBuf3, "%s/.qmail-%s", RealDir, dotqmail_name);
    i = 0;
    arguments[i++] = "ezmlm-make";

#ifdef EZMLMIDX
    if ( strlen(owneremail) > 0 ) arguments[i++]=owneremail;
#endif

    for(tmpstr=strtok(options," ");tmpstr!=NULL;tmpstr=strtok(NULL," ")){
      arguments[i++] = tmpstr;
    }
    arguments[i++]=TmpBuf2;
    arguments[i++]=TmpBuf3;
    arguments[i++]=ActionUser;
    arguments[i++]=Domain;
    arguments[i++]=NULL;

    execv(TmpBuf1, arguments);
    exit(127);
  } else {
    wait(&pid);
  }

  sprintf(TmpBuf, "%s/%s/inlocal",
    RealDir, ActionUser);

    file=fopen(TmpBuf , "w");
  fprintf(file, "%s-%s", Domain, ActionUser);
  fclose(file);

  sprintf(StatusMessage, "%s %s@%s\n", get_html_text("187"), 
    ActionUser, Domain);
  show_mailing_lists(Username, Domain, Mytime);

}

/* Comparison routine used in qsort for show_list_group_now */
static int compare_elements (const void *p1, const void *p2)
{
  return strcasecmp (*(char **)p1, *(char **)p2);
}

int show_list_group_now(int mod)
{
  /* mod = 0 for subscribers, 1 for moderators, 2 for digest users */
  
 FILE *fs;
 int i,handles[2],pid,a,x,y,z = 0,z1=1,index = 0,subuser_count = 0; 
 unsigned char *pa[100000];
 unsigned char *memblock[200];   /* 200 blocks of memory for email addresses */
 int memleft, memindex;
 char *p;

  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  lowerit(ActionUser);
  pipe(handles);

  pid=fork();
  if (pid==0) {
    close(handles[0]);
    dup2(handles[1],fileno(stdout));
    sprintf(TmpBuf1, "%s/ezmlm-list", EZMLMDIR);
    if(mod == 1) {
        sprintf(TmpBuf2, "%s/%s/mod", RealDir, ActionUser);
    } else if(mod == 2) {
        sprintf(TmpBuf2, "%s/%s/digest", RealDir, ActionUser);
    } else {
        sprintf(TmpBuf2, "%s/%s/", RealDir, ActionUser);
    }
    execl(TmpBuf1, "ezmlm-list", TmpBuf2, NULL);
    exit(127);
  } else {
                close(handles[1]);
    fs = fdopen(handles[0],"r");

                /* Load subscriber/moderator list */

    memindex = 0;
    memleft = 65536;  /* allocate blocks of 64k */
    p = memblock[memindex] = malloc(memleft);
    /* should do error checking for malloc failure */

    /* exits unceremoniously after 100,000 addresses 
     * (or size of pa array)
     * read addresses up to 254 characters (plus newline plus null = 256)
     */
                while( (index < (sizeof(pa)/sizeof(pa[0]))) && (fgets(p, 256, fs)!= NULL)) {
      pa[index] = p;
                        i = strlen(p);
      memleft -= i;
      p += i;
      *(p-1) = 0;   // convert newline to null
                        index++; subuser_count++;
      if (memleft < 256)
      {
        memindex++;
        // ** error check for memindex > size of memblock array
        memleft = 65536;
        p = memblock[memindex] = malloc(memleft);
        // ** should do error checking on malloc failure
      }
                }

                /* Sort the array alphabetically - future version will sort by domain also */
    qsort (pa, index, sizeof(pa[0]), compare_elements);

    /* Display subscriber/moderator/digest list, along with delete button */
    if(mod == 1) {
        strcpy(TmpBuf, "228"); strcpy(TmpBuf1, "087"); strcpy(TmpBuf2, "220");
    } else if(mod == 2) {
        strcpy(TmpBuf, "244"); strcpy(TmpBuf1, "245"); strcpy(TmpBuf2, "246");
    } else {
        strcpy(TmpBuf, "230"); strcpy(TmpBuf1, "222"); strcpy(TmpBuf2, "084");
    }
    fprintf(actout,"<TABLE border=0 width=\"100%%\">\n");
    fprintf(actout," <TR>\n");
    fprintf(actout,"  <TH align=left COLSPAN=4><B>%s</B> %d<BR><BR></TH>\n", get_html_text(TmpBuf), subuser_count);
    fprintf(actout," </TR>\n");
    fprintf(actout," <TR align=middle bgcolor=%s>\n", get_color_text("002"));
    fprintf(actout,"  <TH align=middle><b><font size=2>%s</font></b></TH>\n", get_html_text(TmpBuf1));
    fprintf(actout,"  <TH align=middle><b><font size=2>%s</font></b></TH>\n", get_html_text(TmpBuf2));
    fprintf(actout,"  <TH align=middle><b><font size=2>%s</font></b></TH>\n", get_html_text(TmpBuf1));
    fprintf(actout,"  <TH align=middle><b><font size=2>%s</font></b></TH>\n", get_html_text(TmpBuf2));
    fprintf(actout," </TR>\n");

    if(mod == 1) {
        strcpy(TmpBuf, "dellistmodnow");
    } else if(mod == 2) {
        strcpy(TmpBuf, "dellistdignow");
    } else {
        strcpy(TmpBuf, "dellistusernow");
    }
    for(z = 0; z < index; ++z) {
      fprintf(actout," <TR align=middle>");
      fprintf(actout,"  <TD align=middle><A href=%s/com/%s?modu=%s&newu=%s&dom=%s&user=%s&time=%d><IMG src=/images/qmailadmin/delete.png border=0></A></TD>\n",
        CGIPATH, TmpBuf, ActionUser, pa[z], Domain, Username, Mytime);
      fprintf(actout,"  <TD align=left>%s</TD>\n", pa[z]);
      ++z;
      if(pa[z] != NULL) {
        fprintf(actout,"  <TD align=middle><A href=%s/com/%s?modu=%s&newu=%s&dom=%s&user=%s&time=%d><IMG src=/images/qmailadmin/delete.png border=0></A></TD>\n",
          CGIPATH, TmpBuf, ActionUser, pa[z], Domain, Username, Mytime);
        fprintf(actout,"  <TD align=left>%s</TD>", pa[z]);
      } else {
        fprintf(actout,"  <TD COLSPAN=2> </TD>");
      }
      fprintf(actout," </TR>");
    }

    fprintf(actout,"</TABLE>");
    fclose(fs); close(handles[0]);
    wait(&pid);
    sprintf(StatusMessage, "%s\n", get_html_text("190"));
    fprintf(actout, get_html_text("END_LIST_NAMES"));

    // free up memory used by subscriber list
    while (memindex >= 0) { free (memblock[memindex--]); }
  }
}

int show_list_users(void)
{
  if (AdminType != DOMAIN_ADMIN) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }
  
  if (MaxMailingLists == 0) {
    return 0;
  }
  
  send_template("show_subscribers.html");
}

int show_list_digest_users(void)
{
  if (AdminType != DOMAIN_ADMIN) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }
  
  if (MaxMailingLists == 0) {
    return 0;
  }
  
  send_template("show_digest_subscribers.html");
}

int show_list_moderators()
{
  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }
  
  if ( MaxMailingLists == 0 ) {
    return(0);
  }
  
  send_template( "show_moderators.html" );
}

int show_list_users_now(void) { return show_list_group_now(0); }
int show_list_moderators_now(void) { return show_list_group_now(1); }
int show_list_digest_users_now(void) { return show_list_group_now(2); }

addlistuser()
{
  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }
  send_template( "add_listuser.html" );
}

addlistmod()
{
  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }
  send_template( "add_listmod.html" );
}

addlistdig()
{
  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }
  send_template( "add_listdig.html" );
}

addlistgroupnow (int mod)
{
  // mod = 0 for subscribers, 1 for moderators, 2 for digest subscribers

 int i, result;
 int pid;

  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  lowerit(ActionUser);

  if ( check_email_addr(Newu) ) {
    sprintf(StatusMessage, "%s %s\n", get_html_text("148"), Newu);
    if (mod == 1) {
      addlistmod();
    } else if (mod == 2) {
      addlistdig();
    } else {
      addlistuser();
    }
    vclose();
    exit(0);
  }

  pid=fork();
  if (pid==0) {
    sprintf(TmpBuf1, "%s/ezmlm-sub", EZMLMDIR);
    if(mod == 1) {
        sprintf(TmpBuf2, "%s/%s/mod", RealDir, ActionUser);
    } else if(mod == 2) {
        sprintf(TmpBuf2, "%s/%s/digest", RealDir, ActionUser);
    } else {
        sprintf(TmpBuf2, "%s/%s/", RealDir, ActionUser);
    }
    execl(TmpBuf1, "ezmlm-sub", TmpBuf2, Newu, NULL);
    exit(127);
  } else wait(&pid);

  if(mod == 1 ) {
    sprintf(StatusMessage, "%s %s %s@%s\n", Newu, 
        get_html_text("194"), ActionUser, Domain);
    send_template( "add_listmod.html" );
  } else if(mod == 2) {
    sprintf(StatusMessage, "%s %s %s@%s\n", Newu, 
        get_html_text("240"), ActionUser, Domain);
    send_template( "add_listdig.html" );
  } else {
    sprintf(StatusMessage, "%s %s %s@%s\n", Newu, 
        get_html_text("193"), ActionUser, Domain);
    send_template( "add_listuser.html" );
  }
  vclose();
  exit(0);
}

addlistusernow() { addlistgroupnow(0); }
addlistmodnow() { addlistgroupnow(1); }
addlistdignow() { addlistgroupnow(2); }

dellistuser()
{
  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  send_template( "del_listuser.html" );

}

dellistmod()
{

  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  send_template( "del_listmod.html" );

}

dellistdig()
{

  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  send_template( "del_listdig.html" );

}

dellistgroupnow(int mod)
{
 int i;
 int pid;

  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  lowerit(Newu);

  if ( check_email_addr(Newu) ) {
    sprintf(StatusMessage, "%s %s\n", get_html_text("148"), Newu);
    if (mod == 1) {
      dellistmod();
    } else if(mod == 2) {
      dellistdig();
    } else {
      dellistuser();
    }
    vclose();
    exit(0);
  }
  pid=fork();
  if (pid==0) {
    sprintf(TmpBuf1, "%s/ezmlm-unsub", EZMLMDIR);
    if(mod == 1) {
        sprintf(TmpBuf2, "%s/%s/mod", RealDir, ActionUser);
    } else if(mod == 2 ) {
        sprintf(TmpBuf2, "%s/%s/digest", RealDir, ActionUser);
    } else {
        sprintf(TmpBuf2, "%s/%s/", RealDir, ActionUser);
    }
    execl(TmpBuf1, "ezmlm-unsub", TmpBuf2, Newu, NULL);
    exit(127);
  } else wait(&pid);

  if(mod == 1) {
    sprintf(StatusMessage, "%s %s %s@%s\n", Newu, get_html_text("197"),
        ActionUser, Domain);
  } else if(mod == 2) {
    sprintf(StatusMessage, "%s %s %s@%s\n", Newu, get_html_text("242"),
        ActionUser, Domain);
  } else {
    sprintf(StatusMessage, "%s %s %s@%s\n", Newu, get_html_text("203"),
        ActionUser, Domain);
  }
  show_mailing_lists(Username, Domain, Mytime);
  vclose();
  exit(0);
}

dellistusernow() { dellistgroupnow(0); }
dellistmodnow() { dellistgroupnow(1); }
dellistdignow() { dellistgroupnow(2); }

count_mailinglists()
{
 DIR *mydir;
 struct dirent *mydirent;
 FILE *fs;

  if ( (mydir = opendir(".")) == NULL ) {
    fprintf(actout,"%s %d<BR>\n", get_html_text("143"), 1);
    fprintf(actout,"</table>");
    return(0);
  }
 

  CurMailingLists = 0;
  while( (mydirent=readdir(mydir)) != NULL ) {
    if ( strncmp(".qmail-", mydirent->d_name, 7) == 0 ) {
      if ( (fs=fopen(mydirent->d_name,"r"))==NULL) {
        fprintf(actout, get_html_text("FAIL_PERM_ERROR"), 
          mydirent->d_name);
        continue;
      }
      fgets( TmpBuf2, MAX_BUFF, fs);
      if ( strstr( TmpBuf2, "ezmlm-reject") != 0 ) {
        ++CurMailingLists;
      }
      fclose(fs);
    }
  }
  closedir(mydir);

}

modmailinglist()
{
 int i;
 FILE *fs;

  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  /* get the current listowner and copy it to Alias */
  sprintf(TmpBuf, ".qmail-%s-owner", ActionUser);
  if((fs=fopen(TmpBuf, "r"))!=NULL) {
    while(fgets(TmpBuf2, MAX_BUFF, fs)) {
      if(strstr(TmpBuf2, "@")!=NULL) {
        sprintf(Alias, "%s", TmpBuf2);
      }
    }
    fclose(fs);
    i = strlen(Alias); --i; Alias[i] = 0; /* take off newline */
  }

#ifdef EZMLMIDX
  send_template( "mod_mailinglist-idx.html" );
#else
  send_template( "show_mailinglists.html" );
#endif

}

modmailinglistnow()
{
  FILE * file;
  int pid;

#ifdef EZMLMIDX
  char list_owner[MAX_BUFF];
  char owneremail[MAX_BUFF+5];  
#endif
  char options[MAX_BUFF];
  char *arguments[MAX_BUFF];
  int i=0;
  char tmp[MAX_BUFF];
  char *tmpstr;
  char loop_ch[MAX_BUFF];
  int  loop;
  int  num_choices;

  if ( AdminType!=DOMAIN_ADMIN ) {
    sprintf(StatusMessage,"%s", get_html_text("142"));
    vclose();
    exit(0);
  }

  if ( fixup_local_name(ActionUser) ) {
    sprintf(StatusMessage, "%s %s\n", get_html_text("188"), ActionUser);
    addmailinglist();
    vclose();
    exit(0);
  }

  memset(options, 0, MAX_BUFF);
  memset(loop_ch, 0, MAX_BUFF);

#ifdef EZMLMIDX
  /* check the list owner entry */
  GetValue(TmpCGI, list_owner, "listowner=", MAX_BUFF); // Get the listowner
  memset(owneremail, 0, MAX_BUFF);
  if ( strlen(list_owner) > 0 ) {
    strcpy( owneremail, "-5");
    strcat( owneremail, list_owner);
  }
#endif

#ifdef EZMLMIDX
  num_choices = NUM_EZMLM_IDX_CHOICES;
#else
  num_choices = NUM_EZMLM_NO_IDX_CHOICES;
#endif

  memset(options, 0, MAX_BUFF);
  for(loop = 0; loop < num_choices; loop++) {  
    sprintf(tmp, "param%d=", loop);
    memset(loop_ch, 0, MAX_BUFF);
    GetValue(TmpCGI, loop_ch, tmp, MAX_BUFF);

    if ( strlen(loop_ch) > 0 ) {
      strcat(options, loop_ch);
      strcat(options, " ");
    }
  }

#ifdef EZMLMIDX
  /* check for sql support */
  memset(tmp, 0, MAX_BUFF);
  GetValue(TmpCGI, tmp, "sqlsupport=", MAX_BUFF);
  if( strlen(tmp) > 0 ) {
    strcat(options, tmp);
    strcat(options, " ");
    for(loop = 0; loop < NUM_SQL_OPTIONS; loop++) {  
      sprintf(tmp, "sql%d=", loop+1);
      memset(loop_ch, 0, MAX_BUFF);
      GetValue(TmpCGI, loop_ch, tmp, MAX_BUFF);
      strcat(options, loop_ch);
          if(loop < NUM_SQL_OPTIONS - 1) strcat(options, ":");
    }
  }
#endif

  pid=fork();
  if (pid==0) {
    sprintf(TmpBuf1, "%s/ezmlm-make", EZMLMDIR);
    sprintf(TmpBuf2, "%s/%s", RealDir, ActionUser);
        /* make dotqmail name */
        strcpy(dotqmail_name, ActionUser);
        for(dotnum=0;dotqmail_name[dotnum]!='\0';dotnum++) {
            if(dotqmail_name[dotnum]=='.') dotqmail_name[dotnum] = ':';
        }
    sprintf(TmpBuf3, "%s/.qmail-%s", RealDir, dotqmail_name);
    i = 0;
    arguments[i++] = "ezmlm-make";

#ifdef EZMLMIDX
    if ( strlen(owneremail) > 0 ) arguments[i++]=owneremail;
#endif

    for(tmpstr=strtok(options," ");tmpstr!=NULL;tmpstr=strtok(NULL," ")){
      arguments[i++] = tmpstr;
    }
    arguments[i++]=TmpBuf2;
    arguments[i++]=TmpBuf3;
    arguments[i++]=ActionUser;
    arguments[i++]=Domain;
    arguments[i++]=NULL;

    execv(TmpBuf1, arguments);
    exit(127);
  } else {
    wait(&pid);
    if(strstr(options, "-M") != NULL) {
      strcpy(TmpBuf2, "moderator");
      del_list_links(TmpBuf2);
    }
    if(strstr(options, "-D") != NULL) {
      strcpy(TmpBuf2, "digest");
      del_list_links(TmpBuf2);
    }
  }

  sprintf(TmpBuf, "%s/%s/inlocal",
    RealDir, ActionUser);

    file=fopen(TmpBuf , "w");
  fprintf(file, "%s-%s", Domain, ActionUser);
  fclose(file);

  sprintf(StatusMessage, "%s %s@%s\n", get_html_text("226"), 
    ActionUser, Domain);
  show_mailing_lists(Username, Domain, Mytime);

}

build_list_value(char *param, char *color, char *opt1, char *desc1, char *opt2, char *desc2, int checked)
{
  fprintf(actout, "<tr bgcolor=%s>\n", get_color_text(color));
  fprintf(actout, "  <td>\n");
  fprintf(actout, "    <input type=radio name=%s value=%s%s></td>\n", param, opt1, checked ? "" : " CHECKED");
  fprintf(actout, "  <td>%s</td>\n", get_html_text(desc1));
  fprintf(actout, "  <td>\n");
  fprintf(actout, "    <input type=radio name=%s value=%s%s></td>\n", param, opt2, checked ? " CHECKED" : "");
  fprintf(actout, "  <td>%s</td>\n", get_html_text(desc2));
  fprintf(actout, "</tr>\n");
}

int file_exists (char *filename)
{
  FILE *fs;
  if( (fs=fopen(filename, "r")) !=NULL ) {
    fclose(fs);
    return 1;
  } else {
    return 0;
  }
}

int get_ezmlmidx_line_arguments(char *line, char *program, char argument)
{
  char *begin; 
  char *end;
  char *arg;

  // does line contain program name?
  if ((strstr(line, program)) != NULL) {
    // find the options
    begin=strchr(line, ' ');
    begin++;
    if (*begin == '-') {
      end=strchr(begin, ' ');
      arg=strchr(begin, argument);
      // if arg is found && it's in the options (before the trailing space), return 1
      if (arg && (arg < end)) return 1;
    }       
  }       
  return 0;
}

show_current_list_values() {
 FILE *fs;
 int sqlfileok = 0;
 int usesql = 0;
 int i,j;
 char checked1[MAX_BUFF] = "";
 int checked;
 int checkopt[256];
   
  /* make dotqmail name */
  strcpy(dotqmail_name, ActionUser);
  for(dotnum=0;dotqmail_name[dotnum]!='\0';dotnum++) {
    if(dotqmail_name[dotnum]=='.') dotqmail_name[dotnum] = ':';
  }

  // set all checkopts to 1
  for (i = 0; i < 256; checkopt[i++] = 1);

  // figure out some options in the -default file
  sprintf(TmpBuf, ".qmail-%s-default", dotqmail_name);
  if( (fs=fopen(TmpBuf, "r")) !=NULL ) {
    while(fgets(TmpBuf2, MAX_BUFF, fs)) {
      if((get_ezmlmidx_line_arguments(TmpBuf2, "ezmlm-get", 'P')) > 0) {
        checkopt['b'] = 0;
      }
      if((get_ezmlmidx_line_arguments(TmpBuf2, "ezmlm-get", 's')) > 0) {
        checkopt['g'] = 0;
      }
      if((get_ezmlmidx_line_arguments(TmpBuf2, "ezmlm-manage", 'S')) > 0) {
        checkopt['h'] = 0;
      }
      if((get_ezmlmidx_line_arguments(TmpBuf2, "ezmlm-manage", 'U')) > 0) {
        checkopt['j'] = 0;
      }
      if((get_ezmlmidx_line_arguments(TmpBuf2, "ezmlm-manage", 'l')) > 0) {
        checkopt['l'] = 0;
      }
      if((get_ezmlmidx_line_arguments(TmpBuf2, "ezmlm-manage", 'e')) > 0) {
        checkopt['n'] = 0;
      }
      if((strstr(TmpBuf2, "ezmlm-request")) != 0) {
        checkopt['q'] = 0;
      }
    }
    fclose(fs);
  }

  // figure out some options in the -accept-default file
  sprintf(TmpBuf, ".qmail-%s-accept-default", dotqmail_name);
  if( (fs=fopen(TmpBuf, "r")) !=NULL ) {
    while(fgets(TmpBuf2, MAX_BUFF, fs)) {
      if(strstr(TmpBuf2, "ezmlm-archive") !=0) {
        checkopt['i'] = 0;
      }
    }
    fclose(fs);
  }

  // figure out some options in the qmail file
  sprintf(TmpBuf, ".qmail-%s", dotqmail_name);
  if( (fs=fopen(TmpBuf, "r")) !=NULL ) {
    while(fgets(TmpBuf2, MAX_BUFF, fs)) {
      if((get_ezmlmidx_line_arguments(TmpBuf2, "ezmlm-store", 'P')) > 0) {
        checkopt['o'] = 0;
      }
      if((strstr(TmpBuf2, "ezmlm-gate")) != 0 || (strstr(TmpBuf2, "ezmlm-issubn")) != 0) {
        checkopt['u'] = 0;
      }
    }
    fclose(fs);
  }

  /* See if it's moderated or not */
  sprintf(TmpBuf, ".qmail-%s-accept-default", dotqmail_name);
  build_list_value ("param0", "004", "-m", "035", "-M", "036", ! file_exists(TmpBuf));

  /* See if it's archived or not */
  sprintf(TmpBuf, "%s/archived", ActionUser);
  build_list_value ("param1", "000", "-a", "018", "-A", "019", ! file_exists(TmpBuf));

  /* See if it's blocked or not */
  build_list_value ("param2", "004", "-b", "020", "-B", "021", checkopt['b']);
  
  /* See if it's there's a digest or not */
  sprintf(TmpBuf, "%s/digest/bouncer", ActionUser);
  build_list_value ("param3", "000", "-d", "227", "-D", "022", ! file_exists(TmpBuf));

  /* See if a prefix is used */
  sprintf(TmpBuf, "%s/prefix", ActionUser);
  build_list_value ("param4", "004", "-f", "023", "-F", "024", ! file_exists(TmpBuf));

  /* See if the archive is guarded */
  build_list_value ("param5", "000", "-g", "025", "-G", "026", checkopt['g']);

  /* See if subscriptions require confirmation */
  build_list_value ("param6", "004", "-h", "027", "-H", "028", checkopt['h']);
  
  /* See if a WWW index is kept */
  build_list_value ("param7", "000", "-i", "029", "-I", "030", checkopt['i']);

  /* See if unsubscriptions require confirmation */
  build_list_value ("param8", "004", "-j", "031", "-J", "032", checkopt['j']);

  /* See if list administrators can get the subscriber list */
  build_list_value ("param9", "000", "-l", "033", "-L", "034", checkopt['l']);

  /* see if remote administrators may edit text files */
  build_list_value ("param10", "004", "-n", "041", "-N", "042", checkopt['n']);

  /* see if only moderators can post */
  build_list_value ("param11", "000", "-o", "037", "-O", "038", checkopt['o']);

  /* See if it's public or not */
  sprintf(TmpBuf, "%s/public", ActionUser);
  build_list_value ("param12", "004", "-p", "039", "-P", "040", ! file_exists(TmpBuf));

  /* see if Request address is serviced */
  build_list_value ("param13", "000", "-q", "043", "-Q", "044", checkopt['q']);

  /* See if remote administration is allowed */
  sprintf(TmpBuf, "%s/remote", ActionUser);
  build_list_value ("param14", "004", "-r", "045", "-R", "046", ! file_exists(TmpBuf));

  /* See if subscriptions are moderated */
  sprintf(TmpBuf, "%s/modsub", ActionUser);
  build_list_value ("param15", "000", "-s", "047", "-S", "048", ! file_exists(TmpBuf));

  /* See if there is a trailer */
  sprintf(TmpBuf, "%s/text/trailer", ActionUser);
  build_list_value ("param16", "004", "-t", "049", "-T", "050", ! file_exists(TmpBuf));

  /* see if list posts are restricted by sender address */
  build_list_value ("param17", "000", "-u", "051", "-U", "052", checkopt['u']);

  fprintf(actout, "<input type=hidden name=param18 value=-e>\n");
  
  fprintf(actout, "</table>\n");
  fprintf(actout, "  <hr>\n");
  fprintf(actout, "<table width=\"100%%\" cellpadding=1 cellspacing=0 border=0 bgcolor=%s><tr><td>\n", 
    get_color_text("001"));
  fprintf(actout, "<table width=\"100%%\" cellpadding=0 cellspacing=0 border=0>\n");

  /***********************/
  /* begin MySQL options */
  /***********************/

  /* See if sql is turned on */
  checked = 0;
  sprintf(TmpBuf, "%s/sql", ActionUser);
  if( (fs=fopen(TmpBuf, "r")) !=NULL ) {
    checked = 1;
    while(fgets(TmpBuf2, MAX_BUFF, fs)) {
      strcpy(TmpBuf1, TmpBuf2);
      i = strlen(TmpBuf1); --i; TmpBuf1[i] = 0; /* take off newline */
      if((strstr(TmpBuf1, ":")) != NULL) { 
        sqlfileok = 1;
      }
    }
    usesql = 1;
    fclose(fs);
  }
  fprintf(actout, "<tr>\n");
  fprintf(actout, "  <td bgcolor=%s>\n", get_color_text("004"));
  fprintf(actout, "    <input type=checkbox name=sqlsupport value=-6%s>", checked ? " CHECKED" : "");
  fprintf(actout, "%s</td>\n", get_html_text("053"));
  fprintf(actout, "</tr>\n");

  /* parse dir/sql file for SQL settings */
  fprintf(actout, "<tr>\n");
  fprintf(actout, "  <td bgcolor=%s align=\"middle\">\n", get_color_text("004"));
  fprintf(actout, "    <table cellpadding=0 cellspacing=2 border=0>\n");
  fprintf(actout, "      <tr>\n");
  fprintf(actout, "        <th colspan=2 align=\"middle\">%s&nbsp;</th>\n", get_html_text("099"));
  fprintf(actout, "      <tr>\n");

  /* get hostname */
  strcpy(checked1, "localhost");
  if(usesql == 1 && sqlfileok == 1) {
    strncpy(TmpBuf3, TmpBuf1, 1);       
    if((strstr(TmpBuf3, ":")) == NULL) { 
      for(i=0,j=0;TmpBuf1[i]!=':'&&TmpBuf1[i]!='\0';++j,++i) checked1[j] = TmpBuf1[i];
      checked1[j] = '\0'; 
    }       
  }       
  fprintf(actout, "      <tr>\n");
  fprintf(actout, "        <td>%s\n", get_html_text("054"));
  fprintf(actout, "          <br>\n");
  fprintf(actout, "          <input type=text name=sql1 value=\"%s\"></td>\n", checked1);

  /* get port */
  strcpy(checked1, "3306");
  if(usesql == 1 && sqlfileok == 1) {
    strncpy(TmpBuf3, &TmpBuf1[++i], 1);       
    if((strstr(TmpBuf3, ":")) == NULL) { 
      for(j=0;TmpBuf1[i]!=':'&&TmpBuf1[i]!='\0';++j,++i) checked1[j] = TmpBuf1[i];
      checked1[j] = '\0'; 
    }       
  }       
  fprintf(actout, "        <td>%s\n", get_html_text("055"));
  fprintf(actout, "          <br>\n");
  fprintf(actout, "          <input type=text name=sql2 value=\"%s\"></td>\n", checked1);
  fprintf(actout, "      </tr>\n");

  /* get user */
  strcpy(checked1, "");
  if(usesql == 1 && sqlfileok == 1) {
    strncpy(TmpBuf3, &TmpBuf1[++i], 1);       
    if((strstr(TmpBuf3, ":")) == NULL) { 
      for(j=0;TmpBuf1[i]!=':'&&TmpBuf1[i]!='\0';++j,++i) checked1[j] = TmpBuf1[i];
      checked1[j] = '\0'; 
    }       
  }       
  fprintf(actout, "      <tr>\n");
  fprintf(actout, "        <td>%s\n", get_html_text("056"));
  fprintf(actout, "          <br>\n");
  fprintf(actout, "          <input type=text name=sql3 value=\"%s\"></td>\n", checked1);

  /* get password */
  strcpy(checked1, "");
  if(usesql == 1 && sqlfileok == 1) {
    strncpy(TmpBuf3, &TmpBuf1[++i], 1);
    if((strstr(TmpBuf3, ":")) == NULL) {
      for(j=0;TmpBuf1[i]!=':'&&TmpBuf1[i]!='\0';++j,++i) checked1[j] = TmpBuf1[i];
      checked1[j] = '\0';
    }
  }
  fprintf(actout, "        <td>%s\n", get_html_text("057"));
  fprintf(actout, "          <br>\n");
  fprintf(actout, "          <input type=text name=sql4 value=\"%s\"></td>\n", checked1);
  fprintf(actout, "      </tr>\n");

  /* get database name */
  strcpy(checked1, "");
  if(usesql == 1 && sqlfileok == 1) {
    strncpy(TmpBuf3, &TmpBuf1[++i], 1);       
    if((strstr(TmpBuf3, ":")) == NULL) { 
      for(j=0;TmpBuf1[i]!=':'&&TmpBuf1[i]!='\0';++j,++i) checked1[j] = TmpBuf1[i];
      checked1[j] = '\0'; 
    }       
  }       
  fprintf(actout, "      <tr>\n");
  fprintf(actout, "        <td>%s\n", get_html_text("058"));
  fprintf(actout, "          <br>\n");
  fprintf(actout, "          <input type=text name=sql5 value=\"%s\"></td>\n", checked1);

  /* get table name */
  strcpy(checked1, "ezmlm");
  if(usesql == 1 && sqlfileok == 1) {
    ++i;
    if(strlen(TmpBuf1) != i) {
      for(j=0;TmpBuf1[i]!=':'&&TmpBuf1[i]!='\0';++j,++i) checked1[j] = TmpBuf1[i];
      checked1[j] = '\0'; 
    }       
  }       
  fprintf(actout, "        <td>%s\n", get_html_text("059"));
  fprintf(actout, "          <br>\n");
  fprintf(actout, "          <input type=\"text\" name=\"sql6\" value=\"%s\"></td>\n", checked1);
  fprintf(actout, "      </tr>\n");
  fprintf(actout, "    </table>\n");
  fprintf(actout, "</td></tr></table>\n");

}


/* 
 * ezmlm-make -e leaves .qmail-listname-(accept||reject) links for some reason.
 * (causing file permission errors in "show mailing lists") Also, it doesn't 
 * delete dir/digest/ when turning off digests.  del_list_links() fixes 
 * these things
 */
int del_list_links(char *linktype)
{
  int pid;
  char tmpstr[MAX_BUFF];
  DIR *mydir;
  struct dirent *mydirent;

  if ((mydir = opendir(".")) == NULL) {
    fprintf(actout,"<tr><td>%s %d</tr><td>\n", get_html_text("143"), 1);
    return 0;
  }
 
  if (strstr(linktype, "moderator") != 0) {
    sprintf(TmpBuf2, ".qmail-%s-accept-default", dotqmail_name);
    sprintf(TmpBuf3, ".qmail-%s-reject-default", dotqmail_name);
  } else if(strstr(linktype, "digest") != 0) {
    sprintf(TmpBuf2, ".qmail-%s-digest-return-default", dotqmail_name);
    sprintf(TmpBuf3, ".qmail-%s-digest-owner", dotqmail_name);
  }
  while( (mydirent=readdir(mydir)) != NULL ) {
    if ( strncmp(TmpBuf2, mydirent->d_name, strlen(TmpBuf2)) == 0 ) {
      if ( unlink(mydirent->d_name) != 0 ) {
        ack(get_html_text("185"), TmpBuf2);
      }
    }
    if ( strncmp(TmpBuf3, mydirent->d_name, strlen(TmpBuf3)) == 0 ) {
      if ( unlink(mydirent->d_name) != 0 ) {
        ack(get_html_text("185"), TmpBuf3);
      }
    }
  }
  closedir(mydir);

  /* delete the digest directory */
  if(strstr(linktype, "digest") != 0) {
    sprintf(tmpstr, "%s/%s/digest", RealDir, ActionUser);
    vdelfiles(tmpstr);
    chdir(RealDir);
  }
}

