#include "rpggame.h"

float strength(int startmillis, int duration)
{
	if(duration <= 0 || lastmillis - startmillis < duration * 0.8)
		return 1;
	else
		return 1 - (lastmillis - startmillis - duration * 0.8) / (duration * 0.2f);
}

bool victimeffect::update(rpgent *victim)
{
	if(!game::statuses.inrange(group))
	{
		conoutf(CON_ERROR, "ERROR: Victim effect lacks status definition (%i) - deleting");
		return false;
	}

	statusgroup *sg = game::statuses[group];
	victim->applyeffects(sg, strength(startmillis, duration) * mul, duration == 0, owner);

	return duration < 0 || (lastmillis - startmillis) < duration;
}

bool areaeffect::update()
{
	if(!game::statuses.inrange(group))
	{
		conoutf(CON_ERROR, "ERROR: Area effect lacks status definition (%i) - deleting");
		return false;
	}

	statusgroup *sg = game::statuses[group];

	if(sg->effects.length())
	{
		loopv(game::curmap->objs)
		{
			rpgent *d = game::curmap->objs[i];

			//checking the head and the feet should be sufficiently accurate for gaming purposes
			if(d->o.dist(o) <= radius || d->feetpos().dist(o) <= radius)
				d->applyeffects(sg, strength(startmillis, duration) * mul, duration == 0, owner);
		}
	}

	return duration < 0 || (lastmillis - startmillis) < duration;
}

void areaeffect::render()
{
	if(!game::effects.inrange(fx))
		return;

	effect *e = game::effects[fx];

	switch(e->deathpart)
	{
		default:
			if((lastmillis - lastemit) >= emitmillis)
			{
				rpgeffect::drawsphere(e, o, radius, mul, rpgeffect::DEATH_PROLONG, lastmillis - lastemit);
				lastemit = lastmillis;
			}
			break;

		case PART_EXPLOSION:
		case PART_EXPLOSION_BLUE:
			rpgeffect::drawsphere(e, o, radius, mul, rpgeffect::DEATH_PROLONG, 0);
			break;
	}
}
