#include "rpggame.h"

/*
This file is to remain fully separate from the rest of the game files.
Compilation and linking should succeed without this
*/

#ifndef NO_DEBUG

using namespace game;

namespace test
{
	void testproj(int flags, int allowed)
	{
		enum
		{
			FLAG_FAST = 1,
			FLAG_FUZZY = 2,
			FLAG_FLAGS = 4
		};

		if(!curmap)
		{
			conoutf("Error: map data currently not available");
			return;
		}
		if(!effects.length())
		{
			conoutf("No effects declared, not creating projectile");
			return;
		}

		projectile *p = new projectile();
		p->init(
		        player1,
			NULL, NULL,
			(flags&FLAG_FUZZY) ? projectile::INIT_FUZZY : 0,
			0.01 + rnd(flags & FLAG_FAST ? 10000 : 1000) / 100.0f
		);

		p->fx = rnd(effects.length());
		p->gravity = rnd(401) - 200;
		p->dist = 200 + rnd(9800);
		p->time = 200 + rnd(9800);
		p->elasticity = rnd(101) / 100.0f;
		p->radius = 32;

		if(flags & FLAG_FLAGS)
			p->pflags = rnd(64);

		p->pflags &= (allowed ? allowed : ~allowed);

		string pflags;
		pflags[0] = '\0';
		const char *flagnames[] = {"P_TIME", "P_DIST", "P_RICOCHET", "P_VOLATILE", "P_PROXIMITY", "P_STATIONARY"};

		loopi(6)
		{
			if(!(p->pflags & (1 << i)))
				continue;

			if(pflags[0])
				concatstring(pflags, "|");

			concatstring(pflags, flagnames[i]);
		}

		conoutf("fx: %4i\tgravity: %4i\tspeed: %6.2f\tflags: %3i (%s)\ttime: %4i\tdist: %4i\telasticity: %1.2f", p->fx, p->gravity, p->dir.magnitude(), p->pflags, pflags, p->time, p->dist, p->elasticity);

		curmap->projs.add(p);
	}
	ICOMMAND(testproj, "ii", (int *i, int *a), testproj(*i, *a))

	void testeffect(int ind, int duration)
	{
		if(!curmap)
		{
			conoutf("ERROR: map data unavailable");
			return;
		}
		if(!statuses.inrange(ind))
		{
			if(!statuses.length())
				conoutf("ERROR: No statusgroups declared");
			else
				conoutf("ERROR: statusgroup %i out of range", ind);

			return;
		}

		victimeffect *effect = new victimeffect();
		effect->startmillis = lastmillis;
		effect->group = ind;
		effect->duration = duration;

		player1->seffects.add(effect);

		conoutf("Added statusgroup %i to player for %i ms", ind, duration);
	}
	ICOMMAND(testeffect, "ii", (int *i, int *j), testeffect(*i, *j);)

	void testareaeffect(float x, float y, float z, int ind, int duration)
	{
		if(!curmap)
		{
			conoutf("ERROR: map data unavailable");
			return;
		}
		if(!statuses.inrange(ind))
		{
			if(!statuses.length())
				conoutf("ERROR: No statusgroups declared");
			else
				conoutf("ERROR: statusgroup %i out of range", ind);

			return;
		}
		if(!effects.length())
		{
			conoutf("ERROR: No particle effects have been declared");
			return;
		}

		areaeffect *effect = new areaeffect();
		effect->o = vec(x, y, z);
		effect->group = ind;
		effect->startmillis = lastmillis;
		effect->duration = duration;
		effect->fx = rnd(effects.length());
		effect->radius = rnd(161) + 32;

		curmap->aeffects.add(effect);
		conoutf("Added area effect to world. radius: %i fx: %i", effect->radius, effect->fx);
	}
	ICOMMAND(testareaeffect, "fffii", (float *a, float *b, float *c, int *d, int *e), testareaeffect(*a, *b, *c, *d, *e);)

	ICOMMAND(testxpdelta, "i", (int *xp), game::player1->givexp(*xp);)
}

#endif
