#include "seaview.h"
#include <FL/Fl_Color_Chooser.H>
#include <FL/Fl_Slider.H>
#include <FL/Fl_Check_Button.H>
#include <FL/Fl_Value_Input.H>


void custom_callback(Fl_Widget *obj, void *data);
void my_colorchooser(Fl_Widget *obj, void *data);
void my_colorchooser_callback(Fl_Widget *obj, void *data);
void slider_cb(Fl_Widget *obj, void *data);
void ignore_cb(Fl_Widget *obj, void *data);
void accept_cb(Fl_Widget *obj, void *data);
void permanent_cb(Fl_Widget *obj, void *data);
void reset_color_callback(Fl_Widget *obj, void *data);
void accept_color_callback(Fl_Widget *obj, void *data);
void reset_callback(Fl_Widget *obj, void *data);


/* private global variables */
static Fl_Button *A, *C, *G, *T;
static Fl_Slider *bgrnd, *s_bgrnd;
static Fl_Input *protgroups, *s_protgroups, *movekeys;
static Fl_Button **protcol;
static Fl_Check_Button *lowercase, *inverted;
static Fl_Choice *pdfformat, *saveformat, *alignment_algo;
static Fl_Value_Input *pdffontsize;

/* extern variables & functions */
extern int *def_protcolors, max_protcolors;
extern char def_stdcolorgroups[];
extern char *f_format_names[];
extern int nbr_formats;
extern paperformat printout_pageformat;
extern int printout_fontsize;
extern void mod_multipl(SEA_VIEW *view, int newval);
extern void set_aa_color_mode(color_choice choice);
extern color_choice prep_aa_color_code(char *list_std, char *list_alt, 
	int maxprotcolors, int *numb_stdprotcolors, int *numb_altprotcolors);
extern int set_res_value(const char *name, const char *value);
extern int save_resources(void);
extern void minuscules(char *);
extern char *get_res_value(char *name, char *def_value);


void custom_callback(Fl_Widget *obj, void *data)
{
static Fl_Window *win = NULL;
int x, y, w, h, c;
SEA_VIEW *view = (SEA_VIEW *)data;
Fl_Button *reset;

if(win == NULL) {
	win = new Fl_Window(310, 530, "Customization");
	
	x = 9; y = 20; w = 160; h = 20;
	bgrnd = new Fl_Slider(x,y,w,h, "background grey");
	bgrnd->type(FL_HOR_NICE_SLIDER);
	bgrnd->bounds(32., 55.);
	bgrnd->color2( FL_BLACK );
	bgrnd->precision(0);
	bgrnd->align(FL_ALIGN_TOP);
	bgrnd->callback(slider_cb);
	y += bgrnd->h() + 25;

	s_bgrnd = new Fl_Slider(x,y,w,h, "sites background grey");
	s_bgrnd->type(FL_HOR_NICE_SLIDER);
	s_bgrnd->bounds(32., 55.);
	s_bgrnd->color2( FL_BLACK );
	s_bgrnd->precision(0);
	s_bgrnd->align(FL_ALIGN_TOP);
	s_bgrnd->callback(slider_cb);
	
	reset = new Fl_Button(bgrnd->x() + bgrnd->w() + 40, s_bgrnd->y() - 20, 50, 20, "reset");
	reset->color(FL_LIGHT2);
	reset->callback(reset_callback, bgrnd);
	new Fl_Box(FL_DOWN_FRAME, 5, 3,
		win->w() - 8, 90 , "");
	
	y += s_bgrnd->h() + 20;
	w=40; h=w;
	A = new Fl_Button(x, y, w, h, "A");
	A->callback(my_colorchooser );
	
	x += A->w() + 10;
	C = new Fl_Button(x, y, w, h, "C");
	C->callback(my_colorchooser );

	x += A->w() + 10;
	G = new Fl_Button(x, y, w, h, "G");
	G->callback(my_colorchooser );

	x += A->w() + 10;
	T = new Fl_Button(x, y, w, h, "T/U");
	T->callback(my_colorchooser );
	
	x += A->w() + 30;
	reset = new Fl_Button(x, y + 10, 50, 20, "reset");
	reset->color(FL_LIGHT2);
	reset->callback(reset_callback, A);
	new Fl_Box(FL_DOWN_FRAME, 5, A->y() - 5,
		win->w() - 8, A->h() + 10 , "");
	
	x = A->x();
	y += A->h() + 35;
	int topbox = y - 25;
	protgroups = new Fl_Input(x,y,280, 20, "aa coloring scheme");
	protgroups->align(FL_ALIGN_TOP);

	y += protgroups->h() + 20;
	s_protgroups = new Fl_Input(x,y,280, 20, "alternate aa coloring scheme");
	s_protgroups->align(FL_ALIGN_TOP);
	
	y += s_protgroups->h() + 10;
	new Fl_Box(x, y, win->w(), 20, "catalog of amino acid colors");
	y += 20;
	w = h = 25;
	protcol = (Fl_Button **)malloc(max_protcolors * sizeof(Fl_Button *));
	for(c=1; c < max_protcolors; c++) {
		protcol[c] = new Fl_Button(x, y, w, h, "");
		protcol[c]->callback(my_colorchooser);
		x += w + 5;
		}
	y += h + 10;
	reset = new Fl_Button(win->w() / 2 - 25, y, 50, 20, "reset");
	reset->color(FL_LIGHT2);
	reset->callback(reset_callback, protgroups);
	new Fl_Box(FL_DOWN_FRAME, 5, topbox,
		win->w() - 8, y + reset->h() + 5 - topbox, "");

	x = A->x();
	y += protcol[1]->h() + 30; 
	movekeys = new Fl_Input(x,y, 50, 20, "right-left movement keys");
	movekeys->align(FL_ALIGN_TOP | FL_ALIGN_LEFT);
	reset = new Fl_Button(x + movekeys->w() + 5, y, 50, 20, "reset");
	reset->color(FL_LIGHT2);
	reset->callback(reset_callback, movekeys);

	w = 130;
	x = win->w() - w - 5;
	saveformat = new Fl_Choice(x,y,w,h, "default save format");
	saveformat->align(FL_ALIGN_TOP);
	for(c=0; c < nbr_formats; c++) saveformat->add(f_format_names[c]);
	saveformat->selection_color(saveformat->color());
	
	x = A->x();
	y += movekeys->h() + 10; 
	lowercase = new Fl_Check_Button(x,y,140,20, "display lowercase");

	y += lowercase->h(); 
	inverted = new Fl_Check_Button(x,y,140,20, "inverted");
	
	x = win->w() - w - 5;
	y = movekeys->y() + movekeys->h() + 20;
	pdfformat = new Fl_Choice(x,y,w,h, PDF_OR_PS" page format");
	pdfformat->align(FL_ALIGN_TOP);
	for(c=0; c < nbr_formats; c++) pdfformat->add("A4|LETTER");
	pdfformat->selection_color(pdfformat->color());
	
	y = pdfformat->y() + pdfformat->h() + 20;
	pdffontsize = new Fl_Value_Input(x,y,w,h, PDF_OR_PS" fontsize");
	pdffontsize->align(FL_ALIGN_TOP);
	
	x = A->x();
	y = inverted->y() + inverted->h() + 20; 
	alignment_algo = new Fl_Choice(x,y,w,h, "alignment algorithm");
	alignment_algo->align(FL_ALIGN_TOP);
	x = A->x();
	y += alignment_algo->h() + 10;
	h = 40;
	w = 95;
	Fl_Button *accept = new Fl_Button(x,y,w,h, "Apply");
	accept->tooltip("changes apply only to current seaview run");
	accept->callback(accept_cb, view);
	accept->color(FL_LIGHT2);
	x += w + 5;
	Fl_Button *permanent = new Fl_Button(x,y,w,h, "Set changes\npermanent");
	permanent->tooltip("changes apply to current & future seaview runs");
	permanent->callback(permanent_cb, view);
	permanent->color(FL_LIGHT2);
	w = 45;
	y += 10;
	Fl_Button *ignore = new Fl_Button(win->w() - w - 5,y,w,20, "Close");
	ignore->color(FL_LIGHT2);
	ignore->callback(ignore_cb);
	win->end();
	win->resizable(NULL);
	}

bgrnd->value( view->DNA_obj->color() );
bgrnd->color( view->DNA_obj->color() );
s_bgrnd->value( view->DNA_obj->color2() );
s_bgrnd->color( view->DNA_obj->color2() );
A->color(view->dnacolors[1], view->dnacolors[1]);
C->color(view->dnacolors[2], view->dnacolors[2]);
G->color(view->dnacolors[3], view->dnacolors[3]);
T->color(view->dnacolors[4], view->dnacolors[4]);
char *p, aagroups[30];
p = aagroups;
set_aa_color_mode(USING_STANDARD_COLORS);
for(c=1; c < view->numb_stdprotcolors; c++) {
	for(char aa='A'; aa<='Z';aa++) {
		if(get_color_for_aa(aa) == c) *(p++) = aa;
		}
	if(c+1< view->numb_stdprotcolors) strcpy(p++, ",");
	}
*p = 0;
protgroups->value(aagroups);
if(view->numb_altprotcolors <= 1) s_protgroups->value("");
else {
	p = aagroups;
	set_aa_color_mode(USING_ALT_COLORS);
	for(c=1; c < view->numb_altprotcolors; c++) {
		for(char aa='A'; aa<='Z';aa++) {
			if(get_color_for_aa(aa) == c) *(p++) = aa;
			}
		if(c+1< view->numb_altprotcolors) strcpy(p++, ",");
		}
	*p = 0;
	s_protgroups->value(aagroups);
	}
if(view->curr_colors == view->stdprotcolors) set_aa_color_mode(USING_STANDARD_COLORS);
else set_aa_color_mode(USING_ALT_COLORS);

for(c=1; c < max_protcolors; c++) {
	protcol[c]->color(view->stdprotcolors[c], view->stdprotcolors[c]);
	}
movekeys->value( view->movekeys );
lowercase->value(view->allow_lower);
inverted->value(view->inverted_colors);
pdfformat->value(printout_pageformat);
pdffontsize->value(printout_fontsize);
saveformat->value(view->format_for_save);
Fl_Menu_Button *menu_props = (Fl_Menu_Button *)view->bouton_props;
props_menu_parts *props_parts = (props_menu_parts *)menu_props->user_data();
alignment_algo->clear();
for(x = 0; x < view->count_msa_algos; x++) {
	Fl_Menu_Item *item = ((Fl_Menu_Item *)menu_props->menu() + props_parts->clustalopt + x);
	alignment_algo->add( item->label() );
	}	
alignment_algo->value(view->alignment_algorithm);

win->show();
return;
}


void ignore_cb(Fl_Widget *obj, void *data)
{
obj->window()->hide();
}


void accept_cb(Fl_Widget *obj, void *data)
{
SEA_VIEW *view = (SEA_VIEW *)data;
Fl_Menu_Button *menu_props = (Fl_Menu_Button *)view->bouton_props;
props_menu_parts *props_parts = (props_menu_parts *)menu_props->user_data();
char *p;
Fl_Menu_Item *item;

my_watch_cursor(view->dnawin);
view->DNA_obj->color((int)(bgrnd->value() + 0.5));
view->DNA_obj->color2((int)(s_bgrnd->value() + 0.5));
view->DNA_obj->parent()->color( view->DNA_obj->color() );
view->dnacolors[1] = A->color();
view->dnacolors[2] = C->color();
view->dnacolors[3] = G->color();
view->dnacolors[4] = T->color();
for(int c=1; c < max_protcolors; c++) view->stdprotcolors[c] = protcol[c]->color();

p = strdup(protgroups->value());
majuscules(p);
protgroups->value(p);
free(p);
p = strdup(s_protgroups->value());
majuscules(p);
s_protgroups->value(p);
free(p);
prep_aa_color_code((char *)protgroups->value(), (char *)s_protgroups->value(), max_protcolors, 
	&view->numb_stdprotcolors, &view->numb_altprotcolors);
int etat = menu_props->mode(props_parts->colors + 2);
if(view->numb_altprotcolors > 1) menu_props->mode(props_parts->colors + 2, etat & ~FL_MENU_INACTIVE);
else menu_props->mode(props_parts->colors + 2, etat | FL_MENU_INACTIVE);
if(view->protein) {
	view->alt_colors = (color_choice)-1; /* to force redraw of sequences */
	menu_props->value(props_parts->colors + 1);
	item = (Fl_Menu_Item *)menu_props->menu() + props_parts->colors;
	item->do_callback(menu_props);
	(item+1)->setonly();
	if(view->numb_altprotcolors > 1) view->alt_colors = USING_STANDARD_COLORS;
	else view->alt_colors = NO_ALT_COLORS;
	}

if(strlen(movekeys->value()) != 4)  movekeys->value(view->movekeys);
else {
	strcpy(view->movekeys, movekeys->value() ); 
	mod_multipl(view, view->multipl->argument() );
	view->multipl->redraw();
	}

item = (Fl_Menu_Item *)menu_props->menu() + props_parts->allow_lower;
view->allow_lower = ! lowercase->value(); /* because callback toggles it */
item->do_callback(menu_props);
if(view->allow_lower) item->set();
else item->clear();

item = (Fl_Menu_Item *)menu_props->menu() + props_parts->inverted;
view->inverted_colors = ! inverted->value(); /* because callback toggles it */
menu_props->value(props_parts->inverted);
item->do_callback(menu_props);
if(view->inverted_colors) item->set();
else item->clear();

printout_pageformat = (paperformat)pdfformat->value();
printout_fontsize = (int)pdffontsize->value();

view->format_for_save = (known_format)saveformat->value();
item = (Fl_Menu_Item *)menu_props->menu() + props_parts->saveformat;
(item+view->format_for_save)->setonly();

view->alignment_algorithm = alignment_algo->value();
item = (Fl_Menu_Item *)menu_props->menu() + props_parts->clustalopt;
(item + view->alignment_algorithm)->setonly();

if(!view->protein) view->DNA_obj->redraw();
fl_reset_cursor(view->dnawin);
}


void permanent_cb(Fl_Widget *obj, void *data)
{
char txt[150];
int v;
uchar r, g, b;

accept_cb(obj, data);

v = (int)(bgrnd->value() + 0.5);
sprintf(txt, "%d", v );
set_res_value("background", txt );
v = (int)(s_bgrnd->value() + 0.5);
sprintf(txt, "%d", v );
set_res_value("sites_background", txt );

Fl::get_color( A->color(), r, g, b);
sprintf(txt, "%d %d %d,", r, g, b);
Fl::get_color( C->color(), r, g, b);
sprintf(txt + strlen(txt), "%d %d %d,", r, g, b);
Fl::get_color( G->color(), r, g, b);
sprintf(txt + strlen(txt), "%d %d %d,", r, g, b);
Fl::get_color( T->color(), r, g, b);
sprintf(txt + strlen(txt), "%d %d %d", r, g, b);
set_res_value("dnacolors", txt);

set_res_value("stdcolorgroups", (char *)protgroups->value());
set_res_value("altcolorgroups", (char *)s_protgroups->value());

txt[0] = 0;
for(int c=1; c < max_protcolors; c++) {
	Fl::get_color( protcol[c]->color(), r, g, b);
	sprintf(txt + strlen(txt), "%d %d %d,", r, g, b);
	}
txt[strlen(txt) - 1] = 0;
set_res_value("protcolors", txt);

set_res_value("movekeys", movekeys->value() );
set_res_value("lowercase", lowercase->value() ? "true" : "false");
set_res_value("inverted", inverted->value() ? "true" : "false");
set_res_value("printoutpageformat", printout_pageformat == A4 ? "A4" : "LETTER" );
sprintf(txt, "%d", (int)pdffontsize->value() );
set_res_value("printoutfontsize",  txt);

strcpy(txt, f_format_names[saveformat->value()] );
minuscules(txt);
set_res_value("save", txt );

v = alignment_algo->value();
sprintf(txt, "%d", v );
set_res_value("alignment", txt);

save_resources();
obj->window()->hide();
}


void reset_callback(Fl_Widget *obj, void *data)
{
if(data == A) {
	A->color(FL_RED, FL_RED);
	C->color(FL_GREEN, FL_GREEN);
	G->color(FL_YELLOW, FL_YELLOW);
	T->color(FL_BLUE, FL_BLUE);
	}
else if(data == bgrnd) {
	int back_color, region_back_color;
#ifdef WIN32
	back_color = FL_DARK1; region_back_color = 43;
#else
	back_color = FL_GRAY; region_back_color = FL_DARK2;
#endif
	bgrnd->value( back_color );
	bgrnd->color( back_color );
	s_bgrnd->value( region_back_color );
	s_bgrnd->color( region_back_color );
	}
else if(data == movekeys) {
	movekeys->value(MOVEKEYS_DEFAULT);
	}
else if(data == protgroups) {
	protgroups->value(def_stdcolorgroups);
	s_protgroups->value("");
	for(int c=1; c < max_protcolors; c++) {
		protcol[c]->color(def_protcolors[c], def_protcolors[c]);
		}
	}
obj->window()->redraw();
}


void my_colorchooser(Fl_Widget *obj, void *data)
{
static Fl_Window *win = NULL;
static Fl_Color_Chooser *ch;
uchar r, g, b;
static Fl_Color initial;

if(win == NULL) {
	win = new Fl_Window(205, 125, "Color chooser");
	ch = new Fl_Color_Chooser(1, 1, 200, 95);
	ch->callback(my_colorchooser_callback);
	Fl_Button *reset = new Fl_Button(5, 100, 40, 20, "reset");
	reset->callback(reset_color_callback, ch);
	Fl_Button *ok = new Fl_Button(160, 100, 40, 20, "OK");
	ok->callback(accept_color_callback, ch);
	win->end();
	win->resizable(NULL);
	win->set_modal();
	win->callback(reset_color_callback, ch);
}
if(win->shown()) return;
Fl::get_color( obj->color(), r, g, b);
ch->rgb(r/255., g/255., b/255.);
ch->user_data(obj);
obj->user_data(&initial);
initial = obj->color();
win->show();
return;
}


void my_colorchooser_callback(Fl_Widget *obj, void *data)
{
int r, g, b;
Fl_Button *but = (Fl_Button *)data;
Fl_Color_Chooser *ch = (Fl_Color_Chooser *)obj;
r = (int)(ch->r() * 255 + 0.5);
g = (int)(ch->g() * 255 + 0.5);
b = (int)(ch->b() * 255 + 0.5);
Fl_Color c = fl_rgb_color(r, g, b);
but->color(c, c);
but->redraw();
}


void reset_color_callback(Fl_Widget *obj, void *data)
{
Fl_Color_Chooser *ch = (Fl_Color_Chooser *)data;
Fl_Widget *from = (Fl_Widget *)(ch->user_data());
Fl_Color c = *(Fl_Color *)(from->user_data());
uchar r, g, b;

from->color(c, c);
from->redraw();
if(obj->window() == NULL) ((Fl_Window *)obj)->hide();
else {
	Fl::get_color( c, r, g, b);
	ch->rgb(r/255., g/255., b/255.);
	}
}


void accept_color_callback(Fl_Widget *obj, void *data)
{
obj->window()->hide();
}


void slider_cb(Fl_Widget *obj, void *data)
{
Fl_Valuator *v = (Fl_Valuator *)obj;
v->color( (int)(v->value() + 0.5) );
}
