#include <Fl/fl_ask.H>
#include "unrooted.h"
#include "treedraw.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>


char *preptree_unrooted(const char *tree, FD_unrooted *data);
static void loadphylip(char *arbre, FD_unrooted *data);
static struct noeud *unrootedset(char *arbre, char *deb, char *fin, branche_noeud **p_int_br, FD_unrooted *data);
static void parcourir_branches(struct noeud *centre, struct noeud *origine);
static void process_branche(struct noeud *cote1, struct noeud *cote2, double length);
double calc_echelle(FD_unrooted *data, int larg);
bignoeud *cre_new_tree(struct noeud *debut, struct noeud *parent, bignoeud *bigparent);
void remove_big_root(bignoeud *bigracine);
double calc_dist_centre_feuilles(bignoeud *debut, bignoeud *parent);
double proc_null_neg_branches(bignoeud *debut, bignoeud *parent);
int set_angles_noeuds(bignoeud *debut, bignoeud *parent, double delta,
				double *p_current_angle, double rayon);
void calc_cartesienne( cp_point *p);
void calc_polaire( cp_point *p);
cp_point calc_point_direction( cp_point *depart, cp_point *direction, 
	double longueur, double mini_br_length);
unrooted_branch *calc_position_noeuds(bignoeud *debut, bignoeud *parent,
	unrooted_branch *curr_branche, double mini_br_length);
void mem_line(cp_point *debut, cp_point *fin, bignoeud *noeud_term, 
	unrooted_branch *br);
void free_bignoeud(bignoeud *debut, bignoeud *parent);
int chg_phys(FD_unrooted *ob, hits_field hits, int char_height);
void log_to_phys(FD_unrooted *data, cp_point *log_pos, cp_point *phys_pos);
double length_log_phys(FD_unrooted *data, double p);
double length_phys_log(FD_unrooted *data, double p);

/* external functions */
extern double place_midpoint_root(struct noeud *from, struct noeud *racine);
extern const char *make_binary_or_unrooted(char *arbre);
extern int make_binary(char *arbre, char *debut, char *fin, int go_down);
char *check_alloc(int nbrelt, int sizelt);
extern char *nextpar(char *pospar);
extern double arrondi_echelle(double x);

/* variables globales OK for several windows
*/
static int nextotu, num_noeud;


char *preptree_unrooted(const char *tree, FD_unrooted *data)
{
int i, c, v;
char *arbre, *finarbre, *p;

	arbre = strdup(tree);
	p = arbre; while(isspace(*p)) p++;
	data->notu = 2; i = 3; v = 0;
	if(*p == '(') {
		if(p > arbre) memmove(arbre, p, strlen(p) + 1);
		p = arbre + 1;
		while( (c=*(p++)) != 0 && c != ';') {
			if(c == ')') data->notu++;
			if(c == '(') i++;
			if(c == ',') v++;
		}
	}
	if(i != data->notu) {
		free(arbre);
		data->notu = 0;
		return "Incorrect tree data.";
	}
	finarbre = nextpar(arbre);
	if(finarbre == NULL) {
		data->notu = 0;
		return ("Unbalanced parentheses in tree.");
	}

arbre = (char *)realloc(arbre, strlen(arbre) + 4 * v + 5 ); /* worst case add 4 chars for each , */
p = (char *)make_binary_or_unrooted(arbre);
if(p != NULL) {
	data->notu = 0;
	free(arbre);
	return p;
}
data->notu = v + 1 ; /* after this notu = number of OTUs  */
data->totbranches = -1;

/* allocate all memory */
data->tabtax = (struct noeud **)check_alloc(2*data->notu - 1,sizeof(struct noeud *));
if(data->notu > 3) data->branche_noeuds = 
	(branche_noeud *)check_alloc(data->notu-3, sizeof(branche_noeud));
for(i=0; i<2*data->notu - 1; i++) *(data->tabtax+i)=
			(struct noeud *)check_alloc(1, sizeof(struct noeud));
loadphylip(arbre, data);
free(arbre);
if(data->notu == 0) goto erreur;
if(!data->rooted) {
	data->racine = *(data->tabtax+(++num_noeud));
	if(num_noeud >= 2*data->notu - 1) return("Error: incorrect tree file");
	data->root_br_l = place_midpoint_root(data->tabtax[0], data->racine);
	}
else	{
	return ("Unexpected rooted tree.");
	}
if(data->notu < 3) return ("Tree should contain at least 3 elements.");
return (NULL);

erreur:
return ("Not a valid tree.");
} /* end of preptree_unrooted */


static void loadphylip(char *arbre, FD_unrooted *data)
{
char *deba,*debb,*debc, *finarbre;
struct noeud *p1, *p2, *p3, *p;
branche_noeud *int_br_g, *int_br_d;

data->has_br_length=2;
/* ignore all stuff after last closing parenthesis 
(needed for fastDNAml output)
*/
finarbre= nextpar(arbre);
data->rooted=0;
deba=arbre+1;
debb=deba;
while(*debb != ',') {
	if(*debb == '(')debb=nextpar(debb);
	debb++;
	}
debb++;
debc=debb;
while(*debc != ',' && debc<finarbre) {
	if(*debc == '(')debc=nextpar(debc);
	debc++;
	}
if(*debc==',') {
/* the tree is unrooted <==> it has 3 subtrees at its bottommost level */
	debc++;
	}
else	{
/* the tree is rooted */
	debc=finarbre+1;
	data->rooted = 1;
	}
num_noeud = data->notu - 1;
nextotu = -1;
p1=unrootedset(arbre, deba, debb-2, &int_br_g, data);
if(p1 != NULL) p2=unrootedset(arbre, debb, debc-2, &int_br_d, data);
if(p1 == NULL || p2 == NULL || num_noeud + 1 >= 2*data->notu - 1) {
	data->notu = 0;
	return;
	}
p = *(data->tabtax+(++num_noeud));
if(!data->has_br_length) {
	p1->l3 = 0.5*p1->l3;
	p2->l3 = 0.5*p2->l3;
	}
p->v1=p1; p1->v3=p; p->l1=p1->l3;
if(int_br_g!=NULL) { int_br_g->bouta=p; int_br_g->boutb=p1; }
p->v2=p2; p2->v3=p; p->l2=p2->l3;
if(int_br_d!=NULL) { int_br_d->bouta=p; int_br_d->boutb=p2; }
if(!data->rooted) {
	p3=unrootedset(arbre, debc, finarbre-1, &int_br_g, data);
	if(p3 == NULL ) {
		data->notu = 0;
		return;
		}
	if(int_br_g!=NULL) { int_br_g->bouta=p; int_br_g->boutb=p3; }
	p->v3=p3; p3->v3=p; p->l3=p3->l3;
	}
else	{
	p->v3=NULL;
/* recherche d'un dernier label interne */
	debc=finarbre+1;
	while(*debc!=0 && *debc!=':' && *debc!='[') debc++;
	if(debc-finarbre>1) {
		data->totbranches++;
		data->branche_noeuds[data->totbranches].bouta=p1;
		data->branche_noeuds[data->totbranches].boutb=p2;
		}
	}
}


static struct noeud *unrootedset(char *arbre, char *deb, char *fin, branche_noeud **p_int_br, FD_unrooted *data)
{
struct noeud *p;
char *virg;
int l;
branche_noeud *int_br_g, *int_br_d;

*p_int_br=NULL;
while(*deb==' ' || *deb=='\'')deb++;
while(*fin==' ')fin--;
virg=deb;
while(*virg != ',' && virg < fin) {
	if(*virg == '(') virg=nextpar(virg);
	virg++;
	}
if(virg>fin) virg=deb;
if(*virg == ',') {
	struct noeud *p1,*p2;
	p1=unrootedset(arbre,deb,virg-1,&int_br_g, data);
if(p1 == NULL) return NULL;
	p2=unrootedset(arbre,virg+1,fin,&int_br_d, data);
if(p2 == NULL) return NULL;
if(num_noeud + 1 >= 2*data->notu - 1) 
			return NULL;
	p = *(data->tabtax+(++num_noeud));
	p->v1=p1; p1->v3=p; p->l1=p1->l3;
	if(int_br_g!=NULL) { int_br_g->bouta=p; int_br_g->boutb=p1; }
	p->v2=p2; p2->v3=p; p->l2=p2->l3;
	if(int_br_d!=NULL) { int_br_d->bouta=p; int_br_d->boutb=p2; }
	}
else	{
	double brlength;
	virg=deb;
	while(*virg != ':' && virg < fin) {
		if(*virg=='(')virg=nextpar(virg);
		virg++;
		}
	if(virg>fin) virg=deb;
	if(*virg == ':') {
		sscanf(virg+1,"%le",&brlength);
		virg--;
		data->has_br_length=1;
		}
	else	{
		brlength=1;
		data->has_br_length=0;
		}
	if(*deb == '(') {
		char *fpar;
		branche_noeud *prov;
		fpar=nextpar(deb)-1;
		p=unrootedset(arbre,deb+1,fpar,&prov, data);
if(p == NULL) return NULL;
/* recherche internal label */
		l=virg-fpar-1;
		if(l>0) {
			data->totbranches++;
			*p_int_br= &data->branche_noeuds[data->totbranches];
			}
		}
	else	{
		size_t n;
		if( virg-1>=deb && *virg=='\'' )virg--;
		n=virg-deb+1;
		++nextotu;
		p= *(data->tabtax+nextotu);
		p->nom = (char *)check_alloc(n+1,1);
		memcpy(p->nom, deb, n); p->nom[n] = 0;
		p->v1=p->v2=p->v3=NULL;
		}
	p->l3=brlength;
	}
return p;
}


bignoeud *cre_new_tree(struct noeud *debut, struct noeud *parent, bignoeud *bigparent)
{
	bignoeud *nouveau;
	if(debut == NULL) return NULL;
	nouveau = (bignoeud *)check_alloc(1, sizeof(bignoeud) );
	if(debut->v1 == parent) {
		nouveau->v1 = bigparent;
		nouveau->v2 = cre_new_tree(debut->v2, debut, nouveau);
		nouveau->v3 = cre_new_tree(debut->v3, debut, nouveau);
		}
	else if(debut->v2 == parent) {
		nouveau->v2 = bigparent;
		nouveau->v1 = cre_new_tree(debut->v1, debut, nouveau);
		nouveau->v3 = cre_new_tree(debut->v3, debut, nouveau);
		}
	else	{
		nouveau->v3 = bigparent;
		nouveau->v1 = cre_new_tree(debut->v1, debut, nouveau);
		nouveau->v2 = cre_new_tree(debut->v2, debut, nouveau);
		}
	nouveau->l1 = debut->l1;
	nouveau->l2 = debut->l2;
	nouveau->l3 = debut->l3;
	nouveau->nom = debut->nom;
	return nouveau;
}


void remove_big_root(bignoeud *bigracine)
{
bignoeud *p1, *p2;
double root_br_l;

p1=bigracine->v1;
p2=bigracine->v2;
root_br_l = bigracine->l1 + bigracine->l2;
if(p1->v1 == bigracine )
	{p1->v1 = p2; p1->l1 = root_br_l;}
else if (p1->v2 == bigracine)
	{p1->v2 = p2; p1->l2 = root_br_l;}
else
	{p1->v3 = p2; p1->l3 = root_br_l;}
if(p2->v1 == bigracine )
	{p2->v1 = p1; p2->l1 = root_br_l;}
else if (p2->v2 == bigracine)
	{p2->v2 = p1; p2->l2 = root_br_l;}
else
	{p2->v3 = p1; p2->l3 = root_br_l;}
}


double calc_dist_centre_feuilles(bignoeud *debut, bignoeud *parent)
{
double valeur, current;
if(debut == NULL) return 0;
valeur = 0;  /*  !!!!! conserver cette ecriture sinon plante sur PC !!!!!! */
if(debut->v1 != parent) {
	current = calc_dist_centre_feuilles(debut->v1, debut);
	current += debut->l1;
	if(current > valeur) valeur = current;
	}
if(debut->v2 != parent) {
	current = calc_dist_centre_feuilles(debut->v2, debut);
	current += debut->l2;
	if(current > valeur) valeur = current;
	}
if(debut->v3 != parent) {
	current = calc_dist_centre_feuilles(debut->v3, debut);
	current += debut->l3;
	if(current > valeur) valeur = current;
	}
return valeur;
}


double proc_null_neg_branches(bignoeud *debut, bignoeud *parent)
/* mettre branches negatives a 0 !attention dans un seul sens!
retourner la + petite branche non nulle
*/
{
double valeur, current;
if(debut == NULL) return 0;
valeur = 1e50;
if(debut->v1 != parent) {
	if(debut->l1 < 0) debut->l1 = 0;
	current = debut->l1;
	if(current < valeur && current > 0) valeur = current;
	current = proc_null_neg_branches(debut->v1, debut);
	if(current < valeur && current > 0) valeur = current;
	}
if(debut->v2 != parent) {
	if(debut->l2 < 0) debut->l2 = 0;
	current = debut->l2;
	if(current < valeur && current > 0) valeur = current;
	current = proc_null_neg_branches(debut->v2, debut);
	if(current < valeur && current > 0) valeur = current;
	}
if(debut->v3 != parent) {
	if(debut->l3 < 0) debut->l3 = 0;
	current = debut->l3;
	if(current < valeur && current > 0) valeur = current;
	current = proc_null_neg_branches(debut->v3, debut);
	if(current < valeur && current > 0) valeur = current;
	}
return valeur;
}


int set_angles_noeuds(bignoeud *debut, bignoeud *parent, double delta,
				double *p_current_angle, double rayon)
{
int feuille = FALSE;
int poids, poids1, poids2;
double angle1 = -1, angle2 = -1;
static int totfeuilles=0;

if(debut == NULL) return 0;
if(debut->v1 != parent) {
	poids = set_angles_noeuds(debut->v1, debut, delta, p_current_angle, rayon);
	if(debut->v1 == NULL) feuille = TRUE;
	else if (parent != NULL) {
		angle1 = debut->v1->position.angle;
		poids1 = poids;
		}
	}
if(debut->v2 != parent) {
	poids = set_angles_noeuds(debut->v2, debut, delta, p_current_angle, rayon);
	if(debut->v2 == NULL) feuille = TRUE;
	else if (parent != NULL) {
		if ( angle1 == -1 ) {
			angle1 = debut->v2->position.angle;
			poids1 = poids;
			}
		else	{
			angle2 = debut->v2->position.angle;
			poids2 = poids;
			}
		}
	}
if(debut->v3 != parent) {
	poids = set_angles_noeuds(debut->v3, debut, delta, p_current_angle, rayon);
	if(debut->v3 == NULL) feuille = TRUE;
	else if (parent != NULL) {
		angle2 = debut->v3->position.angle;
		poids2 = poids;
		}
	}
if( feuille ) { totfeuilles++;
	debut->position.angle = *p_current_angle;
	*p_current_angle += delta;
	poids = 1;
	}
else if(parent != NULL)	{ /* faire angle moyen modulo 2.pi */
	debut->position.angle = (poids1*angle1 + poids2*angle2)/(poids1+poids2);
	poids = poids1 + poids2;
	if( angle1 > angle2 )
		debut->position.angle -= M_PI;
	}
debut->position.r = rayon;
calc_cartesienne(&(debut->position));
return poids;
}


void calc_cartesienne( cp_point *p)
{
p->x = p->r * cos(p->angle);
p->y = p->r * sin(p->angle);
return;
}


void calc_polaire( cp_point *p)
{
p->r = sqrt(p->x * p->x + p->y * p->y);
if( p->x == 0 ) {
	if( p->y == 0) p->angle = 0;
	else if (p->y > 0) p->angle = M_PI_2;
	else 	p->angle = 3*M_PI_2;
	}
else if (p->x > 0) {
	p->angle = atan( p->y / p->x );
	if( p->angle < 0 ) p->angle += 2*M_PI;
	}
else	{
	p->angle = M_PI - atan( p->y / p->x );
	}
return;
}


cp_point calc_point_direction( cp_point *depart, cp_point *direction, 
	double longueur, double mini_br_length)
{
static cp_point retour;
double lac, eps, tmp1, tmp2;

tmp1 = direction->x - depart->x;
tmp2 = direction->y - depart->y;
lac = sqrt( tmp1*tmp1 + tmp2*tmp2 );
/* on remplace les branches nulles par des branches tres courtes pour que le
calcul de l'angle en double soit bon mais que le dessin en entier soit le
meme
*/
if(longueur == 0) longueur = mini_br_length;
eps = longueur / lac;
retour.x = depart->x + eps * tmp1;
retour.y = depart->y + eps * tmp2;
calc_polaire(&retour);
return retour;
}


unrooted_branch *calc_position_noeuds(bignoeud *debut, bignoeud *parent,
	unrooted_branch *curr_branche, double mini_br_length)
{
if(debut->v1 != parent && debut->v1 != NULL ) {
	debut->v1->position = calc_point_direction( &(debut->position), &(debut->v1->position), debut->l1, mini_br_length);
	curr_branche = calc_position_noeuds(debut->v1, debut, curr_branche, mini_br_length);
	mem_line(&debut->position, &debut->v1->position, debut->v1, 
		curr_branche);
	curr_branche++;
	}
if(debut->v2 != parent && debut->v2 != NULL ) {
	debut->v2->position = calc_point_direction( &(debut->position), &(debut->v2->position), debut->l2, mini_br_length);
	curr_branche = calc_position_noeuds(debut->v2, debut, curr_branche, mini_br_length);
	mem_line(&debut->position, &debut->v2->position, debut->v2, 
		curr_branche);
	curr_branche++;
	}
if(debut->v3 != parent && debut->v3 != NULL ) {
	debut->v3->position = calc_point_direction( &(debut->position), &(debut->v3->position), debut->l3, mini_br_length);
	curr_branche = calc_position_noeuds(debut->v3, debut, curr_branche, mini_br_length);
	mem_line(&debut->position, &debut->v3->position, debut->v3, 
		curr_branche);
	curr_branche++;
	}
return curr_branche;
}


void mem_line(cp_point *debut, cp_point *fin, bignoeud *noeud_term, unrooted_branch *br)
{
br->debut = *debut;
br->fin = *fin;
br->nom = noeud_term->nom;
}


void free_bignoeud(bignoeud *debut, bignoeud *parent)
{
	if(debut == NULL) return;
	if(debut->v1 != parent) {
		free_bignoeud(debut->v1, debut);
	}
	if(debut->v2 != parent) {
		free_bignoeud(debut->v2, debut);
	}
	if(debut->v3 != parent) {
		free_bignoeud(debut->v3, debut);
	}
//	no need to free debut->nom because done by free(data->tabtax[i]->nom)
	free(debut);
}


int chg_phys(FD_unrooted *ob, hits_field hits, int char_height)
{
int encore = FALSE;
const float delta = 0.05;
int value;
static int lr = 0, tb = 0, oldvaluex = 0, oldvaluey = 0;

if(hits.left == 1 && hits.right == 0) {
	if(oldvaluex == 0) value = (int)((ob->phys_max_x - ob->phys_min_x) * delta); 
	else value = oldvaluex;
	if(value < 2) value = 2;
	if(lr == 2) { /* alternance left/right */
		if(oldvaluex <= 2) {
			hits.right = 1;
			return chg_phys(ob, hits, char_height);
			}
		value = oldvaluex/2; 
		}
	lr = 1;
	oldvaluex = value;
	ob->phys_min_x += value;
	ob->phys_max_x += value;
	if(ob->phys_max_x <= ob->phys_min_x) {
		ob->phys_max_x = ob->phys_min_x + 1;
		return FALSE;
		}
	encore = TRUE;
	}
else if(hits.left == 0 && hits.right == 1) {
	if(oldvaluex == 0) value = (int)((ob->phys_max_x - ob->phys_min_x) * delta); 
	else value = oldvaluex;
	if(value < 2) value = 2;
	if(lr == 1) { /* alternance left/right */
		if(oldvaluex <= 2) {
			hits.left = 1;
			return chg_phys(ob, hits, char_height);
			}
		value = oldvaluex/2; 
		}
	lr = 2;
	oldvaluex = value;
	ob->phys_max_x -= value;
	ob->phys_min_x -= value;
	if(ob->phys_max_x <= ob->phys_min_x) {
		ob->phys_max_x = ob->phys_min_x + 1;
		return FALSE;
		}
	encore = TRUE;
	}
else if(hits.left == 1 && hits.right == 1) {
	lr = tb = 0;
	oldvaluex = 0;
	value = (int)((ob->phys_max_x - ob->phys_min_x) * delta / 2); 
	if(value < 2) value = 2;
	ob->phys_min_x += value;
	ob->phys_max_x -= value;
	if(ob->phys_max_x <= ob->phys_min_x) {
		ob->phys_max_x = ob->phys_min_x + 1;
		return FALSE;
		}
	encore = TRUE;
	ob->phys_max_y = ob->phys_min_y + (ob->phys_max_x - ob->phys_min_x);
	}

if(hits.top == 0 && hits.bottom == 1) {
	if(oldvaluey == 0) value = (int)((ob->phys_max_y - ob->phys_min_y) * delta); 
	else value = oldvaluey;
	if(value < 2) value = 2;
	if(tb == 2) {
		if(oldvaluey <= 2) {
			hits.top = 1;
			return chg_phys(ob, hits, char_height);
			}
		value = oldvaluey/2; 
		}
	tb = 1;
	oldvaluey = value;
	ob->phys_max_y -= value;
	ob->phys_min_y -= value;
	if(ob->phys_max_y <= ob->phys_min_y) {
		ob->phys_max_y = ob->phys_min_y + 1;
		return FALSE;
		}
	encore = TRUE;
	}
else if(hits.top == 1 && hits.bottom == 0) {
	if(oldvaluey == 0) value = (int)((ob->phys_max_y - ob->phys_min_y) * delta); 
	else value = oldvaluey;
	if(value < 2) value = 2;
	if(tb == 1) {
		if(oldvaluey <= 2) {
			hits.bottom = 1;
			return chg_phys(ob, hits, char_height);
			}
		value = oldvaluey/2; 
		}
	tb = 2;
	oldvaluey = value;
	ob->phys_min_y += value;
	ob->phys_max_y += value;
	if(ob->phys_max_y <= ob->phys_min_y) {
		ob->phys_max_y = ob->phys_min_y + 1;
		return FALSE;
		}
	encore = TRUE;
	}
else if(hits.top == 1 && hits.bottom == 1) {
	value = (int)((ob->phys_max_y - ob->phys_min_y) * delta/2); 
	if(value < 2) value = 2;
	lr = tb = 0;
	oldvaluey = 0;
	ob->phys_min_y += value;
	ob->phys_max_y -= value;
	if(ob->phys_max_y <= ob->phys_min_y) {
		ob->phys_max_y = ob->phys_min_y + 1;
		return FALSE;
		}
	encore = TRUE;
	ob->phys_max_x = ob->phys_min_x + (ob->phys_max_y - ob->phys_min_y);
	}

return encore;
}


void log_to_phys(FD_unrooted *data, cp_point *log_pos, cp_point *phys_pos)
{
double factorx, factory;

factorx = (data->phys_max_x - data->phys_min_x) / (data->log_max_x - data->log_min_x);
factory = (data->phys_max_y - data->phys_min_y) / (data->log_max_y - data->log_min_y);
phys_pos->x = factorx * ( log_pos->x - data->log_min_x ) + data->phys_min_x;
phys_pos->y = factory * ( log_pos->y - data->log_min_y ) + data->phys_min_y;
}


double length_log_phys(FD_unrooted *data, double p)
{
double factor;
factor = (data->phys_max_x - data->phys_min_x) / (data->log_max_x - data->log_min_x);
return p * factor;
}

double length_phys_log(FD_unrooted *data, double p)
{
double factor;
factor = (data->phys_max_x - data->phys_min_x) / (data->log_max_x - data->log_min_x);
return  p / factor;
}


double calc_echelle(FD_unrooted *data, int larg)
{ /* rend taille logique pour echelle optimale */
double log_val, phys_val;
phys_val = larg/10;
log_val = length_phys_log(data, phys_val);
log_val = arrondi_echelle(log_val);
return log_val;
}



